set(HeaderFiles_Public_Headers "Public/DataStore.h"
                               "Public/DataIndexNode.h"
                               "Public/DataQuery.h")

set(HeaderFiles_Headers "stdafx.h")

set(SourceFiles_Sources "DataStore.cpp"
                        "DataIndexNode.cpp"
                        "DataQuery.cpp")

ADD_PRECOMPILED_HEADER("stdafx.h" "stdafx.cpp" SourceFiles_Sources)

FILE(GLOB CMakeIncludes CMakeIncludes//*.cmake)

source_group("CMake Includes" FILES ${CMakeIncludes})

set(SOURCES ${SOURCES} ${CMakeIncludes} ${HeaderFiles_Headers} ${SourceFiles_Sources} ${HeaderFiles_Public_Headers})

ShipSources(FILES ${SOURCES} CMakeLists.txt)

if(WIN32)
    configure_file(
      ${MAIN_ROOT}/${INCLUDE_DIR}/resource_template.rc
      ${CMAKE_CURRENT_BINARY_DIR}/Generated/resource.rc
      @ONLY)

    set(ResourceFiles "./Generated/resource.rc")
    set(SOURCES ${SOURCES} ${ResourceFiles})
    source_group("Resource Files" FILES ${ResourceFiles})
endif()
