/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#include "stdafx.h"
#include "Public/DataStore.h"

#if CONFIG_INCLUDE_STRUCTUREDDATA_ENCRYPTION_SUPPORT
#include <Obfuscate.h>
#endif

#include <PushNewOverride.h>
#include <boost/algorithm/string.hpp>
#include <boost/filesystem.hpp>
#include <PopNewOverride.h>

DataIndexNode::DataIndexNode(DataStore& dataStore) :
    _dataStore(&dataStore),
    _nodes()
{
}

void DataIndexNode::AddDocumentPath(const std::string& filePath)
{
    _documentPaths.insert(filePath);
}

void DataIndexNode::AddElement(DataElement& element)
{
    _elements.insert(&element);
}

const DataElement::Set& DataIndexNode::Elements()
{
    // Add any XML documents which belong to this index node by have not yet
    // been loaded and keep track of all exceptions
    std::vector<DataStoreException> exceptions;
    for (const std::string& filePath : _documentPaths)
    {
        try
        {
			boost::filesystem::path path(filePath);

			bool encrypted = false;

			// Skip non-XML files
			std::string extension = path.extension().string();
			if (!boost::iequals(extension, ".xml"))
			{
#if CONFIG_INCLUDE_STRUCTUREDDATA_ENCRYPTION_SUPPORT
				std::string deobfuscatedName = Obfuscate::ObfuscateOrDeobfuscateString(path.filename().string());

				if (!boost::iequals(boost::filesystem::path(deobfuscatedName).extension().string(), ".xml"))
				{
					continue;
				}
				else
				{
					encrypted = true;
				}
#else
                continue;
#endif
			}

            _dataStore->AddDocument(filePath, encrypted, false, exceptions);
        }
        catch (DataStoreException& exception)
        {
            exceptions.push_back(exception);
        }
    }
    _documentPaths.clear();

    // If an exception occurred while loading the unloaded XML then throw the
    // first encountered exceptions
    if (!exceptions.empty())
    {
        throw exceptions.front();
    }

    return _elements;
}

DataIndexNode* DataIndexNode::Find(const std::string& value)
{
    DataIndexNode* result = nullptr;

    auto it = _nodes.find(value);
    if (it != _nodes.end())
    {
        result = it->second.get();
    }

    return result;
}

DataIndexNode& DataIndexNode::FindOrCreate(const std::string& value)
{
    DataIndexNode* result = Find(value);

    if (!result)
    {
        auto node = std::make_shared<DataIndexNode>(*_dataStore);
        result = node.get();
        _nodes[value] = node;
    }

    return *result;
}

std::vector<std::string> DataIndexNode::KeyValues() const
{
    std::vector<std::string> keyValues;
    for (auto& pair : _nodes)
    {
        keyValues.push_back(pair.first);
    }
    return keyValues;
}
