﻿/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#include "stdafx.h"
#include "StructuredData.h"

#include <cctype>
#include <cstdlib>

#include <PushNewOverride.h>
#include <boost/algorithm/string.hpp>
#include <PopNewOverride.h>

using namespace boost::algorithm;

const std::string& DataAttribute::Value() const
{
    return _value;
}

void DataAttribute::SetValue(const std::string& value)
{
    _value = value;
}

bool DataAttribute::ToBool(bool defaultValue) const
{
    if (_CaseInsensitiveCompare(_value, "true") || _CaseInsensitiveCompare(_value, "1"))
    {
        return true;
    }

    if (_CaseInsensitiveCompare(_value, "false") || _CaseInsensitiveCompare(_value, "0"))
    {
        return false;
    }

    return defaultValue;
}

int8_t DataAttribute::ToInt8(int8_t defaultValue) const
{
    return _ParseInt<int8_t>(defaultValue, true);
}

int16_t DataAttribute::ToInt16(int16_t defaultValue) const
{
    return _ParseInt<int16_t>(defaultValue, true);
}

int32_t DataAttribute::ToInt32(int32_t defaultValue) const
{
    return _ParseInt<int32_t>(defaultValue, true);
}

int64_t DataAttribute::ToInt64(int64_t defaultValue) const
{
    return _ParseInt<int64_t>(defaultValue, false);
}

uint8_t DataAttribute::ToUInt8(uint8_t defaultValue) const
{
    return _ParseInt<uint8_t>(defaultValue, true);
}

uint16_t DataAttribute::ToUInt16(uint16_t defaultValue) const
{
    return _ParseInt<uint16_t>(defaultValue, true);
}

uint32_t DataAttribute::ToUInt32(uint32_t defaultValue) const
{
    return _ParseInt<uint32_t>(defaultValue, true);
}

uint64_t DataAttribute::ToUInt64(uint64_t defaultValue) const
{
    return _ParseInt<uint64_t>(defaultValue, false);
}

Frequency DataAttribute::ToFrequency(Frequency defaultValue) const
{
    try
    {
        return Frequency(_value);
    }
    catch(std::invalid_argument&)
    {
        return defaultValue;
    }
}

std::vector<std::string> DataAttribute::ToCommaSeparatedList() const
{
    std::vector<std::string> values;
    split(values, _value, is_any_of(","), token_compress_on);
    return values;
}

DataAttribute* DataAttribute::NextSibling() const
{
    if (!_parent)
    {
        // The attribute has no parent element, so there can be no sibling
        return nullptr;
    }
    else
    {
        if (_position + 1 >= _parent->_attributes.size())
        {
            // This is the last attribute of the parent element
            return nullptr;
        }
        else
        {
            // Return the next attribute of the parent element
            return _parent->_attributes[_position + 1];
        }
    }
}

void DataAttribute::ResolveParameter(const std::string& parameterName, const std::string& parameterValue)
{
    const std::string parameterPlaceholder = "$(" + parameterName + ")";

    // For each potential occurrence of the parameter placeholder
    for (size_t i = 0;; i += parameterValue.length())
    {
        // Find the position of the next occurrence of the placeholder
        i = _value.find(parameterPlaceholder, i);

        // Break out of the loop if it was not found
        if (i == std::string::npos)
            break;

        // Replace the placeholder with the parameter value
        _value.erase(i, parameterPlaceholder.length());
        _value.insert(i, parameterValue);
    }
}

DataAttribute::DataAttribute(const std::string& name, const std::string& value, DataElement* parent, size_t position) :
    DataNode(name),
    _parent(parent),
    _position(position),
    _value(value)
{
}

bool DataAttribute::_CaseInsensitiveCompare(const std::string& left, const std::string& right)
{
    if (left.length() == right.length())
    {
        return std::equal(right.begin(), right.end(), left.begin(), _ComparePredicate);
    }

    return false;
}

bool DataAttribute::_ComparePredicate(unsigned char a, unsigned char b)
{
    return std::tolower(a) == std::tolower(b);
}
