/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#include "stdafx.h"
#include "StructuredData.h"

const std::string& DataProcessingInstruction::Target() const
{
	return _target;
}

const std::string& DataProcessingInstruction::Data() const
{
	return _data;
}

unsigned DataProcessingInstruction::LineNumber() const
{
	return _lineNumber;
}

void DataProcessingInstruction::SetLineNumber(unsigned lineNumber)
{
	_lineNumber = lineNumber;
}

size_t DataProcessingInstruction::Position() const
{
	return _position;
}

DataProcessingInstruction* DataProcessingInstruction::NextSibling() const
{
	const std::vector<std::shared_ptr<DataProcessingInstruction>>& instructions = _doc->GetProcessingInstructions();

	if (_position + 1 >= instructions.size())
    {
        // This is the last instruction
        return nullptr;
    }
    else
    {
        // Return the next instruction
        return instructions[_position + 1].get();
    }
}

