/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
///
/// @page Overview_StructuredData Overview: StructuredData Foundation Library
///
/// The StructuredData foundation library provides the functionality for
/// constructing and parsing structured data to/from XML files.
///
/// The library consists 4 major classes:
///     - DataDocument: A document of hierarchically structured data which can
///                     be loaded/saved to XML.
///     - DataElement: An element within a DataDocument (analogous to an XML
///                    element).
///     - DataAttribute: An attribute within a DataElement (analogous to an
///                      XML element).
///     - DataStore: A virtual collection of DataDocument which can be
///                  queried.
///
//////////////////////////////////////////////////////////////////////////////
#pragma once

#if defined(HOST_WINDOWS)
    #if defined(STRUCTUREDDATA_EXPORTS)
        #define STRUCTUREDDATA_API __declspec(dllexport)
    #elif defined(STRUCTUREDDATA_IMPORTS)
        #define STRUCTUREDDATA_API __declspec(dllimport)
    #else
        #define STRUCTUREDDATA_API
    #endif
#else
    #if defined(STRUCTUREDDATA_EXPORTS) || defined(STRUCTUREDDATA_IMPORTS)
        #define STRUCTUREDDATA_API __attribute__ ((visibility("default")))
    #else
        #define STRUCTUREDDATA_API
    #endif
#endif

#include <map>
#include <memory>
#include <mutex>
#include <string>
#include <set>
#include <vector>
#include <functional>

#ifdef _MSC_VER
	// Disable the DLL interface warning for STL usage
	#pragma warning( push )
	#pragma warning( disable : 4251 )
#endif

#include "DataStoreException.h"
#include "BinException.h"
#include "XmlException.h"
#include "DataNode.h"
#include "DataAttribute.h"
#include "DataElement.h"
#include "DataProcessingInstruction.h"
#include "DataDocument.h"

#include "StructuredDataMacros.h"

#ifdef _MSC_VER
	#pragma warning( pop )
#endif
