﻿/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#include "stdafx.h"
#include "StructuredData.h"

#include <sstream>

XmlLoadException::XmlLoadException(const std::string& message) :
_lineNumber(0)
{
    std::stringstream ss;
    ss << "Failed to load XML: " << message;
    SetMessage(ss.str());
}

XmlLoadException::XmlLoadException(const std::string& message, const std::string& filePath, size_t lineNumber) :
    _lineNumber(lineNumber),
    _filePath(filePath)
{
    std::stringstream ss;

    if (filePath != "")
    {
        ss << "Failed to load XML file '" << filePath << "': " << message;
    }
    else
    {
        ss << "Failed to load XML: " << message;
    }

    if (lineNumber > 0)
    {
        ss << " on line " << lineNumber;
    }
    
    SetMessage(ss.str());
}

bool XmlLoadException::HasLineNumber() const
{
    return _lineNumber != 0;
}

size_t XmlLoadException::LineNumber() const
{
    return _lineNumber;
}

bool XmlLoadException::HasFilePath() const
{
    return _filePath != "";
}

const std::string& XmlLoadException::FilePath() const
{
    return _filePath;
}

XmlSaveException::XmlSaveException(const std::string& message)
{
    std::stringstream ss;
    ss << "Failed to save XML: " << message;
    SetMessage(ss.str());
}
