/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

#include "ProbeTypes.h"

class PluginNotifications
{
private:
    PPI_NotificationLevel _level;

    PluginNotificationCallbackHandler _notificationHandlerFunction;

public:
    PluginNotifications() :
        _level(PPI_noNotification),
        _notificationHandlerFunction(nullptr)
    {
    }

    void Level(PPI_NotificationLevel level)
    {
        _level = level;
    }

    OpenIPC_Error Handler(PluginNotificationCallbackHandler notificationHandlerFunction);

    template <typename TFunc>
    void Notify(OpenIPC_DeviceId deviceId, OpenIPC_Error errorCode, PPI_NotificationLevel level, const TFunc& fn)
    {
        if (IsNotificationEnabled(level))
        {
            std::stringstream ss;
            fn(ss);

            std::string message = ss.str();
            _notificationHandlerFunction(deviceId, level, errorCode, message.c_str());
        }
    }

    bool IsNotificationEnabled(PPI_NotificationLevel level)
    {
        return level >= _level && _notificationHandlerFunction != nullptr;
    }

    void Clear()
    {
        _level = PPI_noNotification;
        _notificationHandlerFunction = nullptr;
    }

    static PluginNotifications& GetInstance()
    {
        static PluginNotifications _instance;
        return _instance;
    }
};
