/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

#include <Foundation/Error/Error.h>

#if defined(HOST_WINDOWS)
    #define MISSING_PROBE_ERROR_STRING "No target access device was detected, Please check Device Manager for the presence of hardware"
#elif defined(HOST_LINUX)
    #define MISSING_PROBE_ERROR_STRING "No target access device was detected, Please check lsusb for the presence of hardware"
#elif defined(HOST_DARWIN)
    #define MISSING_PROBE_ERROR_STRING "No target access device was detected, Please check System Report for the presence of hardware"
#else
    #error "No host type specified"
#endif

#define COMMON_ERRORS \
    ERRORDEF(Null_Pointer,                    0, "An argument is NULL when it should not be") \
    ERRORDEF(Bad_Argument,                    1, "An argument did not contain an expected value") \
    ERRORDEF(Not_Supported,                   2, "The function or operation is not supported") \
    ERRORDEF(Not_Implemented,                 3, "The function or operation is not yet implemented") \
    ERRORDEF(Obsolete,                        4, "The function or operation is obsolete and will not work") \
    ERRORDEF(Invalid_Device_ID,               5, "The device ID does not correspond to any known device") \
    ERRORDEF(Invalid_Address_Type,            6, "The type of the address is not recognized") \
    ERRORDEF(Invalid_Address,                 7, "The address is not recognized as an address") \
    ERRORDEF(Not_A_Thread,                    8, "The device ID does not correspond to a thread") \
    ERRORDEF(Internal_Error,                  9, "An unknown error occurred") \
    ERRORDEF(Structure_Size_Not_Initialized, 10, "Structure size field is not set") \
    ERRORDEF(Initialization_Failed,          11, "OpenIPC failed to initialize") \
    ERRORDEF(Not_A_GPC_Thread,               12, "The device ID does not correspond to a GPC thread") \
    ERRORDEF(Invalid_Device,                 13, "The specified device cannot be used with the operation") \
    ERRORDEF(Invalid_Argument,               14, "The argument is not valid") \
    ERRORDEF(No_Suitable_Port,               16, "The OpenIPC server failed to find a free port to bind to") \
    ERRORDEF(Cannot_Bind_To_Port,            17, "The OpenIPC server failed to bind to the given port") \
    ERRORDEF(Cannot_Open_File,               18, "The given file cannot be opened") \
    ERRORDEF(Already_Initialized,            19, "The OpenIPC server has already been initialized") \
    ERRORDEF(Missing_Probe,                  22, MISSING_PROBE_ERROR_STRING) \
    ERRORDEF(File_Already_Exists,            23, "The given file already exists")

#define ERRORDEF(name, value, string) ERROR_ENUM(Common, name, value)
enum { COMMON_ERRORS };
#undef ERRORDEF
