/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
///
/// @page Overview_Configuration Overview: Configuration Component
///
/// The Configuration component provides configuration functionality.
///
/// See OpenIPC_ConfigurationComponent for details of the Configuration functions.
///
//////////////////////////////////////////////////////////////////////////////

#pragma once

#if defined(HOST_WINDOWS)
#   if defined(CONFIGURATION_EXPORTS)
        #       define EXPORT_CONFIGURATION_API __declspec(dllexport)
#   else
        #       define EXPORT_CONFIGURATION_API __declspec(dllimport)
#   endif
#else
    #   define EXPORT_CONFIGURATION_API __attribute__ ((visibility("default")))
#endif

#include <Components/Configuration/ConfigurationTypes.h>
#include <Components/Configuration/ConfigurationErrors.h>

#include <Foundation/Error/Error.h>
#include <Foundation/Types.h>

///
/// @brief Represents the Configuration component.
struct OpenIPC_ConfigurationComponent
{
    ///
    /// @brief Selects the given configuration file to be used when initializing.
    OpenIPC_ConfigurationSelectByFile_Function SelectByFile;

    ///
    /// @brief Selects the given configuration by name to be used when
    ///        initializing.
    OpenIPC_ConfigurationSelectByName_Function SelectByName;

    ///
    /// @brief Loads the probe configuration of the specified name.
    OpenIPC_ConfigurationLoadProbeConfiguration_Function LoadProbeConfiguration;

    ///
    /// @brief Sets whether automatic configuration is enabled.
    OpenIPC_ConfigurationSetAutomaticConfigurationEnabled_Function SetAutomaticConfigurationEnabled;

    ///
    /// @brief Returns whether automatic configuration is enabled.
    OpenIPC_ConfigurationIsAutomaticConfigurationEnabled_Function IsAutomaticConfigurationEnabled;

    ///
    /// @brief Sets the parameters for the selected configuration.
    OpenIPC_ConfigurationSetParameterValues_Function SetParameterValues;

    ///
    /// @brief Finalizes the selected configuration with the specified parameters.
    OpenIPC_ConfigurationFinalize_Function Finalize;

    ///
    /// @brief Resets the configuration, allowing it to be selected, modified,
    OpenIPC_ConfigurationReset_Function Reset;

    ///
    /// @brief Gets the name of the selected configuration.
    OpenIPC_ConfigurationGetName_Function GetName;

    ///
    /// @brief Gets the primary element of the selected configuration.
    OpenIPC_ConfigurationGetPrimaryElement_Function GetPrimaryElement;

    ///
    /// @brief Gets the probe element of the selected configuration.
    OpenIPC_ConfigurationGetProbeElement_Function GetProbeElement;

    ///
    /// @brief Gets the probe element of the selected configuration for the
    ///        specified probe plug-in.
    OpenIPC_ConfigurationGetProbePluginElement_Function GetProbePluginElement;

    ///
    /// @brief Gets the run control element of the selected configuration.
    OpenIPC_ConfigurationGetRunControlElement_Function GetRunControlElement;

    ///
    /// @brief Gets the number of enabled probe plug-ins in the selected
    ///        configuration.
    OpenIPC_ConfigurationGetEnabledProbePluginCount_Function GetEnabledProbePluginCount;

    ///
    /// @brief Gets the names of enabled probe plug-ins in the selected
    ///        configuration.
    OpenIPC_ConfigurationGetEnabledProbePluginNames_Function GetEnabledProbePluginNames;

    ///
    /// @brief Gets the number of enabled run control plug-ins in the selected
    ///        configuration.
    OpenIPC_ConfigurationGetEnabledRunControlPluginCount_Function GetEnabledRunControlPluginCount;

    ///
    /// @brief Gets the names of enabled run control plug-ins in the selected
    ///        configuration.
    OpenIPC_ConfigurationGetEnabledRunControlPluginNames_Function GetEnabledRunControlPluginNames;
};

extern "C"
{
///
/// @brief Gets the Configuration component.
///
/// @param[out] component
///     A pointer to a structure of function pointers representing the component.
///
/// @return (OpenIPC_Error): A code indicating success or failure.
/// @retval OpenIPC_Error_No_Error
///     Indicates success.
/// @retval OpenIPC_Error_Null_Pointer
///     A parameter is NULL.
///
    EXPORT_CONFIGURATION_API OpenIPC_Error OpenIPC_GetConfiguration(OpenIPC_ConfigurationComponent** component);
};
