//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
// 
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
///  @file
///
///  @brief Declaration of the types used by the BitData DLL.
///
/// These are in a separate file from the BitData.h file so that the static
/// library can load this file as well.
///
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include <Foundation/Types.h>

typedef uint32_t BITDATA_ERROR;

// this gives us a window into the value to look at in the debugger
typedef uint64_t dbgvalue[32];

typedef struct BitData
{
	uint64_t	bitsize;
	uint64_t	bitcapacity;
	union{
		dbgvalue*	buffer64;
		void*		buffer;
	};
	void*	obj;
} BitData;

typedef struct OpenIPC_CrcDef
{
	uint32_t m_o4Width;
    uint32_t m_ao4CrcTable[256];
    uint32_t m_o4InitialValue;
    bool m_bReflectIn;
    bool m_bReflectOut;
    uint32_t m_o4XorOut;
} OpenIPC_CrcDef;


// This indicates that FindFirst() or FindLast() did not find any bits set.
const uint64_t c_o4NoBitSet = (uint64_t) - 1;
