﻿/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
///
/// @page Overview_Error Overview: Error Foundation Library
///
/// The Error foundation library provides the functionality for defining and
/// handling error codes/messages.
///
//////////////////////////////////////////////////////////////////////////////

#pragma once

#if defined(HOST_WINDOWS)
#   if defined(ERROR_EXPORTS)
#       define EXPORT_ERROR_API __declspec(dllexport)
#   else
#       define EXPORT_ERROR_API __declspec(dllimport)
#   endif
#else
#   define EXPORT_ERROR_API __attribute__ ((visibility("default")))
#endif

#include "ErrorTypes.h"

extern "C"
{
	EXPORT_ERROR_API OpenIPC_ErrorToken OpenIPC_ErrorEnterContex();

	EXPORT_ERROR_API void OpenIPC_ErrorExitContex(OpenIPC_ErrorToken token);

	EXPORT_ERROR_API void OpenIPC_ErrorGetErrorMessageSize(OpenIPC_ErrorToken token, uint32_t* messageSize);

	EXPORT_ERROR_API void OpenIPC_ErrorGetErrorMessage(OpenIPC_ErrorToken token, char* message, uint32_t messageSize);

	EXPORT_ERROR_API void OpenIPC_ErrorGetLastErrorMessageSize(OpenIPC_ErrorToken token, uint32_t* messageSize);

	EXPORT_ERROR_API void OpenIPC_ErrorGetLastErrorMessage(OpenIPC_ErrorToken token, char* message, uint32_t messageSize);

	EXPORT_ERROR_API OpenIPC_Error OpenIPC_ErrorGetErrorCode(OpenIPC_ErrorToken token);

	EXPORT_ERROR_API void OpenIPC_ErrorPostError(OpenIPC_Error errorCode, const char* message, const char* sourceFile, unsigned sourceLineNumber);

	EXPORT_ERROR_API void OpenIPC_ErrorSetDefaultMessage(OpenIPC_Error error, const char* message);

	EXPORT_ERROR_API const char* OpenIPC_ErrorGetDefaultMessage(OpenIPC_Error error);

    EXPORT_ERROR_API OpenIPC_Bool OpenIPC_ErrorOccurred(OpenIPC_ErrorToken token, OpenIPC_Error errorCode);
};
