/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
///
//////////////////////////////////////////////////////////////////////////////
#pragma once

#include <string>
#include <memory>
#include <sstream>

///
/// @brief Posts an error to an error server for a component.
#define POST_ERROR(errorCode) \
    OpenIPC_ErrorPostError(errorCode, "", __FILE__, __LINE__)

///
/// @brief Posts an error with a specific message to an error server for a
/// component.
#define POST_ERROR_MESSAGE(errorCode, FUNC) \
    { \
        std::stringstream stream; /* local name must be unique from whatever the caller gives this macro! */ \
        stream << FUNC; \
        OpenIPC_ErrorPostError(errorCode, stream.str().c_str(), __FILE__, __LINE__); \
    }

///
/// @brief Posts an error to an error server for a component and throws it as an exception.
#define THROW_POSTED_EXCEPTION(errorCode) \
    do \
    { \
        OpenIPC_ErrorPostError(errorCode, "", __FILE__, __LINE__); \
        throw OpenIPC_Error_Exception(errorCode); \
    } \
    while(0)

///
/// @brief Posts an error with a specified messate to an error server for a
/// component and throws it as an exception.
#define THROW_POSTED_EXCEPTION_MESSAGE(errorCode, FUNC) \
    do \
    { \
        std::stringstream stream; /* local name must be unique from whatever the caller gives this macro! */ \
        stream << FUNC; \
        OpenIPC_ErrorPostError(errorCode, stream.str().c_str(), __FILE__, __LINE__); \
        throw OpenIPC_Error_Exception(errorCode); \
    } \
    while(0)


///
/// @brief Defines the static error messages for errors.
#define DEFINE_ERRORS(component, errors) \
    static struct Static_##component \
    { \
        Static_##component() \
        { \
            errors \
        } \
    } static_##component;

///
/// @brief Sets the default error message for an error.
#define DEFINE_ERROR(name, message)\
    OpenIPC_ErrorSetDefaultMessage(OpenIPC_Error_##name, message);

