/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
///
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include <Foundation/Types.h>

typedef void* OpenIPC_ErrorToken;

///
/// @brief An OpenIPC error code.
typedef unsigned OpenIPC_Error;

#define OPENIPC_ERROR_COMPONENTS \
    OPENIPC_ERROR_COMPONENT(DeviceControl) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Common) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Authorization) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Jtag) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(OperationReceipt) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Probe) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(RunControl) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(ExecutionControl) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Break) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Breakpoint) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(BreakpointManagement) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Memory) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Register) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(TargetManager) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(ScanEngine) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(TargetData) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(StatePort) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(ProbeVendorAPI) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(IpcInterface) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(BitData) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(InterfacePort) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(ProbePlugin) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(I2c) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(InterfacePins)  OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Rpc) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Precondition) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(PlatformControl) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(ExecutionControlPlugin) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(RegisterPlugin) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(BreakManagerPlugin) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(MemoryPlugin) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(AsmDasmPlugin) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(AsmDasm) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(EventBroker) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(ProbeModeRegister) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(NamedState) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(DMA) OPENIPC_ERROR_LIST_NEXT \
    OPENIPC_ERROR_COMPONENT(Configuration)

// Create IDs for all Loggers.
#define OPENIPC_ERROR_LIST_NEXT ,
#define OPENIPC_ERROR_COMPONENT(NAME) OpenIPC_Component_##NAME \

///
/// @brief An enumeration of all of the OpenIPC components.
///
/// @remarks These values are used to compute the offsets of error code
/// values.
enum OpenIPC_Component
{
    OPENIPC_ERROR_COMPONENTS
};

#undef OPENIPC_ERROR_COMPONENT
#undef OPENIPC_ERROR_LIST_NEXT

///
/// @brief The error code used when no error has occurred.
const OpenIPC_Error OpenIPC_Error_No_Error = 0;

///
/// @brief A macro for testing if an error code is passing.
#define OpenIPC_PASS(error) ((error) == OpenIPC_Error_No_Error)

// Macro for defining an error enum name/value.
#define ERROR_ENUM(component, name, value) \
    OpenIPC_Error_##name = (((1 << 16) * (OpenIPC_Component_##component + 1)) + value),
