/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

#include <Foundation/Types.h>

typedef void* OpenIPC_LoggingToken;

///
/// @brief Indicates the severity level of a log message.
enum OpenIPC_LoggingSeverityLevel
{
    ///
    /// @brief Used for reporting developer-level information in the OpenIPC
    ///        that is high-noise.
    ///
    /// @note May include references to function/class names.
	OpenIPC_LoggingSeverityLevel_Trace,

    ///
    /// @brief Used for reporting developer-level information regarding the
    ///        state and actions of the OpenIPC that may be useful for a
    ///        developer.
    ///
    /// @note May include references to function/class names.
	OpenIPC_LoggingSeverityLevel_Debug,

    ///
    /// @brief Used for reporting user-level information regarding the state
    ///        and actions of the OpenIPC and the target under test that the
    ///        user would be interested in.
    ///
    /// @note Should not include references to internal function/class names.
    OpenIPC_LoggingSeverityLevel_Info,

    ///
    /// @brief Used for reporting user-level or developer-level information
    ///        about non-fatal errors or otherwise aberrant behavior in the
    ///        OpenIPC or the target.
    ///
    /// @note May include references to internal function/class names for
    ///       internal/systematic warnings; for target related warnings it
    ///       should not reference our architecture or function/class names.
    OpenIPC_LoggingSeverityLevel_Warning,

    ///
    /// @brief Used for asynchronous errors or errors that do not end up
    ///        bubbling up to an error code returning from a public function
    ///        (this should be rare, use POST_ERROR() instead).
    ///
    /// @note May include references to internal function/class names, though
    ///       it isn't very useful since posted error messages will
    ///       automatically have the source file + line number appended.
    OpenIPC_LoggingSeverityLevel_Error,

    ///
    /// @brief The level indicating that no messages are logged.
	OpenIPC_LoggingSeverityLevel_Off,
};

#define OPENIPC_LOGGER_IDS \
	OPENIPC_LOGGER_ID(IpcInterface) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(Common) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(ProbeModeRegister) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(Authorization) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(Jtag) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(OperationReceipt) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(Probe) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(RunControl) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(TargetManager) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(ScanEngine) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(StatePort) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(ProbeVendorAPI) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(ProbePluginImplementation) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(InterfacePort) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(I2c) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(Error) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(InterfacePins) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(DataStore) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(Precondition) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(PlatformControl) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(EventBroker) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(NamedState) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(ProbePluginAPI) OPENIPC_LOGGER_LIST_NEXT\
	OPENIPC_LOGGER_ID(DeviceControl) OPENIPC_LOGGER_LIST_NEXT \
	OPENIPC_LOGGER_ID(ProbePluginHardwareCommunication)  OPENIPC_LOGGER_LIST_NEXT \
    OPENIPC_LOGGER_ID(ProbePluginHardwareCommunicationBackend) OPENIPC_LOGGER_LIST_NEXT \
    OPENIPC_LOGGER_ID(Telemetry) OPENIPC_LOGGER_LIST_NEXT \
    OPENIPC_LOGGER_ID(Dma) OPENIPC_LOGGER_LIST_NEXT \
    OPENIPC_LOGGER_ID(Diagnostic) OPENIPC_LOGGER_LIST_NEXT \
    OPENIPC_LOGGER_ID(Configuration)

enum OpenIPC_LoggingLoggerId
{
	OpenIPC_LoggingLoggerId_Unknown,

// Create IDs for all Loggers.
#define OPENIPC_LOGGER_LIST_NEXT ,
#define OPENIPC_LOGGER_ID(NAME) OpenIPC_LoggingLoggerId_##NAME \

	OPENIPC_LOGGER_IDS

#undef OPENIPC_LOGGER_ID
#undef OPENIPC_LOGGER_LIST_NEXT
};
