﻿/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
///
//////////////////////////////////////////////////////////////////////////////
#pragma once

#include <cstddef>

//////////////////////////////////////////////////////////////////////////////
// Types and Constants
//////////////////////////////////////////////////////////////////////////////
#if defined(_MSC_VER) && _MSC_VER < 1600

///
/// @brief A numerical reference to a specific device.
typedef unsigned __int32 OpenIPC_DeviceId;

///
/// @brief A numerical reference to a specific breakpoint.
typedef unsigned __int32 OpenIPC_BreakpointId;

///
/// @brief A numerical reference to a operation.
typedef unsigned __int64 OpenIPC_Handle;

///
/// @brief Boolean type where 1 = true, 0 = false
typedef unsigned __int32 OpenIPC_Bool;

#else

#include <stdint.h>

///
/// @brief A numerical reference to a specific device.
typedef uint32_t         OpenIPC_DeviceId;

///
/// @brief A numerical reference to a specific breakpoint.
typedef uint32_t         OpenIPC_BreakpointId;

///
/// @brief A numerical reference to a operation.
typedef uint64_t         OpenIPC_Handle;

///
/// @brief Boolean type where 1 = true, 0 = false
typedef uint32_t         OpenIPC_Bool;

#endif

#define IN
#define OUT

///
/// @brief A value representing an invalid device ID.
#define OpenIPC_INVALID_DEVICE_ID           ((OpenIPC_DeviceId)(-1))

///
/// @brief A value representing an invalid handle.
#define OpenIPC_INVALID_HANDLE              ((OpenIPC_Handle)(-1))

///
/// @brief A value representing an infinite timeout.
#define OpenIPC_TIMEOUT_INFINITE            ((uint32_t)(-1))

///
/// @brief The maximum identifier name length allowed.
/// Note, the regular expression for valid identifiers is "[_a-zA-Z][_a-zA-Z0-9]{0,63}"
#define OpenIPC_MAX_IDENTIFIER_LENGTH       (64)
#define MAX_IDENTIFIER_LENGTH               OpenIPC_MAX_IDENTIFIER_LENGTH

const uint32_t  BITS_PER_QWORD      = 64;       // 64 bits per QWORD
const uint32_t  BITS_PER_DWORD      = 32;       // 32 bits per DWORD
const uint32_t  BITS_PER_WORD       = 16;       // 16 bits per WORD
const uint32_t  BITS_PER_BYTE       = 8;        // 8 bits per BYTE

const OpenIPC_Bool OpenIPC_TRUE     = 1;
const OpenIPC_Bool OpenIPC_FALSE    = 0;

#define BitsToUint64s(bits) ((uint32_t)(bits + 63) >> 6)
#define BitsToUint32s(bits) ((uint32_t)(bits + 31) >> 5)
#define BitsToUint16s(bits) ((uint32_t)(bits + 15) >> 4)
#define BitsToUint8s(bits) ((uint32_t)(bits + 7) >> 3)

// Create _WIDTH, _OFFSET, and _MASK constants for a given name of a bitfield
#define OpenIPC_CREATE_BITFIELD_CONSTANTS(type, name, width, offset) \
    const unsigned char name##_WIDTH = (width); \
    const type name##_OFFSET = (offset); \
    const type name##_MASK = ( (type)(((type)(1) << name##_WIDTH) - 1) << name##_OFFSET); \
    typedef type name##_TYPE;

// Create a bitfield value that can be ORed with the masked out field
#define OpenIPC_BITFIELD_VALUE(name,value) (name##_MASK & ((name##_TYPE)value << name##_OFFSET))

// extract a bitfield out of a value
#define OpenIPC_BITFIELD_GET(name,value) (((value) & name##_MASK) >> name##_OFFSET)

// write a single bitfield into a value
#define OpenIPC_BITFIELD_SET(variable,name,value) ((variable) = (name##_TYPE)(((variable) & ~name##_MASK) | BITFIELD_VALUE(name,(value), name##_TYPE)))

///
/// @brief Describes a kind of a device.
typedef struct OpenIPC_DeviceKind
{
    ///
    /// @brief The device type.
    const char* deviceType;

    ///
    /// @brief The device sub-type.
    const char* deviceSubType;

    ///
    /// @brief The device stepping.
    const char* deviceStepping;
} OpenIPC_DeviceKind;
