﻿/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
///
/// @brief Definition for macros used to specify the version.
///
//////////////////////////////////////////////////////////////////////////////

#pragma once

// Convert the argument to a string.
#define OpenIPC_QUOTE(name) #name

// Convert the value of the argument to a string.
//
// The following example produces "1" for OpenIPC_QUOTE(MACRONAME):
// #define MACRONAME 1
// OpenIPC_QUOTE(MACRONAME)
#define OpenIPC_STR(macro) OpenIPC_QUOTE(macro)

#define OpenIPC_VERSION_MAJOR			1
#define OpenIPC_VERSION_MINOR			0
#define OpenIPC_VERSION_BUILD			0
#define OpenIPC_VERSION_CLASSIFICATION	600

#define OpenIPC_CHANGESET				0

#define OpenIPC_BRANCH_NAME				"Main"

#ifdef HOST_WINDOWS
    // *********** WINDOWS-SPECIFIC CODE ***********
    #if HOST_X64
        #define OpenIPC_BITNESS					"x64"
    #else
        #define OpenIPC_BITNESS					"x86"
    #endif
#elif HOST_LINUX
    // *********** LINUX-SPECIFIC CODE ***********
    #if HOST_X64
        #define OpenIPC_BITNESS                 "x64"
    #else
        #define OpenIPC_BITNESS                 "x86"
    #endif
#elif HOST_DARWIN
    // *********** DARWIN-SPECIFIC CODE ***********
    #if HOST_X64
        #define OpenIPC_BITNESS                 "x64"
    #else
        #define OpenIPC_BITNESS                 "x86"
    #endif
#else
    error Platform not implemented
#endif
