#!/bin/bash
#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008-2015 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

. ./testslib.sh
ParseTestArguments $@

Print " " 4
Print "Dynamic CPU Core Allocation Control" 4 34
Print " " 4

scriptError=0
suppressCmdError=0 # compCode from response will be located in 'errorCode' variable

#STEP 1
domainId=0x00
GetMaxAllowedCPUPStateTState "$domainId"
cores=$(( $b5 ))
#STEP 2
if [[ $cores -gt 2 ]]; then
    newCores=$(( $cores - 2 ))
else
    newCores=$(( $cores + 2 ))
fi
SetMaxAllowedCPUPStateTState "0x00 $newCores 0x00"
sleep 1
#STEP 3
GetMaxAllowedCPUPStateTState "$domainId"
vcores=$(( $b5 ))
if [[ $vcores -ne $newCores ]]; then
    Print "Faild to set cores $vcores != $newCores" 4 31
    Print "TEST FAILED " 0 31
    exit 1
fi
#STEP 4
SetMaxAllowedCPUPStateTState "0x00 $cores 0x00"

if [ $scriptError -eq 1 ]; then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else 
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
    exit 0
fi
