#!/bin/bash
#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008-2014 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

. ./testslib.sh
ParseTestArguments $@

Print " " 4
Print "NM platform power limiting test" 4 34
Print " " 4

scriptError=0
suppressCmdError=0 # compCode from response will be located in 'errorCode' variable

# input parameters for command
manufId=0x157
mode=1
domainId=0x00
policyId=0x10
policyType=0x01
## STEP 1
# run load on platform
Print "Applying load to platform." 4
. ${applyPlatformLoadScript}
sleep 15
## STEP 2
GetNmCapabilities "$domainId $policyId"
if [ "$error" != "0" ]; then
  Print "GetNmCapabilities command failed! Response: $rsp" 0 31
  Print "TEST FAILED " 0 31
  . ${stopLoadScript}
  exit 1
fi
capMinPowerThermalTime=$(( 0x$c9$c8 ))

GetNMStatistics "$mode $domainId $policyType"
if [ "$error" != "0" ]; then
  Print "GetNmStatistics command failed! Response: $rsp" 0 31
  Print "TEST FAILED " 0 31
  . ${stopLoadScript}
  exit 1
fi
nmCurrentPowerRead=$(( 0x$b6$b5 ))
Print "GetNMStatistics current power read [W]: $nmCurrentPowerRead" 4

tempLimitDec=$(( nmCurrentPowerRead * 80 ))
tempLimitDec=$(( tempLimitDec / 100 ))
Print "The limit shall be set to: $tempLimitDec W" 4
printf -v tempLimit '%04X' $tempLimitDec

if [ "$capMinPowerThermalTime" -gt "$tempLimitDec" ]; then
  Print "Too low power draw. Can not set policy with target limit lower than min power read by GetNmCapabilities command." 0 31
  Print "TEST FAILED " 0 31
  . ${stopLoadScript}
  exit 1
fi

## STEP 3
# set parameterList [list 000157 10 01 10 00 003C 00001770 0000 000A $commandGroup]
domainId=0x10
policyId=0x01
policyType=0x10
policyExceptionActions=0x00
policyTargetLimit=0x$tempLimit
pTaLiH=$(( policyTargetLimit & 0xFF00 ))
pTaLiH=`expr $pTaLiH / 255`
printf -v pTaLiH '0x%02X' $pTaLiH
pTaLiL=$(( policyTargetLimit & 0x00FF ))
printf -v pTaLiL '0x%02X' $pTaLiL
correctionTimeLimit=0x00001770
#divide correctionTimeLimit to bytes
cTlB0=0x70
cTlB1=0x17
cTlB2=0x00
cTlB3=0x00
pTriLB0=0x00
pTriLB1=0x00
statPerB0=0x0A
statPerB1=0x00
SetNMPolicy "$domainId $policyId $policyType $policyExceptionActions $pTaLiL $pTaLiH $cTlB0 $cTlB1 $cTlB2 $cTlB3 $pTriLB0 $pTriLB1 $statPerB0 $statPerB1"
## STEP 4
EnDisNMPolicyControl "0x01 0x00 0x00"
sleep 4
EnDisNMPolicyControl "0x03 0x00 0x00"
sleep 6
## STEP 5
mode=1
domainId=0x00
policyId=0x10
GetNMStatistics "$mode $domainId $policyId"
if [ "$error" != "0" ]; then
  Print "GetNmStatistics command failed! Response: $rsp" 0 31
  Print "TEST FAILED " 0 31
  # delete the created earlier policy
  domainId=0x00
  policyId=0x01
  SetNMPolicy "$domainId $policyId $policyType $policyExceptionActions $pTaLiL $pTaLiH $cTlB0 $cTlB1 $cTlB2 $cTlB3 $pTriLB0 $pTriLB1 $statPerB0 $statPerB1"
  EnDisNMPolicyControl "0x02 0x00 0x00"
  EnDisNMPolicyControl "0x00 0x00 0x00"
  . ${stopLoadScript}
  exit 1
fi
nmCurrentPowerRead=$(( 0x$b6$b5 ))
Print "GetNMStatistics current power read [W]: $nmCurrentPowerRead" 4
Print "TempLimit [W]: $tempLimitDec" 4
upperLimit=$(( tempLimitDec * 1025 ))
upperLimit=$(( upperLimit / 1000 ))
lowerLimit=$(( tempLimitDec * 975 ))
lowerLimit=$(( lowerLimit / 1000 ))
Print "upperLimit [W]: $upperLimit ; lowerLimit [W]: $lowerLimit " 4

if [ $nmCurrentPowerRead -lt $lowerLimit ] || [ $nmCurrentPowerRead -gt $upperLimit ]; then
  Print "Current power read ($nmCurrentPowerRead) not within expected range ($lowerLimit to $upperLimit)!" 0 31
  scriptError=1
else
  Print "Current power read is within expected range." 4 34   
fi

# just in case kill the power load tools
Print "Killing cpu and mem load processes on target DUT." 4
. ${stopLoadScript}

# delete the created earlier policy
Print "Removing created earlier policy." 4
domainId=0x00
policyId=0x01
SetNMPolicy "$domainId $policyId $policyType $policyExceptionActions $pTaLiL $pTaLiH $cTlB0 $cTlB1 $cTlB2 $cTlB3 $pTriLB0 $pTriLB1 $statPerB0 $statPerB1"
EnDisNMPolicyControl "0x02 0x00 0x00"
EnDisNMPolicyControl "0x00 0x00 0x00"

if [ $scriptError -eq 1 ]; then
  Print " " 0
  Print "TEST FAILED " 0 31
  Print " " 0
  exit 1
else 
  Print " " 4
  Print "TEST PASSED " 4 34
  Print " " 4
  exit 0
fi
