import sys
import os
import time
import utils # internal utilities file
import platform
from build_utils import logger
import build_post_process

# from build_utils import fw_repos_ver


def error(s, kill=False):
	logger.error(s)
	if kill:
		# os.system("pause")
		sys.exit(1)


class release_fw(object):
	def __init__(self, xml_file = "", to_rebuild_all=False, to_kw_build=False):
		self.conf_out_file_path_name = "C:/TEMP/MT_Batch_Build_Conf_Output.txt"
		self.xml_file = xml_file
		self.toRebuildAll = to_rebuild_all
		self.toKwBuild = to_kw_build
		if "Windows" in platform.system():
			self.conf_out_file_path_name = "C:/TEMP/MT_Batch_Build_Conf_Output.txt"
			self.conf_out_file_path_name_temp = "C:/TEMP/MT_Batch_Build_Conf_Output_temp.txt"
		else:
			self.conf_out_file_path_name = "MT_Batch_Build_Conf_Output.txt"
			self.conf_out_file_path_name_temp = "MT_Batch_Build_Conf_Output_temp.txt"

	def build_all(self):
		# equivalent to RunBatch in mt_build.py
		# delete "C:/temp/MT_Batch_Build_Conf_Output.txt";
		utils.RemoveFile(self.conf_out_file_path_name)
		
		conf = 0

		from_gui = False
		xml_file = self.xml_file

		import mt_build
		# fromGUI, xmlFile, toRebuildAll, confNumber, toKwBuild
		while True:
			cwd = os.getcwd()

			utils.RemoveFile(self.conf_out_file_path_name)
			cmd = "mt_batch_build.exe " + str(conf) + " /xml=" + xml_file
			logger.info("os.getcwd():" + os.getcwd())
			try:
				os.system(cmd)
			except Exception as e:
				error("mt_build Exception: " + str(e), kill=True)

		# import build_conf_xml_parser
		# build_conf_xml_parser.main(all_conf_xml_file_path_name = self.xmlFile, conf_num = str(self.confNumber))

			if not os.path.exists(self.conf_out_file_path_name):
				logger.info("mt_build, No more configurations to compile")
				break

			try:
				mt_build.main(from_gui, xml_file, self.toRebuildAll, conf, self.toKwBuild)
			except ValueError as val:
				logger.error("mt_build ValueError :" + str(val))
				break
			except Exception as e:
				error("mt_build Exception: " + str(e), kill=True)

			os.chdir(cwd)

			conf += 1


def main(xml_file_arg, to_rebuild_all_arg, to_kw_build_arg):

	logger.info("---------- start build arc release ----------")

	# for arg in sys.argv:
	# 	print(arg)
	# exit(0)
	
	start_time = time.time()
	
	cwd = os.getcwd()
	logger.info("cwd: " + cwd)

	from build_utils import fw_repos_ver

	try:
		fw_repos_ver()  # from build_utils.py
	except Exception as e:
		error("build_arc_release.py Error: " + str(e), kill=True)

	release_fw_p = release_fw(xml_file=xml_file_arg, to_rebuild_all=to_rebuild_all_arg, to_kw_build=to_kw_build_arg)
	release_fw_p.build_all()
	
	os.chdir(cwd)

	try:
		build_post_process.main()
	except SystemExit as e:
		sys.exit(str(e))

	delta_time = time.time() - start_time
		
	m, s = divmod(delta_time, 60)
	h, m = divmod(m, 60)

	logger.info("--- FW release Finished (took %d:%02d:%02d) ---" % (h, m, s))
	

if __name__ == '__main__':

	# for arg in sys.argv:
	# 	print(arg)
	# exit(0)

	if len(sys.argv) < 2:
		rebuild_all = True
	else:
		rebuild_all = sys.argv[2]

	main(sys.argv[1], to_rebuild_all_arg=rebuild_all, to_kw_build_arg=sys.argv[3])