import os
import sys
import time
import zipfile
import shutil
# from build_utils import logger

import logging
logging.basicConfig(level=logging.INFO,
					format='%(asctime)s %(levelname)s %(module)s.py, %(funcName)s %(lineno)-12d: %(message)s',
					datefmt='%H:%M:%S')
logger = logging.getLogger(__name__)


def move_file(src, dst):
    try:
        shutil.move(src, dst)
    except:
        Error("cannot move src: " + src + " to dst:" + dst)


def compress_and_save_build(source_directory, destination_directory, zip_file_name):
    logger.info("compress_and_save_build...")
    read_me_file = destination_directory + "/READ_ME.txt"
    zipf = zipfile.ZipFile(zip_file_name + '.zip', 'w', zipfile.ZIP_DEFLATED)
    root_len = len(source_directory) + 1
    for root, dirs, files in os.walk(source_directory):
        if ".git" not in root:
            if "TimeStamp" not in root:
                if ".kwlp" not in root:
                    if ".kwps" not in root:
                        if "depend" not in root:
                            for file in files:
                                fn = os.path.join(root, file)
                                zipf.write(fn, fn[root_len:])
    zipf.close()

    logger.info("moving zip file to dst: " + destination_directory)
    move_file(zip_file_name + '.zip', os.path.join(destination_directory, zip_file_name + '.zip'))

    with open(read_me_file, 'w') as fh:
        fh.write("in order to use with fw dumps you must unzip to the following folder: \n" + source_directory + "\n")


def main(source_dir, dest_dir, zip_file_name):
    # def main(git_branch, username = None, to_rebuild_all = True, to_kw_build = True):
    logger.info("---------- start compressing source build_compress_source.py ----------")

    start_time = time.time()

    compress_and_save_build(source_dir, dest_dir, zip_file_name)

    delta_time = time.time() - start_time

    m, s = divmod(delta_time, 60)
    h, m = divmod(m, 60)

    logger.info("--- compressing source Finished (took %d:%02d:%02d) ---" % (h, m, s))


if __name__ == '__main__':

    sourceDir = sys.argv[1]
    destDir = sys.argv[2]
    zipFilename = sys.argv[3]

    for arg in sys.argv:
        logger.info(arg)

    main(sourceDir, destDir, zipFilename)
