import sys
import os
# import shutil
# import glob
import time
import platform

# import utils # internal utilities file

import logging
logging.basicConfig(level=logging.INFO,
                    format='%(asctime)s %(levelname)s %(module)s.py, %(funcName)s %(lineno)-12d: %(message)s',
                    datefmt='%H:%M:%S')
logger = logging.getLogger(__name__)

class ini_parser(object):
	def __init__(self, configurationTagValList):
		self.inputConfigurationDictTagValList = self.splitInputConfiguration(configurationTagValList)
		logging.info(self.inputConfigurationDictTagValList)
		# self.headerDict = {}
		pass
	def splitInputConfiguration(self, inputDict) -> dict:
		# fpga_arc_lower_mac_cpu_wave600_ap_real_phy_wrx600_none

		"""do nothing for now"""
		outputDict = inputDict
		return outputDict
	def convert_section_header_to_dict(self, section_header: list) -> dict:
		# sectionHeader = ['HW = ASIC', 'CPU_TYPE = UPPER_MAC_CPU|LOWER_MAC_CPU', 'ARCH = WAVE600', 'PHY = REAL_PHY', 'RFIC = WRX600']
		# sectionHeader = ['HW = FPGA_ARC,ARCH = WAVE600|WAVE600B|WAVE600D2']
		# global text, text
		header_dict = {}
		logging.info(section_header)
		section_header_list = section_header
		# section_header_list = section_header.split(",")
		for header in section_header_list:
			logging.info(header)

			try:
				tag = header.split("=")[0].strip()
				logging.info("tag :" + tag)
				text = header.split("=")[1].strip()
				logging.info("values :" + text)
			except:
				logging.error("item is illegal, expecting x = y[|z...], item :" + str(header))
				exit(1)

			values = text.split("|")
			for val in values:
				assert isinstance(tag, str)
				header_dict.setdefault(tag, []).append(val.strip())
		logging.info(header_dict)
		return header_dict
		# for item in headerDict:
		# 	logging.info(item)

	def readTrimmedLines(self):
		pass
	def createConfigurationTypesList(self):
		pass
	def createProhibitedConfigurationsList(self):
		pass
	# def createConfigurationPermutationsFromHeader(self, sectionHeader):
	# 	# sectionHeader = [HW = ASIC, CPU_TYPE = UPPER_MAC_CPU|LOWER_MAC_CPU, ARCH = WAVE600, PHY = REAL_PHY, RFIC = WRX600]
	# 	Permutations = []
	# 	# for item in sectionHeader:
	#
	#
	#
	# 	pass
	def extract_header(self, headerSection):
		return headerSection.strip().strip("[").strip("]")
	def checkIfInputConfigurationIsSubsetOfPermutations(self):
		pass
	def convert_header_line_to_header(self, line):
		header = line.strip().strip("[").strip("]")
		return header
	def is_line_a_section_header(self, line):
		# logging.info(line.strip().startswith("["))
		if not (line.strip().startswith("[") and line.strip().endswith("]")):
			return False
		header = self.convert_header_line_to_header(line)
		if "Types" == header:
			return False
		if "Prohibited" == header:
			return False
		return True
		# # [HW = ASIC, CPU_TYPE = UPPER_MAC_CPU|LOWER_MAC_CPU, ARCH = WAVE600, PHY = REAL_PHY, RFIC = WRX600]
	def check_val_in_conf(self, header_values_of_tag, conf_val_of_tag):
		logging.info(str(header_values_of_tag) + " " + str(conf_val_of_tag))
		return conf_val_of_tag in header_values_of_tag

	def header_match(self, section_header: list, input_configuration_dict_tag_val_list) -> bool:
		header_dict = self.convert_section_header_to_dict(section_header)
		for tag in header_dict:
			if (self.check_val_in_conf(header_dict.get(tag, None), input_configuration_dict_tag_val_list.get(tag, None)) == False):
				return False
		return True
	def convert_section_line_to_section_list(self, line: str) -> list:
		header = line.strip().strip("[").strip("]").split(",")
		return header
		# if isinstance(line, list)
	def go(self):
		with open("./mt_make_type.ini", 'r') as f1:
			self.iniLines = f1.readlines()
		# logging.info(self.iniLines)
		for line in self.iniLines:
			if self.is_line_a_section_header(line):
				section_header_list = self.convert_section_line_to_section_list(line)
				logging.info("found header :"+str(section_header_list))
				if self.header_match(section_header_list, self.inputConfigurationDictTagValList):
					logging.info("header match :" + str(section_header_list))
					sectionData = self.extract_section(line)
					self.savedLines(sectionData)
			# logging.info(line.strip("\n"))
	def extract_section(self, line):
		header = self.convert_header_line_to_header(line)
		import configparser
		config = configparser.ConfigParser(strict=False, comment_prefixes=('#', ';', "//", "/*"))
		config.read("./mt_make_type.ini")



class conf_xml_parser(object):
	def __init__(self, autobuild_path_name: str, all_conf_xml_file_path_name: str, conf_num: int) -> None:

		# self.debug = True
		self.autobuild_path_name = autobuild_path_name
		self.all_conf_xml_file_path_name = os.path.abspath(all_conf_xml_file_path_name)
		assert isinstance(conf_num, str)
		self.conf_num = int(conf_num)

		"""file location is os depndent"""
		if ( "Windows" in platform.system()):
			self.confOutputFile = "C:/TEMP/MT_Batch_Build_Conf_Output.txt"
			self.confOutputFile_temp = "C:/TEMP/MT_Batch_Build_Conf_Output_temp.txt"
		else:
			self.confOutputFile = "MT_Batch_Build_Conf_Output.txt"
			self.confOutputFile_temp = "MT_Batch_Build_Conf_Output_temp.txt"

	def go(self):
		# logging.info("os.getcwd(): " + os.getcwd())
		logging.info("self.all_conf_xml_file_path_name: " + self.all_conf_xml_file_path_name)
		logging.info("self.conf_num: " + str(self.conf_num))


		arr_sec = []
		arr_val = []
		arr_tag_text = []
		import xml.etree.ElementTree as ET
		tree = ET.fromstring(self.all_conf_xml_file_path_name)
		root = tree.getroot()

		configurations_list = root.findall('Configuration')
		num_of_conf = len(configurations_list)
		if self.conf_num >= num_of_conf:
			logging.error("conf number out of range :" + str(self.conf_num) + " out of :" + str(num_of_conf))
			return

		logging.info("all confs  = " + str(num_of_conf))
		configuration = configurations_list[self.conf_num]

		dict_tag_text = {}
		"""create 2 lists, one for conf string and another for conf section fo ini file"""
		for item in configuration:
			# logging.info(item.tag + "=" + item.text)
			arr_val.append(item.text.lower())
			# arr_tag_text.append((item.tag, item.text))
			dict_tag_text[item.tag] = item.text
			# logging.info(item.tag + " " + item.text)
			if item.tag not in ['TYPE', 'Release']:
				arr_sec.append((item.tag, item.text))

		self.configurationList = arr_val
		self.configurationDictTagValList = dict_tag_text
		# logging.info(self.configurationTagValList)
		logging.info(self.configurationDictTagValList)
		"""create CONF from arr_val"""
		CONF = '_'.join(arr_val)
		logging.info("conf = " + CONF)

		"""create section from arr_sec"""
		arr2=[]
		for (x,y) in arr_sec:
			arr2.append(x + " = " + y)
		conf_sec = ', '.join(arr2)

		# logging.info(sec)

		"""extract params from mt make type ini file out of the conf section"""
		import configparser
		config = configparser.ConfigParser(strict=False, comment_prefixes=('#', ';', "//", "/*"))
		config.read("./mt_make_type.ini")
		# logging.info("has section config: " + sec + " result: " + str(config.has_section(sec)))
		options = dict(config.items(conf_sec))
		# logging.info(options)

# [HW = FPGA_ARC, CPU_TYPE = UPPER_MAC_CPU, ARCH = WAVE600B, PHY = REAL_PHY, RFIC = WRX600B]


		# [VARS]
		# CONF = asic_lower_mac_cpu_wave600_ap_real_phy_wrx600_none
		# BIN_NAME = Wave600_LowerMacCpuArc.bin
		# BLD = Wave600_LowerMacCpu_RealPhyWrx600Defines.dummy
		# MAX_BIN_SIZE = 163840
		# REBUILD = 1

		rebuild_line = "REBUILD = 1"
		conf_line = "CONF = " + CONF
		var_line = "[VARS]"

		"""create output file: MT_Batch_Build_Conf_Output.txt in c:/temp"""
		with open(self.confOutputFile, 'w') as f1:
			f1.write(var_line + '\n')
			f1.write(conf_line + '\n')
			for key in options.keys():
				f1.write(key.upper() + " = " + options[key] + "\n")
			f1.write(rebuild_line + "\n")

		return self.configurationDictTagValList

def main(all_conf_xml_file_path_name = "", conf_num = "0"):

	logger.info("---------- start build conf xml parser process ----------")	

	#for arg in sys.argv:
	#	print(arg)
	#exit(0)
	
# input list 
# ------------
	
	#thisFileName 			= sys.argv[0] #build_post_process.py
	# thisFileName
	start_time = time.time()
	
	autobuild_path_name = os.getcwd() # should be something like: "C:\work\VersionBuilding\FW_6.0.1\AutoBuild"
	conf_xml_parser_p = conf_xml_parser(autobuild_path_name, all_conf_xml_file_path_name, conf_num)
	configurationDictTagValList = conf_xml_parser_p.go()
	ini_parser_p = ini_parser(configurationDictTagValList)
	ini_parser_p.go()

	delta_time = time.time() - start_time

	m, s = divmod(delta_time, 60)
	h, m = divmod(m, 60)

	logger.info("--- build conf xml parser Finished (took %d:%02d:%02d) ---" % (h, m, s))

	# return (out_conf)
	

	
if __name__ == '__main__':
	# if len(sys.argv) < 2:
	# 	rebuild_all = True
	# else:
	# 	rebuild_all = sys.argv[2]
	all_conf_xml_file_path_name = sys.argv[1]
	conf_num = sys.argv[2]
	main(all_conf_xml_file_path_name, conf_num)
	# main()