import sys
import os
import time

from build_utils import logger


class post_process(object):
	def __init__(self, autobuild_path_name, output_path_rel_to_branch):
		# self.debug = False
		self.debug = True
		# logging.info("autobuild_path_name:"+autobuild_path_name)
		# logging.info("output_path_rel_to_branch:"+output_path_rel_to_branch)
		# logger.info("init")
		self.dict = []
		self.filter_project = "wave600"
		self.filter_flavour = "mac"
		self.default_flavour_nick_name = "upper"
		self.default_flavour = "upper_mac"
		self.fw_images_name_list = ["upper_mac", "lower_mac", "lower1_mac"]
		self.unified_flavour_nick_name = "ram"
		self.autobuild_path_name = autobuild_path_name
		(self.fw_src_path_name, tail) = os.path.split(autobuild_path_name)

		self.output_path_name = os.path.join(self.fw_src_path_name, output_path_rel_to_branch)
		
	def add_to_dict(self, dir_name):
		dir_name_as_list = dir_name.split("_") 
		
		if self.filter_flavour not in dir_name_as_list:
			return

		if self.filter_project not in dir_name:
			return

		for flavor in self.fw_images_name_list:
			if flavor in dir_name:
				dir_name_temp = dir_name.replace(flavor, self.default_flavour)
				if dir_name_temp not in self.dict:
					self.dict.append(dir_name_temp)

	def Error(self, msg):
		logger.error("Error: " + msg)
		# os.system("pause")
		sys.exit(str(msg))
		
	def merge(self, image_name):
		# assume image_name contains "upper_mac"
		if self.default_flavour not in image_name:
			self.Error("image_name not as expected (should contain " + self.default_flavour + ")")
			
		unified_image_name = image_name.replace(self.default_flavour, self.unified_flavour_nick_name)
	
		unified_ram_bin_path_file_name = os.path.join(self.output_path_name, unified_image_name + '.bin')  
		# C:\work\VersionBuilding\FW_6.0.1\output\ap_ram_gen6_wrx_500_fpga_dummy_phy.bin
		
		with open(unified_ram_bin_path_file_name, 'wb') as outfile:
			for fname in self.fw_images_name_list:
				image_name_path_name = image_name.replace(self.default_flavour, fname)
				bin_to_concat = os.path.join(self.output_path_name, image_name_path_name, "images", "bin.bin")
				
				if os.path.exists(bin_to_concat):
					with open(bin_to_concat, 'rb') as infile:
						for line in infile:
							outfile.write(line)
				else:
					logger.error("not exists: " + bin_to_concat)
					self.Error("An output directory is missing. Killing the process.")
		
	def check_shram_alignment(self):
	
		# self.dict = ['fpga_arc_upper_mac_cpu_wave600_ap_dummy_phy_wrx500_none',
		# 'fpga_arc_upper_mac_cpu_wave600_ap_dummy_phy_wrx514_none']
		logger.info("start check_shram_alignment.py")
		
		for image_name in self.dict:
			map_list_file = []
			for fname in self.fw_images_name_list:
				image_name_path_name = image_name.replace(self.default_flavour, fname)
				map_file = os.path.join(self.output_path_name, image_name_path_name, "images", "map.map")
				map_list_file.append(map_file)
	
			command = "check_shram_alignment.py " + " ".join(map_list_file)
			# logger.info("start check_shram_alignment.py: " + command)
			os.system(command)	
	
	def go(self):
		# logger.info("os.getcwd(): " + os.getcwd())
		
		os.chdir(self.output_path_name)
		
		# logger.info("--------- add_to_dict ---------------")
		# add unique family flavour to list
		[self.add_to_dict(_dir) for _dir in os.listdir(".") if os.path.isdir(_dir)]
		
		# logger.info("self.dict:"+str(self.dict))
		# logger.info("--------- merge ---------------")
		
		[self.merge(dir) for dir in self.dict]
		
		# logger.info(self.dict)
		
		os.chdir(self.autobuild_path_name)
		
		# self.map_file_parser()
		
		try:
			self.check_shram_alignment()
		except ValueError as err:
			logger.error(err)
		

def main(autobuild_path_name="", output_path_rel_to_branch="output"):

	logger.info("---------- start build post process ----------")	

	# for arg in sys.argv:
	# 	print(arg)
	# exit(0)
	
# input list 
# ------------
	
	# thisFileName = sys.argv[0] #build_post_process.py

	start_time = time.time()
	
	autobuild_path_name = os.getcwd() # should be something like: "C:\work\VersionBuilding\FW_6.0.1\AutoBuild"
	post_process_p = post_process(autobuild_path_name, output_path_rel_to_branch)
	post_process_p.go()

	delta_time = time.time() - start_time
	m, s = divmod(delta_time, 60)
	h, m = divmod(m, 60)

	logger.info("--- build post process Finished (took %d:%02d:%02d) ---" % (h, m, s))


if __name__ == '__main__':
	main()
