import sys
import os
import time
import utils # internal utilities file
import platform

from build_utils import logger


def error(s, kill=False):
	logger.error(s)
	if kill:
		sys.exit(1)


class Flavor(object):
	def __init__(self, dev_path ="", xml_path_file_name = "", req_conf_num = 0):
		logger.info(dev_path)
		self.developmentPath 		= dev_path
		self.xml_path_file_name 	= xml_path_file_name
		self.req_conf_num 			= req_conf_num

		logger.info("self.developmentPath :" + self.developmentPath)
		logger.info("self.xml_path_file_name :" + self.xml_path_file_name)
		logger.info("self.req_conf_num :" + str(self.req_conf_num))

		self.auto_build_path 		= os.path.join(self.developmentPath, "fw_src", "AutoBuild")
		self.mt_make_type_ini_file 	= os.path.join(self.developmentPath, "fw_src", "AutoBuild", "mt_make_type.ini")
		self.firmware_path 			= os.path.join(self.developmentPath, "fw_src", "firmware")
		self.output_path 			= os.path.join(self.developmentPath, "fw_src", "output")

		if "Windows" in platform.system():
			self.conf_out_file_path_name = "C:/TEMP/MT_Batch_Build_Conf_Output.txt"
			self.conf_out_file_path_name_temp = "C:/TEMP/MT_Batch_Build_Conf_Output_temp.txt"
		else:
			self.conf_out_file_path_name = "MT_Batch_Build_Conf_Output.txt"
			self.conf_out_file_path_name_temp = "MT_Batch_Build_Conf_Output_temp.txt"

	def go(self):
		# get flavor flags according to conf number

		import xml.etree.ElementTree as Et
		tree = Et.parse(self.xml_path_file_name)
		root = tree.getroot()

		configurations_list = root.findall('Configuration')

		total_num_of_conf = len(configurations_list)
		logger.info(total_num_of_conf)

		if not self.req_conf_num < total_num_of_conf :
			error("requested conf number :{0}, exceeds max conf number in :{1}".format(str(self.req_conf_num),
																					str(self.xml_path_file_name)), kill=True)

		conf_properties = {}
		conf_list = []
		elements = list(configurations_list[self.req_conf_num].iter())[1:]
		for element in elements:
			# logger.info([element.tag, element.text])
			conf_properties[element.tag] = element.text  # {'HW': 'ASIC', 'CPU_TYPE': 'LOWER_MAC_CPU', 
			# 'ARCH': 'WAVE600B', 'TYPE': 'AP', 'PHY': 'REAL_PHY', 'RFIC': 'WRX600B', 'Release': 'DEBUG'}
			conf_list.append(element.text)

		logger.info(conf_properties)
		# conf = conf_list.join("_")
		conf = '_'.join(conf_list).lower()
		logger.info(conf)

		# [VARS]
		# CONF = asic_upper_mac_cpu_wave600b_ap_real_phy_wrx600b_debug

		lines = "[VARS]\n"
		lines += conf + "\n"

		try:
			os.remove(self.conf_out_file_path_name)
		except OSError:
			pass

		with open(self.conf_out_file_path_name, 'w') as fp:
			fp.writelines(lines)


def main(development_path, xml, required_conf_num):
	logger.info("---------- start ----------")

	# for arg in sys.argv:
	# 	print(arg)
	# exit(0)
	
	start_time = time.time()
	
	cwd = os.getcwd()
	logger.info("cwd: " + cwd)

	flavor_p = Flavor(development_path, xml, required_conf_num)
	flavor_p.go()

	os.chdir(cwd)
	
	delta_time = time.time() - start_time
		
	m, s = divmod(delta_time, 60)
	h, m = divmod(m, 60)

	logger.info("--- Finished (took %d:%02d:%02d) ---" % (h, m, s))
	

if __name__ == '__main__':
	if len(sys.argv) < 3:
		print("usage :python build_pre_config.py \"C:/work/VersionBuilding/FW_6.1.0\" "
			"\"C:/work/VersionBuilding/FW_6.1.0/fw_src/AutoBuild/chosen_configurations.xml\" <conf_number>")
		exit(1)
	# 	rebuild_all = True
	# else:
	# 	rebuild_all = sys.argv[2]

	# to_kw_build = sys.argv[3]

	# thisFileName 			= sys.argv[0] #build_arc.py
	# developmentPath 		= sys.argv[1] #C:\work\VersionBuilding\FW_6.1.0
	development_path = sys.argv[1]
	xml = sys.argv[2]
	conf_num = int(sys.argv[3])

	if not os.path.exists(development_path):
		error("dev path not exists :" + development_path, kill=True)
	if not os.path.exists(xml):
		error("xml path not exists :" + xml, kill=True)

	main(os.path.abspath(development_path), os.path.abspath(xml), conf_num)
	# main(sys.argv[1] , toRebuildAll = rebuild_all, toKwBuild = to_kw_build)
