import sys
import os
import time

import utils # internal utilities file

from build_utils import logger

# import logging
# logging.basicConfig(level=logging.INFO,
#                     format='%(asctime)s %(levelname)s %(module)s.py, %(funcName)s %(lineno)-12d: %(message)s',
#                     datefmt='%H:%M:%S')
# logger = logging.getLogger(__name__)

class pre_process:
	def __init__(self, autobuild_path_name):
		# logger.info("init")
		self.autobuild_path_name = autobuild_path_name
		(self.branch_path_name, tail) = os.path.split(self.autobuild_path_name)
		self.firmware_path = os.path.join(self.branch_path_name, "fw_src/firmware")
		self.wave600HwMemoryMapPath = os.path.join(self.branch_path_name, "shared_header/HwHeaders/Wave600/HwMemoryMap.h")
		self.metaware_path = os.path.join(self.firmware_path, "builds/metaware")
		# self.branch = "\\".join(self.autobuild_path_name.split("\\")[0:-1])
		self.outPath = self.metaware_path
		self.dict = {}
		self.myList = []
		self.hw_map_file = self.wave600HwMemoryMapPath

	def Error(self, msg):
		print("Error: " + msg)
		# os.system("pause")
		# sys.exit(str(msg))
	
	def go(self):
		# logger.info("os.getcwd(): " + os.getcwd())
		logger.info("self.hw_map_file: " + str(self.hw_map_file))
		
		if os.path.exists(self.hw_map_file):
			with open(self.hw_map_file, 'r') as hw_mem_file:
				for line in hw_mem_file:
					if ("" == line.strip()): continue
					line = line.replace("(","")
					line = line.replace(")","")
					line = line.replace("+","")

					splitted_line = line.split()
					
					if ("#define" != splitted_line[0]): continue
					
					if len(splitted_line) == 3: 
					# case of 
					# "#define MEMORY_MAP_UNIT_1_BASE_ADDRESS                         SYSTEM_IF_UPPER_CPU_BASE_ADDR" or
					# "#define CPU_IRAM_BASE_ADDR                                     0xA0000000"
						if "0x" in splitted_line[2]:
							self.dict[splitted_line[1]] = splitted_line[2]
							self.myList.append([splitted_line[1], splitted_line[2]])

					if len(splitted_line) > 3:
					# case of 
					# #define IRAM_OCP64_IRAM_1_IRAM                                 CPU_IRAM_BASE_ADDR + 0x00040000 /* MEMORY_MAP_UNIT_1000_BASE_ADDRESS */
						if splitted_line[2] in self.dict:
							self.dict[splitted_line[1]] = hex(int(self.dict[splitted_line[2]], 0) + int(splitted_line[3], 0))
							self.myList.append([splitted_line[1], hex(int(self.dict[splitted_line[2]], 0) + int(splitted_line[3], 0))])
						else:
							logger.error(splitted_line[2] + " not exists in dict")
							continue

			with open(os.path.join(self.outPath, "mem_def.lcf"), 'w') as out_file:
				out_file.write("###########################################################################################################\n")
				out_file.write("# this file (*_mem_def.lcf) was auto generated using build_pre_process.py from file: " + self.hw_map_file.replace(self.branch_path_name,"") + "\n")
				out_file.write("###########################################################################################################\n\n")
				for [key,value] in self.myList:
					out_file.write('{:50} = {:6};\n'.format(key, value)) 
		# logger.info(self.branch)
		

def main():

	logger.info("---------- start build pre process ----------")	

	start_time = time.time()
	
	autobuild_path_name = os.getcwd() # should be something like: "C:\work\VersionBuilding\FW_6.0.1\AutoBuild"

	pre_process_p = pre_process(autobuild_path_name)
	pre_process_p.go()

	delta_time = time.time() - start_time

	m, s = divmod(delta_time, 60)
	h, m = divmod(m, 60)

	logger.info("--- build pre process Finished (took %d:%02d:%02d) ---" % (h, m, s))

	
if __name__ == '__main__':
	main()