import subprocess
import os
import logging

logging.basicConfig(level=logging.INFO,
                    format='%(asctime)s %(levelname)s %(module)s.py, %(funcName)s %(lineno)-12d: %(message)s',
                    datefmt='%H:%M:%S')
logger = logging.getLogger(__name__)


def fw_repos_ver():
    logger.info("List of all repos used to build this FW release:")

    cwd = os.getcwd()

    cmd = "git rev-parse --abbrev-ref HEAD"  # get current branch
    res = subprocess.run(cmd.split(" "), capture_output=True)
    logger.info("branch :" + res.stdout.decode("utf8").strip())

    cmd = "git rev-parse --show-toplevel"  # get the git root directory name
    res = subprocess.run(cmd.split(" "), capture_output=True)
    # logger.info(res.stdout.decode("utf8").strip()) # C:/work/VersionBuilding/FW_6.1.0/fw_src

    os.chdir(os.path.dirname(res.stdout.decode("utf8")))

    # logger.info(os.getcwd()) # C:\work\VersionBuilding\FW_6.1.0

    # logger.info(os.listdir(".")) # ['fw_src', 'regs_abb', 'regs_bbic', 'regs_rfic', 'shared_genrisc_fw',
    # 'shared_header', 'shared_logprep', 'shared_mtidl', 'shared_rtlogger', 'TimeStamp']

    for subdir in os.listdir("."):
        os.chdir(subdir)
        if os.path.exists(".git"):
            cmd = "git config --get remote.origin.url"  # get current repo name
            res = subprocess.run(cmd.split(" "), capture_output=True)
            repo_name = res.stdout.decode("utf8").strip()

            # logger.info(repo_name.stdout.decode("utf8")) # ssh://git@gts-chd.intel.com:29418/sw_wave/shared_rtlogger.git

            cmd = "git rev-parse HEAD"  # get current hash
            res = subprocess.run(cmd.split(" "), capture_output=True)
            hash1 = res.stdout.decode("utf8").strip()
            # logger.info(hash.stdout.decode("utf8"))  # 94254ea07d2f29103f34d5860c74e95e74111823

            logger.info(repo_name + " : " + hash1)
            # ssh://git@gts-chd.intel.com:29418/sw_wave/fw_src.git : da8dafe19f89ea664fcddec84699f945af961030
        os.chdir('..')

    os.chdir(cwd)