import sys
import os
import io
import shutil
import glob
import subprocess
import time
# import getopt
# import zipfile
# import smtplib

# from subprocess import Popen, PIPE, STDOUT

# import utils # internal utilities file

import logging
logging.basicConfig(level=logging.INFO,
                    format='%(asctime)s %(levelname)s %(module)s.py, %(funcName)s %(lineno)-12d: %(message)s',
                    datefmt='%H:%M:%S')
logger = logging.getLogger(__name__)


def Error(s, kill = False):
	logger.error(s)
	if (kill == True):
		# os.system("pause")
		# raise Exception(str(s))
		# raise ValueError(str(s))
		sys.exit(1)
		
class compare_shram:
	def __init__(self, argv):
		self.argv = argv

	def create_file_list(self):

		self.file_list = []
		args = self.argv[1:]

		for map_file in args:
			if os.path.exists(map_file):
				self.file_list.append(map_file)
		
	def go(self):
	
		self.create_file_list()

		self.shram_db = []
		
		for map_file in self.file_list:
			shram_db_temp = []
			with open(map_file) as myfile:
				for line in myfile:
					if ("SECTION SUMMARY" in line):
						# start of comparing section
						break

				for line in myfile:
					if ("SECTION DETAILS" in line):
						# end of comparing section
						break
					if ("SHARED_RAM_" in line):
						mystring = line.rstrip() + " " + next(myfile).rstrip()
						mystring = mystring.replace("bss","") # remove bss string
						mystring2 = ','.join(mystring.split())
						mylist = mystring2.split(',')
						shram_db_temp.append(mylist)

			if not self.shram_db:
				self.shram_db = shram_db_temp
				continue

			if not self.shram_db == shram_db_temp:
				raise ValueError("shared ram not matched between cores !!!\n\n")

def main(argv):

	print("\n")
	# for arg in sys.argv:
	#     print(arg)

	start_time = time.time()

	compare_shram_p = compare_shram(argv)
	try:
		compare_shram_p.go()
	except ValueError as err:
		logger.error("-----------------------> !!! " + str(err) + " " + str(argv) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		logger.error("-----------------------> !!! " + str(err) + " !!! <-----------------------")
		


	delta_time = time.time() - start_time

	m, s = divmod(delta_time, 60)
	h, m = divmod(m, 60)

	# logger.info("--- %s Finished (took %d:%02d:%02d) ---" % (os.path.basename(os.path.normpath(argv[0])), h, m, s))


if __name__ == '__main__':
	if len(sys.argv) < 4:
		print("----------------------------------")
		print("Usage: " + sys.argv[0] + " <map_file1.map> <map_file2.map> <map_file3.map> ...")
		print("----------------------------------")
		Error("wrong usage of " + sys.argv[0], kill = True)
	
    # Wave600 assume 3 map file exists: lower lower1 upper
	if not os.path.exists(sys.argv[1]):
		Error("file not exists: " + sys.argv[1], kill = True)

	if not os.path.exists(sys.argv[2]):
		Error("file not exists: " + sys.argv[2], kill = True)

	if not os.path.exists(sys.argv[3]):
		Error("file not exists: " + sys.argv[3], kill = True)
        
	main(sys.argv)
	