import sys
import os
import io
import shutil
import glob
import time

from subprocess import Popen, PIPE, STDOUT
	
def Error(s, kill = False):
	print("Error:", s)
	if (kill == True):
		sys.exit(1)
	
		
class extract_enums:
	def __init__(self, argv, elfdumpac_file):
		self.this_file_name = argv[0]
		self.elfdumpac_file = elfdumpac_file
		
	def go(self):
		# print("go")
		# print("os.getcwd():", os.getcwd())
		# print("self.elfdumpac_file: "+self.elfdumpac_file)
		enum_db = []

		file_name0 = os.path.splitext(self.elfdumpac_file)[0]
		out_file_name = os.path.basename(os.path.normpath(file_name0)) + "_enums.txt"
		
		with open(self.elfdumpac_file) as myfile:
			for line in myfile:
				if "TAG_enumerator" in line:
					line2 = next(myfile)
					enum = line2.split('"')[-2]
					line3 = next(myfile)
					value = line3.split()[-2] + " " + line3.split()[-1]
					enum_db.append([enum, value])
		# print(enum_db)

		with open(out_file_name, 'w') as myfile:
			myfile.write("********************************************\n")
			myfile.write("auto generated file using: " + self.this_file_name + " \n")
			myfile.write("enums parsed from " + self.elfdumpac_file + " \n")
			myfile.write("********************************************\n\n")
			for element in enum_db:
				myfile.write(element[0] + " " + element[1] + "\n")



def main(argv, elfdumpac_file):

	# print("Start " + argv[0])
	# for arg in sys.argv:
	#     print(arg)

	start_time = time.time()

	extract_enums_p = extract_enums(argv, elfdumpac_file)
	extract_enums_p.go()

	delta_time = time.time() - start_time

	m, s = divmod(delta_time, 60)
	h, m = divmod(m, 60)

	# print("--- " + argv[0] + " Finished (took %d:%02d:%02d) ---" % (h, m, s))


if __name__ == '__main__':
	if len(sys.argv) < 2:
		print("----------------------------------")
		print("Usage: " + sys.argv[0] + " <elfdumpac_out>")
		print("----------------------------------")
		Error("wrong usage of "+ sys.argv[0], kill = True)
		
	elfdumpac_file = sys.argv[1]

	# print(elfdumpac_file)
	
	if not os.path.exists(elfdumpac_file):
		Error("file not exists: " + elfdumpac_file)
	
	
	main(sys.argv, elfdumpac_file)

	
	
	