#!/usr/local/bin/perl
#package mt_tlog;
use File::Copy;
use IPC::Cmd qw[can_run run run_forked];

my $developDir;
my $GEN;
my $outputDir;

sub setDevelopDir
{
	$developDir = shift;
}

sub setGen
{
	$GEN = shift;
}

sub setOutputDir
{
	$outputDir = shift;
}

# Create Upper Mac messages list from OSAL_UpperMacMessages.h file. identify the relevant lines using patterns
sub Look_Into_OSAL_UpperMacMessages
{
	$OSAL_LIST = shift;
	# open OSAL_UpperMacMessages.h file
	open my $newfh, '<', $OSAL_LIST or die "error opening $developDir/fw_src/firmware/OSAL/Api/OSAL_UpperMacMessages.h";
	# open new file (message to struct table)
	
	open my $newlistfh, '>', "objdump/URID.txt" or die "error creating $developDir/fw_src/AutoBuild/objdump/URID.txt";
	my @lines_array;
	# scan OSAL_UpperMacMessages file and look for messages and structs
	while(my $row = <$newfh>)
	{
		# skip irrelevant lines (comments, typedef { } etc...)
		$result = (($row =~ /^\/\*/) || ($row =~ /^\*/) || ($row=~/^\t\/\*/) 
				  || ($row =~/^\t\/\//) || ($row=~/#/) || ($row=~/^}/) 
				  || ($row=~/^typedef/) || ($row=~/^{/) || ($row=~/^\n/) || ($row=~/^\t\n/));		   				  
		if(!($result))
		{
			$row =~ s/^\s+//;			      ## remove tabs and spaces before
			$row =~ s/,//;				      ## remove ,
			$row =~ s/\s+$//;				  ## remove tabs and spaces after		
			print $newlistfh "$row\n";	# print the array into a txt file (URID.txt)
		}
	}
	close $newfh;
	close $newlistfh;
}

# Create Driver messages list from mhi_umi.h file. identify the relevant lines using patterns
sub Look_Into_umi_mhi
{
	$MHI_LIST = shift;
	# open umi_mhi.h file
	open my $newfh, '<', $MHI_LIST or die "error opening $developDir/shared_header/mhi_umi.h";
	# open new file (message to struct table)
	open my $newlistfh, '>', "objdump/URID2.txt" or die "error creating $developDir/fw_src/AutoBuild/objdump/URID2.txt";
	# scan mhi_umi file and look for messages and structs
	my $endline = "}";
	while(my $row = <$newfh>)
	{
		if($row =~ _UMI_Msgs) # start the creation of list in when reaching the messages section
		{
			last;
		}	
	}
	while(my $row = <$newfh>)
	{
		# skip irrelevant lines (comments, typedef { } etc...)
		$result = (($row =~ /^\/\*/) || ($row =~ /^\*/) || ($row=~/^\t\/\*/) 
				  || ($row =~/^\t\/\//) || ($row=~/#/) || ($row=~/^}/) 
				  || ($row=~/^typedef/) || ($row=~/^{/) || ($row=~/^\n/) || ($row=~/^\t\n/));		   				  
		if(!($result))
		{
			$row =~ s/^\s+//;			      ## remove tabs and spaces before
			$row =~ s/,//;				      ## remove ,
			$row =~ s/\s+$//;				  ## remove tabs and spaces after
			print $newlistfh "$row\n"; # print in txt file the message
		}	
		if($row =~ $endline)
		{
			last;
		}		
	}
	close $newfh;
	close $newlistfh
}

# comparing the contr with the OSAL messages list generated in "new_event_prep.pm"
sub CompareContrToOsal
{
	(my $GEN_number) = $GEN =~ /(\d)/;		# get generation
	my $contrTxtFilePath = "<$outputDir/objects/$core"."_enums.txt";
	open my $ContrComp, $contrTxtFilePath or die "error opening $contrTxtFilePath";
	open my $newlist, ">OSAL_list.txt" or die "error creating $developDir/fw_src/AutoBuild/objdump/OSAL_list.txt";
	open my $OSAL, "<URID.txt" or die "error opening $developDir/fw_src/AutoBuild/objdump/URID.txt";
		
	my $patt2 = qr/(\w+)\s+\/\/\s+(\w+)/;
	
	my $scd_in;
	my $rowContr = <$ContrComp>;
	my $postComp;
	my $preComp;
	my $structName;
	my $enum;
	my $i;
	
	print $newlist "----------------------------OSAL LIST $GEN---------------------------\n";
	# go through contr file until hit first OSAL message
	while($rowContr and !(($rowContr=~"OSAL_TASK_UNUSED_MSG")))# and ($rowContr =~ $patt)))
	{
		$rowContr = <$ContrComp>;
	}
	if(!$rowContr)
	{
		die "couldn't find OSAL messages in contr file\n";
	}
	# starting point
	my $rowOSAL = <$OSAL>;
	# go through contr file until hit last OSAL message
	while ($rowContr and !($rowContr=~"OSAL_TASK_LAST_MSG") )
	{
		my @arr = split(/\s+/, $rowContr);
		$postComp = $arr[0];
		
		($preComp = $rowOSAL) =~ /^(\S+)/mg; # look at first word of every line in the OSAL list
		# scan OSAL list untill hit same msg as in the contr file
		while($rowOSAL and !( $preComp =~ $postComp ))
		{
			$rowOSAL = <$OSAL>;						# not hit   ->    go to next line in osal file
			($preComp = $rowOSAL) =~ /^(\S+)/mg;	# preComp is the msg from OSAL list (without all the other details)
		}	
		
		my @arr = split(/\s+/, $rowContr);
		$enum = $arr[1];
		
		$preComp =~ s/(\w+).*/$1/; # take  the line		

		if( $rowOSAL =~ $patt2 )			 # take the struct name written in a comment in the OSAL messages file
		{
			$structName = $2;
			$scd_in = "U 1 0 0 $enum $structName $preComp"; # place together enum, structName and MSG
		}
		# no structure linked to MSG in the OSAL list.. print NULL for structure name...
		else
		{
			$scd_in = "U 1 0 0 $enum NULL $preComp";
		}
		print $newlist "$scd_in";	# put in list

		$rowContr = <$ContrComp>; # go down 2 more lines in contr...
	}
	if(!$rowContr)
	{
		die "couldn't complete compare between OSAL list and contr\n";
	}
	close $OSAL;
	close $ContrComp;
	close $newlist;
	unlink "URID.txt";
}

# comparing the contr with the driver messages list generated in "new_event_prep.pm"
sub CompareContrToMhi
{
	(my $GEN_number) = $GEN =~ /(\d)/;		# get generation

	my $contrTxtFilePath = "<$outputDir/objects/$core"."_enums.txt";
	open my $ContrComp, $contrTxtFilePath or die "error opening $contrTxtFilePath";

	open my $newlist, ">mhi_list.txt" or die "error creating $developDir/fw_src/AutoBuild/objdump/mhi_list.txt";
	open my $mhi, "<URID2.txt" or die "error opening $developDir/fw_src/AutoBuild/objdump/URID2.txt";
	my $enum_patt = $patt;
	my $rowContr = <$ContrComp>;
	
	my $postComp;
	my $preComp;
	my $structName;
	my $enum;
	my $i;
	
	print $newlist "----------------------------mhi LIST $GEN---------------------------\n";
	# go through contr file until hit first driver message
	while($rowContr and !(($rowContr=~"UMI_MSGS_START")))# and ($rowContr =~ $patt)))
	{
		$rowContr = <$ContrComp>;
	}
	if(!$rowContr)
	{
		die "couldn't find mhi messages in contr file\n";
	}
	# starting point
	# first row of mhi message file
	my $rowMHI = <$mhi>;
	# go through contr file until hit last mhi message
	while ($rowContr and !($rowContr=~"UMI_TOTAL_NUM_MSGS"))
	{
		
		($postComp)=split(/\s+/, $rowContr);
		($preComp = $rowMHI) =~ /^(\S+)/mg; # look at first word of every line in the mhi list
		# scan mhi list untill hit same msg as in the contr file
		while($rowMHI and !( $preComp =~ $postComp ))
		{
			$rowMHI = <$mhi>;						# not hit   ->    go to next line in mhi file
			
			($preComp = $rowMHI) =~ /^(\S+)/mg;	# preComp is the msg from mhi list (without all the other details)
		}
		my @arr = split(/\s+/, $rowContr);
		$enum = $arr[1];
		chomp $enum;

		my @arr1 = split(/\s+/, $rowMHI);
		
		if ($rowMHI=~"=")
		{
			$st1 = $arr1[4];
		}
		else
		{
			$st1 = $arr1[2];
		}
		chomp $st1;
		
		my @arr2 = split(/\s+/, $preComp);
		
		$st2 = $arr2[0];
		my @arr = split(/\s+/, $st2);
		$st2 = $arr[0];
		chomp $st2;
		
		if ($st1 ne "")
		{
			# take the struct name written in a comment in the mhi messages file
			# print "1 st1:".$st1."\n";
			my @arr3 = split(/\s+/, $st1);

			$structName = $st1;
			$postComp = "U 1 0 1 $enum $structName $st2"; # place together enum, structName and MSG
		}
		# no structure linked to MSG in the mhi list.. invalid pattern...
		else
		{
			$postComp = "U 1 0 1 $enum NULL $st2";	
		}
		print $newlist "$postComp\n";	# put in list
		$rowContr = <$ContrComp>;
	}
	if(!$rowContr)
	{
		die "couldn't complete compare between mhi list and contr\n";
	}
	close $mhi;
	close $ContrComp;
	close $newlist;
	unlink "URID2.txt";
}

# Create osal tasks list from TASKS_list.h file
sub OSAL_TasksList
{
	open my $newlist, ">TASKS_list.txt" or die "error creating $developDir/fw_src/AutoBuild/objdump/TASKS_list.txt";
	print $newlist "----------------------------Tasks LIST $GEN---------------------------\n";
	my $contrTxtFilePath = "<$outputDir/objects/$core"."_enums.txt";
	open my $ContrComp, $contrTxtFilePath or die "error opening $contrTxtFilePath";

	my $rowContr = <$ContrComp>;
	my $i;
	my $patt = qr/\s+<(\w+)\>\s+(\w+)\s+:\s+(\w+)/;	
	my $lastword;
	my $key;
	my $ignorePatt = "PRIORITY_LIMIT";

	(my $GEN_number) = $GEN =~ /(\d)/;		# get generation
	
	while($rowContr and !($rowContr=~"TASK_KNL_TIMER_TICK"))
	{
		$rowContr = <$ContrComp>;
	}
	if(!$rowContr)
	{
		die "couldn't find tasks list in contr file\n";
	}
	while ($rowContr and !($rowContr=~"TASK_KNL_INTERRUPT_CONTEXT"))
	{
		if($rowContr=~$ignorePatt)
		{
			$rowContr = <$ContrComp>;
		}
		else
		{
			($lastword = $rowContr) =~ s/.*\W(\w)/$1/;
			($key = $rowContr) =~ $patt;
			
			my @arr = split(/\s+/, $rowContr);
			$key = $arr[1];
			
			my @arr1 = split(/\s+/, $rowContr);
			$lastword = $arr1[0]."\n"	;
			
			print $newlist "U 1 0 2 $key $lastword";
			$rowContr = <$ContrComp>;
		}
	}
	if(!$rowContr)
	{
		die "couldn't finish creating tasks list from contr file\n";
	}
	close $ContrComp;
	close $newlist;
}

# update SCD file with messages lists (OSAL and Driver)
sub CreateLists
{
	chdir $developDir.'/fw_src/AutoBuild/';
	unless (-e 'fw_scd_file.scd')
	{
		# Create the file if it doesn't exist
		open my $fc, ">", 'fw_scd_file.scd';
		close $fc;
	}
	
	my $OSAL_LIST = "<./objdump/OSAL_list.txt";
	my $MHI_LIST = "<./objdump/mhi_list.txt";
	my $TASKS_LIST = "<./objdump/TASKS_list.txt";
	my $TLOG = ">./objdump/TLOG.txt";	
	open (OSAL, $OSAL_LIST) or die "couldn't open $developDir/fw_src/AutoBuild/objdump/OSAL_list.txt";
	open (mhi, $MHI_LIST) or die "couldn't open $developDir/fw_src/AutoBuild/objdump/mhi_list.txt";
	open (TASKS, $TASKS_LIST) or die "couldn't open $developDir/fw_src/AutoBuild/objdump/TASKS_list.txt";	
	open (TLOG, $TLOG) or die "couldn't create $developDir/fw_src/AutoBuild/objdump/TLOG.txt";

	# keep on printing the rest of the original scd file
	
	print TLOG <OSAL>;	  # print OSAL list in scd
	print TLOG <mhi>;	  # print driver list in scd
	print TLOG <TASKS>;
	# addition of the OSAL_Tasks info
	
#	close scd;
	close OSAL;
	close mhi;
	close TASKS;	
	close TLOG;
	copy('./objdump/TLOG.txt',"$outputDir/images/fw_scd_with_TLOG.scdt") or die "couldn't copy";
	unlink "./objdump/OSAL_list.txt";
	unlink "./objdump/mhi_list.txt";
	unlink "./objdump/TASKS_list.txt";	

# go here only in few scenarios (all prep activation)
	unlink "./objdump/TLOG.txt";
}

sub Main
{
	$conf = $ARGV[0];
	$outputDir	= $ARGV[1];
	$developDir = $ARGV[2];
	$core = $ARGV[3];
	# print $conf . "\n"; # asic_lower_mac_cpu_wave600_ap_real_phy_wrx600_none
	print("\nmt_tlog.pm, conf: $conf");
	# print $outputDir . "\n"; # C:/work/VersionBuilding/FW_6.0.8/fw_src/output/asic_lower_mac_cpu_wave600_ap_real_phy_wrx600_none
	print("\nmt_tlog.pm, outputDir: $outputDir");
	# print $developDir . "\n"; # C:/work/VersionBuilding/FW_6.0.8
	print("\nmt_tlog.pm, developDir: $developDir");
	# print $core . "\n"; # lower1_mac
	print("\nmt_tlog.pm, core: $core");
	my $GEN = $conf; # get generation
	(my $GEN_number) = $GEN =~ /(\d)/;	# get generation
	# print "TLOG handler\n";
	print("\nmt_tlog.pm, TLOG handler");
	setGen($GEN);
	setOutputDir($outputDir);
	setDevelopDir($developDir);
	chdir $developDir.'/fw_src/AutoBuild/';
	Look_Into_OSAL_UpperMacMessages("$developDir/fw_src/firmware/OSAL/Api/OSAL_UpperMacMessages.h");
	Look_Into_umi_mhi("$developDir/shared_header/mhi_umi.h");		
	my $obdjumpFile = $developDir . '/fw_src/AutoBuild/objdump';
	chdir $obdjumpFile; # convert contr file to txt file...
	OSAL_TasksList; # create new list of osal tasks from contr file
	CompareContrToOsal; # create new list of osal messages based on comparison between OSAL list and contr file
	CompareContrToMhi; # create new list of HW messages based on comparison between HW list and contr file
	CreateLists;	# add the lists to the scd file
	# print "Finished TLOG handler\n";
	print("\nmt_tlog.pm, Finished TLOG handler");
}
1;

Main()