#package NEW_EVENT_PREP;
use File::Copy;
use File::Find;
use File::stat;
use File::Path;
use File::Compare;
#------------------------------------------------------------------------------------------------
#Global Parameters
#------------------------------------------------------------------------------------------------
#Defines
my $prepFileExt  = "prp";
my $TSFileExt    = "timestmp";
my $fileNumber   = 0;
my $c_fileNumber = 0;
#my $h_fileNumber = 0;
my $s_fileNumber = 0;
my $printCount   = 0;
my $printTotalCount   = 0;
#------------------------------------------------------------------------------------------------
#Global Variabels
my $developDir;
my $originID;
my $originName;
my $macrosHdrFile;
my $macrosImpFile;
my $gidFileName;
my $scdFileName;
#Executing application and Save all it's STD_OUT $ STD_ERR outputs
sub Command
{
    my $command  = $_[0];
	
	#print("new_event_prep.pm in: sub Command\ncommand=$command\n");

    my @ret_array;

    open COMMAND_, "$command 2>&1|";
    @ret_array = <COMMAND_>;
    close COMMAND_;

	chomp(@ret_array);
    #foreach(@ret_array){
    #    chomp();
    #}
	
    return @ret_array;
}


sub Run_prepScripts
{
	my $file_name = $_;

	#if ((($file_name=~m/\.c$/) || ($file_name=~m/\.s$/) || ($file_name=~m/\.h$/)) && # to include only .c, .s and .h files
	if (($File::Find::dir !~ m/output/)&&($File::Find::dir !~ m/\.git/)&&(($file_name=~m/\.c$/) || ($file_name=~m/\.s$/))) #to include only .c and .s AND ignore output Dir
		#($File::Find::name ne $macrosHdrFile) && ($File::Find::name ne $macrosImpFile) && # to avoid prepping logprep's output files
		#($File::Find::dir !~ m/output/) && # to avoid prepping files in output dir
		#($file_name ne "MT_Build_Config.h") && ($file_name ne "gid_file.h") && ($file_name ne "loggroups.h") && ($file_name ne "logmacros.h"))
	{
		my $file_dir_path  = $File::Find::dir;
		my $file_full_path = $File::Find::name;
		my $file_ts_path = "$developDir/TimeStamp";
		my $firmwarePath = "$developDir/fw_src/firmware";		
		
		my $preppedFilePath = "$file_full_path.$prepFileExt";
		my $timeStampDirPath  = $file_dir_path;
		$timeStampDirPath  =~ s/$developDir/$file_ts_path/;
		
		my $timeStampFilePath = "$timeStampDirPath/$file_name.$TSFileExt";
		
		if (!-e $timeStampDirPath)
		{
			mkpath($timeStampDirPath);
			# with mkpath() debug print
			#mkpath($file_ts_path, {verbose => 1});
		}
		
		my $ts_file_stat;
		if (-e $timeStampFilePath)
		{
			$ts_file_stat  = stat($timeStampFilePath) or print "No $timeStampFilePath: $!";
			# debug print
			#print("TS file exists, populating its stat\n");
		}
		my $orig_file_stat = stat($file_name) or print "No $file_name: $!\n";
		if ((!-e $timeStampFilePath) || (($ts_file_stat->mtime) <= ($orig_file_stat->mtime)))
		# either no time-stamp file exists or the original file is newer than the time-stamp file, so we need to run logprep on the original file
		{
				# saving the old messages here before the scd is being re-newed by allprep
			$fileNumber++;
			# debug print
			#print("Processing file #$fileNumber\n");
			
			
			if ($file_name=~m/\.c$/)
			{
				$c_fileNumber++;
			}
			if ($file_name=~m/\.s$/)
			{
				$s_fileNumber++;
			}
		#	if ($file_name=~m/\.h$/)
		#	{
		#		$h_fileNumber++;
			#}
			
			# debug and log prints
		#	if (!-e $timeStampFilePath)
		#	{
		#		print("Running allprep.pl on: $file_name because $file_name.$TSFileExt does not exist\n");
		#	}
		#	else
		#	{
		#		# debug variables
		#		#my $mtime1 = scalar($ts_file_stat->mtime);
		#		#my $mtime2 = scalar($orig_file_stat->mtime);
		#		print("Running allprep.pl on: $file_name because $file_name.$TSFileExt is older\n");
		#	}
			
		#	print("Allprepping file: $file_name\n");
			
			$printCount++;
			if ($printCount > 20)
			{
				$printCount = 0;
				$printTotalCount = $printTotalCount + 20;
				print(".... prep is almost done, already processed $printTotalCount files ................\n");
			}
			
			# run allprep
			Command("perl $developDir/fw_src/AutoBuild/allprep.pl multi $originID $originName $gidFileName $macrosHdrFile $macrosImpFile $scdFileName $file_name < $file_full_path > $preppedFilePath");
			if ($? ne 0)
			{
				die "Tragic Error while parsing $file_full_path for prepping logs\n killing script...\n\n";	
			}
			
			my $FC_output = File::Compare::compare_text($file_full_path, $preppedFilePath);
			#my $compare_comand = "echo n|comp $file_full_path $preppedFilePath";
			#$compare_comand =~ s{\/}{\\}g; #change '/' into '\'
			#my @FC_output=Command($compare_comand);
		
			#if($FC_output[1] ne "Files compare OK")
			if ($FC_output == 1)
			## Files are different ##
			{
				# debug prints
				#print("Diff. found \$FC_output[0] = $FC_output[0]\n");
				#print("Diff. found \$FC_output[1] = $FC_output[1]. New file will replace old file\n");
				
				#move(from,to);
				move($preppedFilePath,$file_full_path) or die "Cannot move $preppedFilePath to $file_full_path\n";
			}
			elsif ($FC_output == 0)
			## Files compare OK ##
			{
				#$preppedFilePath =~ s{\/}{\\}g; #change '/' into '\'
				# debug print
				#print("No diff. found. Deleting $preppedFilePath\n");
				unlink $preppedFilePath or die "Cannot unlink $preppedFilePath\n";
				#Command("del /q /f $preppedFilePath");
			}
			else
			{
				die "Error while comparing $file_full_path to $preppedFilePath";
			}
		}
		#else
		#{
		#	# debug print
		#	my $mtime3 = scalar($ts_file_stat->mtime);
		#	my $mtime4 = scalar($orig_file_stat->mtime);
		#	print ("didn't run logprep on: $file_full_path because $mtime3 (ts file mtime) > $mtime4 (orig file mtime)\n");
		#}
		
		# debug prints
		#if (!-e $timeStampFilePath)
		#{
		#	print("TS file does not exist, creating file: $timeStampFilePath\n");
		#}
		#else
		#{
		#	print("TS file exists, touching it\n");
		#}
		
		#open and close it == "touch" it
		open ($timeStampFilePath, '>', $timeStampFilePath) or die("can't open $timeStampFilePath $!\n");
		close $timeStampFilePath or die("can't close $timeStampFilePath $!\n");
	}
}
my @TimeStamp_Dirs;
my $ind;
#my $check;
sub Collect_TimeStamp_Directories
{
	#print ("$File::Find::dir\n");
	$check = ($File::Find::dir !~ m/TimeStamp/);
	#print ("result is $check\n");
	if ($File::Find::dir !~ m/TimeStamp/)
	{
		@TimeStamp_Dirs[$ind] = $File::Find::dir;
		$ind++;
	}
}

#$ARG[0]= Develop Dir
sub Delete_TimeStamp_Files
{
	$developDir = shift;
	$timeStampDir = "$developDir/TimeStamp";
	print ("delete $timeStampDir\n");
	rmtree($timeStampDir);
}

# sub Delete_Automated_Files
# {
	# $developDir = shift;
	
	# my $macrohdr = "$developDir/firmware/logger/api/logmacros.h";
	# my $macroimp = "$developDir/firmware/logger/src/logmacros.c";
	# my $scd		 = "$developDir/AutoBuild/fw_scd_file.scd";
	# my $gid		 = "$developDir/firmware/logger/api/loggroups.h";
	
	# unlink $scd;
	# unlink $gid;
	# unlink $macrohdr;
	# unlink $macroimp;

# }



#------------------------------------------------------------------------------------------------
#Run Process Main Program
#------------------------------------------------------------------------------------------------
 #$ARG[0]= Develop Dir
 #$ARG[1]= origin ID.
 #$ARG[2]= origin name
sub Main
{
	$developDir = $ARGV[0];
	$originID   = $ARGV[1];
	$originName = $ARGV[2];
	$macrosHdrFile = "$developDir/fw_src/firmware/logger/api/logmacros.h";
	$macrosImpFile = "$developDir/fw_src/firmware/logger/src/logmacros.c";
	$macrosImpTemplateFile = "$developDir/fw_src/AutoBuild/logmacros.tmp";
	$macrosHeaderTemplateFile = "$developDir/fw_src/AutoBuild/logmacrosheader.tmp";
	$gidFileName   = "$developDir/fw_src/firmware/logger/Api/loggroups.h";
	$scdFileName   = "$developDir/fw_src/AutoBuild/fw_scd_file.scd";
	
	my @directories = ("$developDir/fw_src/firmware");
	push @directories, "$developDir/regs_rfic";
	
#	unless (-e $macrosImpFile)
#	{
#		copy($macrosImpTemplateFile,$macrosImpFile);
#	}
#	unless (-e $macrosHdrFile)
#	{
#		copy($macrosHeaderTemplateFile,$macrosHdrFile);
#	}
	
	print("Running allprep.pl on files under: @directories\n");
	find(\&Run_prepScripts,@directories);
	print("\n--- Finished running allprep.pl ---\n");
	print("Processed $c_fileNumber *.c files\n");
	#print("Processed $h_fileNumber *.h files\n");
	print("Processed $s_fileNumber *.s files\n");
	print("Total files processed by allprep: $fileNumber\n");

	utime(1234567890,1234567890,$gidFileName);
	utime(1234567890,1234567890,$macrosHdrFile);
	#utime(1234567890,1234567890,$macrosImpFile);	
	
	# return this number which indicates if we need to restore old message list or not
	return $fileNumber;
	#copy(from,to);
	#copy($macrosHdrFile,"$developDir/firmware/logger/api") or die "Cannot copy $macrosHdrFile file to $developDir/firmware/logger/header\n";
	#copy($gidFileName,"$developDir/firmware/logger/header") or die "Cannot copy $gidFileName file to $developDir/firmware/logger/header\n";
	#copy($macrosImpFile,"$developDir/firmware/logger/src") or die "Cannot copy $macrosImpFile file to $developDir/firmware/logger/src\n";
}

Main();