import sys
import os
import shutil
import glob

def RemoveFilesAndFoldersInFolder(folder):
	for the_file in os.listdir(folder):
		file_path = os.path.join(folder, the_file)
		try:
			if os.path.isfile(file_path):
				os.remove(file_path)
			elif os.path.isdir(file_path): 
				shutil.rmtree(file_path)
		except e:
			print ("--- !!! --- exception in RemoveFilesAndFoldersInFolder: " + e)

def remove_folder(path):
	# check if folder exists
	try:
		if os.path.exists(path):
			# remove if exists
			shutil.rmtree(path)
	except OSError as e:
		print ("--- !!! --- exception: " + str(e) + " in remove_folder: " + path)

def RemoveFile(filename):
	try:
		os.remove(filename)
	except OSError:
		pass

def recreate_dir(dir):
	# print("recreate_dir " + dir)
	try:
		if os.path.exists(dir):
			# print(dir + " already exists, removing and creating")
			shutil.rmtree(dir)
		os.makedirs(dir)
	except OSError as e:
		print ("--- !!! --- exception in recreate_dir: " + dir)

def error(msg):
	print("Error: " + msg)
	os.system("pause")
	sys.exit(1)

def hex_to_dec(hex):
	return(int(hex,16))
