/***********************************************************************************
 File:			Protocol_AirTimeAndDuration.h
 Module:		Protocol
 Purpose: 		802.11 Protocol related 
 Description:	Air Time and Duration calculation according to standard
************************************************************************************/
#ifndef PROTOCOL_AIR_TIME_AND_DURATION_H_
#define PROTOCOL_AIR_TIME_AND_DURATION_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Protocol_PhyAttributes.h"
#include "lmi.h"

#ifdef ENET_INC_ARCH_WAVE600
extern const uint16 protocol11axCba256BitAirTimeByRate[];
extern const uint16 protocol11axMba256BitAirTimeByRate[];
extern const uint16 protocol11axMbaPerTidAirTimeByRate[];

#ifdef ENET_INC_ARCH_WAVE600D2
extern const uint16 protocol11axSuExtAckAirTimeRu106[MAX_LDPC_OPTIONS][MAX_DCM_OPTIONS];
extern const uint16 protocol11axSuExtAckAirTimeRu242[MAX_LDPC_OPTIONS][MAX_DCM_OPTIONS];
extern const uint16 protocol11axSuExtBaAirTimeRu106[MAX_LDPC_OPTIONS][MAX_DCM_OPTIONS];
extern const uint16 protocol11axSuExtBaAirTimeRu242[MAX_LDPC_OPTIONS][MAX_DCM_OPTIONS];
#endif //ENET_INC_ARCH_WAVE600D2
#endif //ENET_INC_ARCH_WAVE600
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
#define ACK_DURATION_11A(RATE,LENGTH) ( \
			PREAMBLE_LENGTH_11A + PLCP_HEADER_LENGTH_11A + \
			CEILING((SERVICE_LEN_BITS_11A + LENGTH * 8 + PADDING_LEN_BITS_11A),(RATE * SYMBOL_TIME_11A)) * SYMBOL_TIME_11A) /* Data Portion*/
	
#define ACK_DURATION_11B_SHORT(RATE2) ( \
			PREAMBLE_11B_SHORT + PLCP_HEADER_LENGTH_11B_SHORT + \
			CEILING((SIZEOF_ACK_FRM) * (8*2),RATE2) )
	
#define ACK_DURATION_11B_LONG(RATE2) ( \
			PREAMBLE_11B_LONG + PLCP_HEADER_LENGTH_11B_LONG + \
			CEILING((SIZEOF_ACK_FRM) * (8*2),RATE2) )

#define DURATION_11A(LENGTH,RATE) ( \
			PREAMBLE_LENGTH_11A + PLCP_HEADER_LENGTH_11A + \
			CEILING((SERVICE_LEN_BITS_11A + LENGTH * 8 + PADDING_LEN_BITS_11A),(RATE * SYMBOL_TIME_11A)) * SYMBOL_TIME_11A) /* Data Portion*/

	
#define DURATION_11B_SHORT(LEN,RATE2) ( \
			PREAMBLE_11B_SHORT + PLCP_HEADER_LENGTH_11B_SHORT + \
			CEILING((LEN) * (8*2),RATE2) )
	
#define DURATION_11B_LONG(LEN,RATE2) ( \
			PREAMBLE_11B_LONG + PLCP_HEADER_LENGTH_11B_LONG + \
			CEILING((LEN) * (8*2),RATE2) )

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/
uint16 Protocol_GetAckCts11bAirTime(uint8 rate);
uint16 Protocol_GetAckCts11agAirTime(uint8 rate);
uint16 Protocol_GetRtsCfEnd11bAirTime(uint8 rate);
uint16 Protocol_GetRtsCfEnd11agAirTime(uint8 rate);
uint16 Protocol_GetBaAirTime(uint8 rate);
uint16 Protocol_GetNdp11bAirTime(uint8 rate);
uint16 Protocol_GetNdp11agAirTime(uint8 rate);



#endif /* PROTOCOL_AIR_TIME_AND_DURATION_H_*/
