/***********************************************************************************
 File:			Protocol_PhyAttributes.h
 Module:		802.11 protocol
 Purpose: 		Gather all 802.11 stabndard required definitions
 Description:	All require standard phy definition are gatherd in this file

************************************************************************************/
#ifndef PROTOCOL_PHY_ATTRIBUTES_H_
#define PROTOCOL_PHY_ATTRIBUTES_H_

/*---------------------------------------------------------------------------------
/						Phy Data Rates multiply by 2
/----------------------------------------------------------------------------------*/
#define LM_PHY_11A_DATARATE_6           12   // 11A/G  0      0x00
#define LM_PHY_11A_DATARATE_9           18   // 11A/G  1      0x01
#define LM_PHY_11A_DATARATE_12          24   // 11A/G  2      0x02
#define LM_PHY_11A_DATARATE_18          36   // 11A/G  3      0x03
#define LM_PHY_11A_DATARATE_24          48   // 11A/G  4      0x04
#define LM_PHY_11A_DATARATE_36          72   // 11A/G  5      0x05
#define LM_PHY_11A_DATARATE_48          96   // 11A/G  6      0x06
#define LM_PHY_11A_DATARATE_54          108  // 11A/G  7      0x07

#define LM_PHY_11B_DATARATE_2_SHORT     4    // 11B/G  8      0x21
#define LM_PHY_11B_DATARATE_5_5_SHORT   11   // 11B/G  9      0x22
#define LM_PHY_11B_DATARATE_11_SHORT    22   // 11B/G  10     0x23

#define LM_PHY_11B_DATARATE_1           2    // 11B/G  11     0x24
#define LM_PHY_11B_DATARATE_2           4    // 11B/G  12     0x25
#define LM_PHY_11B_DATARATE_5_5         11   // 11B/G  13     0x26
#define LM_PHY_11B_DATARATE_11          22   // 11B/G  14     0x27

#define LM_PHY_11N_DATARATE_6_5         13   // 11N    15     0x40
#define LM_PHY_11N_DATARATE_13          26   // 11N    16     0x41
#define LM_PHY_11N_DATARATE_19_5        38   // 11N    17     0x42
#define LM_PHY_11N_DATARATE_26          52   // 11N    18     0x43
#define LM_PHY_11N_DATARATE_39          78   // 11N    19     0x44
#define LM_PHY_11N_DATARATE_52          104  // 11N    20     0x45
#define LM_PHY_11N_DATARATE_58_5        117  // 11N    21     0x46
#define LM_PHY_11N_DATARATE_65          130  // 11N    22     0x47
#define LM_PHY_11N_DATARATE_13_R2       26   // 11N    23     0x48
#define LM_PHY_11N_DATARATE_26_R2       52   // 11N    24     0x49
#define LM_PHY_11N_DATARATE_39_R2       78   // 11N    25     0x4A
#define LM_PHY_11N_DATARATE_52_R2       104  // 11N    26     0x4B
#define LM_PHY_11N_DATARATE_78_R2       156  // 11N    27     0x4C
#define LM_PHY_11N_DATARATE_104_R2      208  // 11N    28     0x4D
#define LM_PHY_11N_DATARATE_117_R2      234  // 11N    29     0x4E
#define LM_PHY_11N_DATARATE_130_R2      260  // 11N    30     0x4F
#define LM_PHY_11N_DATARATE_6_DUP       12   // 11N    31     0x50

#define LM_PHY_11N_DATARATE_CB_13_5     27   // 11N    15     0x40
#define LM_PHY_11N_DATARATE_CB_27       54   // 11N    16     0x41
#define LM_PHY_11N_DATARATE_CB_40_5     81   // 11N    17     0x42
#define LM_PHY_11N_DATARATE_CB_54       108  // 11N    18     0x43
#define LM_PHY_11N_DATARATE_CB_81       162  // 11N    19     0x44
#define LM_PHY_11N_DATARATE_CB_108      216  // 11N    20     0x45
#define LM_PHY_11N_DATARATE_CB_121_5    243  // 11N    21     0x46
#define LM_PHY_11N_DATARATE_CB_135      270  // 11N    22     0x47
#define LM_PHY_11N_DATARATE_CB_27_R2    54   // 11N    23     0x48
#define LM_PHY_11N_DATARATE_CB_54_R2    108  // 11N    24     0x49
#define LM_PHY_11N_DATARATE_CB_81_R2    162  // 11N    25     0x4A
#define LM_PHY_11N_DATARATE_CB_108_R2   216  // 11N    26     0x4B
#define LM_PHY_11N_DATARATE_CB_162_R2   324  // 11N    27     0x4C
#define LM_PHY_11N_DATARATE_CB_216_R2   432  // 11N    28     0x4D
#define LM_PHY_11N_DATARATE_CB_243_R2   486  // 11N    29     0x4E
#define LM_PHY_11N_DATARATE_CB_270_R2   540  // 11N    30     0x4F

#define	LM_PHY_11N_DATARATE_144_4_SCP	289  // 11N    64QAM 5/6 SCP nCB
#define	LM_PHY_11N_DATARATE_CB_300_SCP	600  // 11N    64QAM 5/6 SCP CB



/*---------------------------------------------------------------------------------
/						802.11 OFDM PHY definitions 
/----------------------------------------------------------------------------------*/
#define SYMBOL_TIME_11A                 4       /* us */
#define SERVICE_LEN_BITS_11A            16      /* bits */
#define PADDING_LEN_BITS_11A            6       /* bits */
#define PREAMBLE_LENGTH_11A             16      /* us */
#define PLCP_HEADER_LENGTH_11A          4       /* us */


#define DUR_OF_6MBIT_ACK_11A            44      /* us, including preamble and PLCP header */

#define SLOT_TIME_11A                   9
#define SIFS_TIME_11A                   16
#define PIFS_TIME_11A                   (SIFS_TIME_11A + SLOT_TIME_11A)
#define DIFS_TIME_11A                   (SIFS_TIME_11A + (2 * SLOT_TIME_11A))
#define EIFS_TIME_11A                   (SIFS_TIME_11A + \
                                         DUR_OF_6MBIT_ACK_11A + DIFS_TIME_11A)

/* 802.11 DSSS(11B) PHY definitions .*/
#define PREAMBLE_11B_SHORT              72      /* us */
#define PREAMBLE_11B_LONG               144     /* us */
#define PLCP_HEADER_LENGTH_11B_SHORT    24      /* us */
#define PLCP_HEADER_LENGTH_11B_LONG     48      /* us */


#define DUR_OF_2MBIT_ACK_11B_SHORT      152     /* us, including preamble and PLCP header */
#define DUR_OF_1MBIT_ACK_11B_LONG       304     /* us, including preamble and PLCP header */

#define SLOT_TIME_11B                   20		/* us */
#define SIFS_TIME_11B                   10		/* us */
#define PIFS_TIME_11B                   (SIFS_TIME_11B + SLOT_TIME_11B)
#define DIFS_TIME_11B                   (SIFS_TIME_11B + (2 * SLOT_TIME_11B))
#define EIFS_TIME_11B_SHORT             (SIFS_TIME_11B + \
                                         DUR_OF_2MBIT_ACK_11B_SHORT + DIFS_TIME_11B)
#define EIFS_TIME_11B_LONG              (SIFS_TIME_11B + \
                                         DUR_OF_1MBIT_ACK_11B_LONG + DIFS_TIME_11B)


/* Timings for 802.11G (ERP) */
#define PREAMBLE_LENGTH_11G_CCK_OFDM    8       /* uS */
#define SIGNAL_EXTENSION_11G            6       /* uS */
#define CLK_SWITCH_TIME_11G             1       /* uS */

#define DUR_OF_1MBIT_ACK_11G_LONG       DUR_OF_1MBIT_ACK_11B_LONG
#define SLOT_TIME_11G_LONG              SLOT_TIME_11B
#define SLOT_TIME_11G_SHORT             SLOT_TIME_11A

#define SIFS_TIME_11G                   10
#define EIFS_TIME_11G                   EIFS_TIME_11B_LONG

#endif /* PROTOCOL_PHY_ATTRIBUTES_H_*/
