/***********************************************************************************
 File:		Protocol_WmeDefinitions.h
 Module:		Protocol
 Purpose: 	Definitions of  802.11 wme parameters
 Description:	Wme definitions according to standard
************************************************************************************/
#ifndef PROTOCOL_WME_DEFINITIONS_H_
#define PROTOCOL_WME_DEFINITIONS_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ieee80211.h"
#include "ErrorHandler_Api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define FIRST_TID_PER_AC_INDEX	(0)
#define SECOND_TID_PER_AC_INDEX	(1)


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/
typedef struct AccessCategoryTo8021d_s
{
	uint8 val8021d[ACCESS_CATEGORY_NUM][NUMBER_OF_TIDS_PER_AC];
} AccessCategoryTo8021d_t;


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
AccessCategoryTo8021d_t *Protocol_GetAccessCategoryTo8021dConversionTable(void);

#endif /* PROTOCOL_WME_DEFINITIONS_H_ */

