/* CMSynergyVer %full_filespec: frame.h;82:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      Frame definitions
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/common/frame.h $
 **
 ** VERSION:        $Revision: #3 $
 **
 ** DATED:          $Date: 2004/02/24 $
 **
 ** AUTHOR:         S Sondergaard
 **
 ** DESCRIPTION:    802.11 Frame types
 **
 ** LAST MODIFIED BY:   $Author: jh3 $
 **
 **
 ****************************************************************************
 *
 *  (c) Copyright 2000, TTPCom Limited.
 *
 *  (c) Copyright 1994, TTPCom Ltd,
 *
 ****************************************************************************/

#ifndef  FRAME_INCLUDED
#define  FRAME_INCLUDED

#include "System_GlobalDefinitions.h"

#include "rsn.h"
#include "ieee80211.h"
#include "mhi_mib_id.h"

/***************************************************************************/
/***						    Macros                                   ***/
/***************************************************************************/

// Perform division and then ceiling
#define DIV_ROUND_UP(numerator, denominator)  ((numerator + denominator - 1) / denominator)

/*--------------------------------------------------------------------------
 * Macro:       ONES        - return a mask with the lower "n" bits set
 *
 * Parameters:  n               Number of bits to set.
 *              type            Type of result (uint8, uint16, uint32)
 * Returns:     bitmask
 *
 * Description:
 *   Given a number of bits and a type,  returns a bitmask of that type with
 *   the required number of lower bits set.
 *--------------------------------------------------------------------------*/
//#define ONES(n, type)       ((type)(~((~((type)0)) << (n) )))
#define ONES(n, type)       ((type)((0x1 << n)-1))

/*--------------------------------------------------------------------------
 * Macro:       MASK        - return a mask with n bits set shifted left m.
 *
 * Parameters:  u16NBits, nShift, type
 * Returns:     bitmask
 *
 * Description:
 *   Given a number of bits,  a bit offset and a mask type,  returns a bitmask
 *   of that type with the specified number of bits all set at the specified
 *   bit offset from bit zero.
 *--------------------------------------------------------------------------*/

#define MASK(u16NBits, nShift, type) ((type)(ONES(u16NBits,type) << nShift))

/*--------------------------------------------------------------------------
 * For each field,  two macros are defined:
 *      _SHIFT      Is a number by which the field is shifted from the lsb
 *                  of the enclosing field.
 *      _MASK       Is a mask of 1s for all bit positions within the field.
 *
 *--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Definitions for the CONTROL    field within the fixed header             */
/*--------------------------------------------------------------------------*/

#define FM_CONTROL_FTYPE_SHIFT			2
#define FM_CONTROL_FTYPE_MASK			MASK(2, FM_CONTROL_FTYPE_SHIFT, uint16)

#define FM_CONTROL_SUBTYPE_SHIFT		4
#define FM_CONTROL_SUBTYPE_MASK			MASK(4, FM_CONTROL_SUBTYPE_SHIFT, uint16)

#define	FM_CONTROL_TODS_SHIFT			8
#define	FM_CONTROL_TODS_MASK			MASK(1, FM_CONTROL_TODS_SHIFT, uint16)

#define	FM_CONTROL_FROMDS_SHIFT			9
#define	FM_CONTROL_FROMDS_MASK			MASK(1, FM_CONTROL_FROMDS_SHIFT, uint16)

#define	FM_CONTROL_MOREFRAG_SHIFT		10
#define	FM_CONTROL_MOREFRAG_MASK		MASK(1, FM_CONTROL_MOREFRAG_SHIFT, uint16)

#define	FM_CONTROL_RETRY_SHIFT			11
#define	FM_CONTROL_RETRY_MASK			MASK(1, FM_CONTROL_RETRY_SHIFT, uint16)

#define	FM_CONTROL_POWER_SHIFT			12
#define	FM_CONTROL_POWER_MASK			MASK(1, FM_CONTROL_POWER_SHIFT, uint16)

#define	FM_CONTROL_MORE_DATA_SHIFT		13
#define	FM_CONTROL_MORE_DATA_MASK		MASK(1, FM_CONTROL_MORE_DATA_SHIFT, uint16)

#define	FM_CONTROL_PRIVACY_SHIFT		14
#define	FM_CONTROL_PRIVACY_MASK			MASK(1, FM_CONTROL_PRIVACY_SHIFT, uint16)

#define FM_CONTROL_GET_TYPE(u16FrameControl)		(((u16FrameControl) & FM_CONTROL_FTYPE_MASK) >> FM_CONTROL_FTYPE_SHIFT)
#define FM_CONTROL_GET_SUBTYPE(u16FrameControl)		(((u16FrameControl) & FM_CONTROL_SUBTYPE_MASK) >> FM_CONTROL_SUBTYPE_SHIFT)
#define FM_CONTROL_GET_TODS(u16FrameControl)		(((u16FrameControl) & FM_CONTROL_TODS_MASK) >> FM_CONTROL_TODS_SHIFT)
#define FM_CONTROL_GET_FROMDS(u16FrameControl)		(((u16FrameControl) & FM_CONTROL_FROMDS_MASK) >> FM_CONTROL_FROMDS_SHIFT)
#define FM_CONTROL_GET_MOREFRAG(u16FrameControl)	(((u16FrameControl) & FM_CONTROL_MOREFRAG_MASK) >> FM_CONTROL_MOREFRAG_SHIFT)
#define FM_CONTROL_GET_RETRY(u16FrameControl)		(((u16FrameControl) & FM_CONTROL_RETRY_MASK) >> FM_CONTROL_RETRY_SHIFT)
#define FM_CONTROL_GET_POWER(u16FrameControl)		(((u16FrameControl) & FM_CONTROL_POWER_MASK) >> FM_CONTROL_POWER_SHIFT)
#define FM_CONTROL_GET_MOREDATA(u16FrameControl)	(((u16FrameControl) & FM_CONTROL_MORE_DATA_MASK) >> FM_CONTROL_MORE_DATA_SHIFT)
#define FM_CONTROL_GET_PRIVACY(u16FrameControl)		(((u16FrameControl) & FM_CONTROL_PRIVACY_MASK) >> FM_CONTROL_PRIVACY_SHIFT)

/*Macro to determine packet type(control.management,data)*/
#define FM_CONTROL_FTYPE_MANAGEMENT     0
#define FM_CONTROL_FTYPE_CONTROL        1
#define FM_CONTROL_FTYPE_DATA           2
#define FM_CONTROL_FTYPE_EXTENSION		3
#define NUM_OF_FM_CONTROL_FTYPES        3

#define	FM_CONTROL_IS_DATA_FRAME(u16FrameControl)		(FM_CONTROL_GET_TYPE(u16FrameControl) == FM_CONTROL_FTYPE_DATA)

#define FM_CONTROL_POLL                    0x00a4

/* For Data types,  the subtype field contains the following bits */
#define FM_CONTROL_SUBTYPE_DATA            0x0000
#define FM_CONTROL_SUBTYPE_CFACK           0x0010
#define FM_CONTROL_SUBTYPE_CFPOLL          0x0020
#define FM_CONTROL_SUBTYPE_NODATA          0x0040
#define FM_CONTROL_SUBTYPE_QOS             0x0080
#define FM_CONTROL_SUBTYPE_QOS_NULL_DATA   0x00C0

/* For Control types,  the subtype field contains the following bits */
#define FM_CONTROL_SUBTYPE_BACK            0x0090
#define FM_CONTROL_SUBTYPE_CTS             0x00C0
#define FM_CONTROL_SUBTYPE_BAR             0x0080


#define FRAME_SUBTYPE_NULL_DATA_PACKET     			(FM_CONTROL_SUBTYPE_NODATA >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_QOS_NULL_DATA_PACKET 			(FM_CONTROL_SUBTYPE_QOS_NULL_DATA >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_QOS_DATA_PACKET 				(FM_CONTROL_SUBTYPE_QOS >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_QOS_DATA_CFACK_PACKET 		((FM_CONTROL_SUBTYPE_QOS | FM_CONTROL_SUBTYPE_CFACK) >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_QOS_DATA_CFPOLL_PACKET		((FM_CONTROL_SUBTYPE_QOS | FM_CONTROL_SUBTYPE_CFPOLL) >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_QOS_DATA_CFACK_CFPOLL_PACKET	((FM_CONTROL_SUBTYPE_QOS | FM_CONTROL_SUBTYPE_CFACK | FM_CONTROL_SUBTYPE_CFPOLL) >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_DATA_PACKET 					(FM_CONTROL_SUBTYPE_DATA >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_PS_POLL_PACKET 				(FM_CONTROL_POLL >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_BACK 				  		    (FM_CONTROL_SUBTYPE_BACK >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_CTS 				  		    (FM_CONTROL_SUBTYPE_CTS >> FM_CONTROL_SUBTYPE_SHIFT)
#define FRAME_SUBTYPE_BAR 				  		    (FM_CONTROL_SUBTYPE_BAR >> FM_CONTROL_SUBTYPE_SHIFT)

#define SECONDARY_CHANNEL_ABOVE			   0x0001
#define SECONDARY_CHANNEL_BELOW			   0x0003
#define SECONDARY_CHANNEL_NONE			   0x0000

// QOS Control fields (relevant for only some of the QOS data subtypes)

#define FM_QOS_CONTROL_TID_SHIFT			0
#define FM_QOS_CONTROL_TID_MASK				MASK(4, FM_QOS_CONTROL_TID_SHIFT, uint16)

#define FM_QOS_CONTROL_EOSP_SHIFT			4
#define FM_QOS_CONTROL_EOSP_MASK			MASK(1, FM_QOS_CONTROL_EOSP_SHIFT, uint16)

#define FM_QOS_CONTROL_ACK_POLICY_SHIFT		5
#define FM_QOS_CONTROL_ACK_POLICY_MASK		MASK(2, FM_QOS_CONTROL_ACK_POLICY_SHIFT, uint16)

#define FM_QOS_CONTROL_AMSDU_PRESENT_SHIFT	7
#define FM_QOS_CONTROL_AMSDU_PRESENT_MASK	MASK(1, FM_QOS_CONTROL_AMSDU_PRESENT_SHIFT, uint16)

#define FM_QOS_CONTROL_TXOP_INFO_SHIFT		8
#define FM_QOS_CONTROL_TXOP_INFO_MASK		MASK(8, FM_QOS_CONTROL_TXOP_INFO_SHIFT, uint16)

#define FM_QOS_CONTROL_GET_TID(u16QosControl)			(((u16QosControl) & FM_QOS_CONTROL_TID_MASK) 			>> FM_QOS_CONTROL_TID_SHIFT)
#define FM_QOS_CONTROL_GET_EOSP(u16QosControl)			(((u16QosControl) & FM_QOS_CONTROL_EOSP_MASK) 			>> FM_QOS_CONTROL_EOSP_SHIFT)
#define FM_QOS_CONTROL_GET_ACK_POLICY(u16QosControl)	(((u16QosControl) & FM_QOS_CONTROL_ACK_POLICY_MASK) 	>> FM_QOS_CONTROL_ACK_POLICY_SHIFT)
#define FM_QOS_CONTROL_GET_AMSDU_PRESENT(u16QosControl)	(((u16QosControl) & FM_QOS_CONTROL_AMSDU_PRESENT_MASK) 	>> FM_QOS_CONTROL_AMSDU_PRESENT_SHIFT)
#define FM_QOS_CONTROL_GET_TXOP_INFO(u16QosControl)		(((u16QosControl) & FM_QOS_CONTROL_TXOP_INFO_MASK) 		>> FM_QOS_CONTROL_TXOP_INFO_SHIFT)

/*--------------------------------------------------------------------------*/
/* Definitions for the element codes                                        */
/*--------------------------------------------------------------------------*/
#define     FM_EL_TIM                               5   /* Traffic Indicator Map            */
#define     FM_EL_BSS_LOAD                          11
#define     FM_EL_11H_CHANNEL_SWITCH_ANNOUNCEMENT   37
#define		FM_EL_SECONDARY_CH_OFFSET	            62
#define		FM_EL_ADDBA_EXTENSION		            159
#define		FM_EL_WIDE_BW_CH_SWITCH	            	194
#define		FM_EL_CSA_WRAPPER	            		196

#define ACTION_FRAME_MIN_LENGTH				(sizeof(FM_PAYLOAD_ACTION_COMMON) + sizeof(MANAGEMENT_BASIC_FRAME_HEADER))
#define ACTION_FRAME_GENERAL_MIN_LENGTH		(sizeof(FM_PAYLOAD_ACTION_FRAME_GENERAL) + sizeof(MANAGEMENT_BASIC_FRAME_HEADER))

/* Local copy payload size  - taken from Genrisc code */

#define DDR_MAX_MANAGEMENT_PAYLOAD_SIZE					(0x97E) // 2400 bytes as size of MGMT frame



#define FM_ELEMENT_SIZE		(2)  /* Size of non data part of the FM_ELEMENT */

#define HT_CONTROL_SIZE     (4)

#define BSS_LOAD_IE_PAYLOAD_SIZE (5)
#define BSS_LOAD_IE_ELEMENT_SIZE (BSS_LOAD_IE_PAYLOAD_SIZE + FM_ELEMENT_SIZE)

#define CH_SWITCH_COUNT_OFFSET_IN_CSA_FRAME  (sizeof(uint8)/*u8CategoryCode*/ + sizeof(uint8)/*u8ActionCode*/ + sizeof(FM_IE)/*FM_IE*/ + sizeof(uint8)/*ChannelSwitchMode*/ + sizeof(uint8)/*NewChannelNumber*/)

#define FM_SEQUENCE_NUMBER_SHIFT 4
#define FM_SEQUENCE_NUMBER_MASK  MASK(12, FM_SEQUENCE_NUMBER_SHIFT, uint16)

#define FM_SEQUENCE_FRAGMENT_SHIFT 0
#define FM_SEQUENCE_FRAGMENT_MASK  MASK(4, FM_SEQUENCE_FRAGMENT_SHIFT, uint16)

/* Definitions for the bitmap control field (above) */
/* Multicast:  if set,  TIM indicates buffered multicast traffic.  */
#define FM_TBC_MULTICAST_MASK  MASK(1, 0, uint8)

/* BitmapOffset:  Offset between partial and full bitmap (in units of 2 octets) */
#define FM_TBC_BITMAPOFFSET_SHIFT 1
#define FM_TBC_BITMAPOFFSET_MASK  MASK(7, FM_TBC_BITMAPOFFSET_SHIFT, uint8)

/* Max length of essid in bytes */
#define FM_ESSID_MAX_LENGTH 32

#define FM_RATE_MASK                        MASK(7, 0, uint8)

/* 	converts between the following values (as dedined in the 802.11e standard):
	|   In    | out  |
	|00(0)  |    0  |
	|01(1)  |    2  | 
	|10(2)  |    4  | 
	|11(3)  |    6  | */ 
#define CALC_MAX_SP_LENGTH(x) (x << 1)

#define	WME_QOSINFO_COUNT		0x0f	/* Mask for param count field */

/****** How to calculate TIM_MAP_SIZE                                                   ******/
/*                                                                                           */
/* TIM_MAP_SIZE should support number of stations + 1                                        */
/* and to be one such that sizeof TIM_IE_t (bitmap array + TIM_CONST_FIELDS_OFFSET)          */
/* is aligned to 32bit. for example: if number of supported stations is 64,                  */
/* we need 9 bytes to store 65 bits, so we need to choose a number X larger or equal to 9    */
/* so X + TIM_CONST_FIELDS_OFFSET is aligned to 4 bytes. say TIM_CONST_FIELDS_OFFSET is 5    */
/* so the smallest possible X is 11 */
#define TIM_MAP_SIZE    11

/*TWT BitMap*/
//To define the TWT flowid in a consistent way in both set-up and teardown
#define TWT_FLOWID_BIT_WIDTH	3

/* ACK POLICY */
#define DELAY_BA	 0
#define IMMEDIATE_BA 1

/***************************************************************/
/***	 	Management Action Frames						 ***/
/***************************************************************/
/*Octets:		1						1                    
 *		-------------------------------------------------------
 *		|		Category    |	Action Value	 |  payload	  |
 *		-------------------------------------------------------*/
 
/********************************************/
/*			 CATEGORY VALUES				*/
/********************************************/
#define SPECTRUM_MAN_CATEGORY       0
#define QOS_CATEGORY			    1
#define DLS_CATEGORY			    2
#define BLOCK_ACK_CATEGORY		    3
#define PUBLIC_CATEGORY			    4
#define RADIO_MEAS_CATEGORY			5
#define FAST_BSS_CATEGORY			6
#define HT_CATEGORY		            7
#define SA_QUERY_CATEGORY		    8
#define PROTECTED_DUAL_CATEGORY		9
#define WNM_CATEGORY				10
#define UNPROTECTED_WNM_CATEGORY	11
#define TDLS                        12
#define MESH                        13
#define MULTIHOP                    14
#define SELF_PROTECTED              15
#define VHT_CATEGORY                21
#define HE_TWT_CATEGORY             22
#define VENDOR_SPECIFIC_PROTECTED	126
#define VENDOR_SPECIFIC			    ACTION_FRAME_CATEGORY_VENDOR_SPECIFIC //127
#define NUM_ACTION_CATEGORY			128

/********************************************/
/*			 Action field values 			*/
/********************************************/
#define ACTION_VALUE_SHIFT_FROM_CATEGORY  8
/* Spectrum Category*/
#define SPECTRUM_MAN_CATEGORY_CHANNEL_SWITCH_ANNOUNCEMENT		4 
/* HT CATEGORY ACTION VALUES */
#define HT_CATEGORY_SM_POWER_SAVE								1 
#define HT_CATEGORY_COMPRESSED_BEAMFORMING					    6 
/* PUBLIC CATEGORY */
#define PUBLIC_CATEGORY_20_40_COEX								0
#define PUBLIC_CATEGORY_VENDOR_SPECIFIC							9
/* VHT category */
#define VHT_CATEGORY_COMPRESSED_BEAMFORMING                     0
#define VHT_CATEGORY_GROUP_ID_MANAGEMENT                        1
#define VHT_CATEGORY_OPERATING_MODE_NOTIFICATION                2

#define BF_REPROT_ACTION_CATEGORY_AND_VALUE_IN_HT   (HT_CATEGORY | (HT_CATEGORY_COMPRESSED_BEAMFORMING << ACTION_VALUE_SHIFT_FROM_CATEGORY))
#define BF_REPROT_ACTION_CATEGORY_AND_VALUE_IN_VHT  (VHT_CATEGORY | (VHT_CATEGORY_COMPRESSED_BEAMFORMING << ACTION_VALUE_SHIFT_FROM_CATEGORY))

typedef enum
{
	STBC_CAPABILITIES_NO_SUPPORT						= 0,
	STBC_CAPABILITIES_SUPPORT_1_NSS						= 1,
	STBC_CAPABILITIES_SUPPORT_1_2_NSS 					= 2,
	STBC_CAPABILITIES_SUPPORT_1_2_3_NSS					= 3,
	STBC_CAPABILITIES_SUPPORT_1_2_3_4_NSS 				= 4,
	STBC_CAPABILITIES_MAX_VALUE							=255
}StbcSupport_e;

/*----Type Definitions------------------------------------------------------*/

#pragma pack(1)

typedef struct{
	uint16 BlockAckAmsduSupported	:1;
	uint16 BlockAckPolicy			:1;
	uint16 BlockAckTid				:4;
	uint16 BlockAckBufferSize:		10;
} sHT_BA_ParameterSet;

typedef struct{
	uint16 BlockAckFragNum		:4;
	uint16 BlockAckStartSn		:12;
} sHT_BA_StartSn;

typedef struct BlockAckPayload 
{	
    uint16 bar_ack_policy		 	:  1;
    uint16 multi_tid			 	:  1;
    uint16 compressed_bitmap    	:  1;
    uint16 bar_control_reserved 	:  9;
	uint16 TID						:  4;
	sHT_BA_StartSn	u16BlockAckStartSn;
    uint32          u32BitMap[2];
}BlockAckPayload_t;

typedef struct BlockAckFrame
{
	BA_FRAME_HEADER      		FrameHeader;
	BlockAckPayload_t           blockAckPayload;
} BlockAckFrame_t;

// VHT Action frame - Group ID Management 
typedef struct _MembershipStatusArray_t
{
	uint8 MembershipStatusBitmap[8];
} MembershipStatusArray_t;

// VHT Action frame - Group ID Management 
typedef struct _UserPositionArray_t
{
	uint8 UserPositionBitmap[16];
} UserPositionArray_t;

typedef struct _sHT_CAPABILITIES_INFO
{
    uint16  LDPC_coding_capability         :1; // The advanced coding capability field indicates support for advanced coding if its value is 1
    uint16  supported_channel_width_set    :1; // The supported channel width set indicates {20} if its value is 0, and {20, 40} if its value is 1. 
    uint16  SM_power_save                  :2; // The dynamic MIMO Power Save mode indicates that STA or AP asks for assistance to switch to 
    // MIMO from being in steady state of single Rx chain. Such a STA or AP needs that any MIMO 
    // sequence shall be preceded by RTS/CTS. The static MIMO power save mode indicates that station or
    // AP ask not to send MIMO sequences. 
    uint16  green_field                    :1; // The GF field indicates ability to receive frames with Green Field preamble. 
    uint16  short_gi_for_20_mhz            :1; // The Short GI for 20 MHz field indicates support for 20 MHz packets if its value is 1
    uint16  short_gi_for_40_mhz            :1; // The Short GI for 40 MHz field indicates support for 40 MHz packets if its value is 1. 
    uint16  tx_stbc                        :1; // The Rx STBC field indicates support STBC by transmitter.
    uint16  rx_stbc                        :2; // The Rx STBC field indicates support STBC by receiver:
    // 0 = No Rx STBC Support
    // 1 = Rx support of one spatial stream
    // 2 = Rx support of one and two spatial streams
    // 3 = Rx support of one, two and three spatial streams
    uint16  HT_delayed_ba                  :1; // Delayed BA  0 not supported, 1 supported, should be agreed from both sides. 
    uint16  maximal_a_msdu_size            :1; // Maximal A-MSDU size  0- 3839 bytes, 1- 7935 bytes 
    uint16  dsss_cck_mode_at_40_mhz_mode   :1; // DSSS/CCK rates in 40 MHz capable BSS: If this field is 0 in the beacon and probe response then in 
    // this BSS only HTI compatible Stations shall be associated, and 11g compatible devices shall not be
    // associated.  The beacon shall be sent under OFDM basic rate. If this field is 1 the 11g legacy devices
    // may be associated. The HTI station with this field 1 in association request shall be not associated with
    ///@todo This bit should affect all 11g stuff !!!
    // BSS that contains 0 in beacon or probe response.
    uint16  reserved						:1; // The PSMP support field indicates support if set to 1. 
    uint16  fortyMhzIntolerant				:1; // The STBC Control Frame support field indicates that STBC control frames are supported if set to 1.
    uint16  lSigTxop_protection_support    :1; // The L-SIG TXOP Protection support field indicates whether the HT QAP and the HT Station is 
    // capable of supporting the L-SIG field on specific frames which contain duration longer than the
    // remaining packet duration
} sHT_CAPABILITIES_INFO;

typedef struct _sVHT_CAPABILITIES_INFO
{
    uint32  max_mpdu_len					:2; 
    uint32  supported_channel_width_set		:2; 
    uint32  rx_ldpc              		    :1; 
    uint32  short_gi_80_mhz					:1; 
    uint32  short_gi_160_and_80_plus_80_mhz	:1; 
    uint32  tx_stbc							:1; 
    uint32  rx_stbc							:3; 
    uint32  su_beam_former_capable			:1; 
    uint32  su_beam_formee_capable			:1; 
    uint32  beamformee_sts_capability		:3; 
    uint32  number_of_sounding_dimensions	:3; 
    uint32  mu_beamformer_capable			:1; 
    uint32  mu_beamformee_capable			:1; 
    uint32  vht_txop_ps						:1; 
    uint32  plus_htc_vht_capable			:1; 
    uint32  maximum_ampdu_length_exponent	:3;
    uint32  vht_link_adaptation_capable		:2;
    uint32  rx_antenna_pattern_consistency	:1;	
    uint32  tx_antenna_pattern_consistency	:1;	
    uint32  reserved						:2;	
} sVHT_CAPABILITIES_INFO;

typedef struct _HE_MAC_CAPABILITIES_INFO
{
	uint8 HE_CAPABILITIES_EXTENSION_ID;
	
  	uint8 HE_MAC_PLUS_HTC_HE_SUPPORT 										:1;
  	uint8 HE_MAC_TWT_REQUESTER_SUPPORT										:1; 
  	uint8 HE_MAC_TWT_RESPONDER_SUPPORT										:1;
  	uint8 HE_MAC_FRAGMENTATION_SUPPORT										:2;
  	uint8 HE_MAC_MAXIMUM_NUMBER_OF_FRAGMENTED_MSDUS_OR_AMSDUS_EXPONENT		:3;
	
  	uint16 HE_MAC_MINIMUM_FRAGMENT_SIZE										:2;
  	uint16 HE_MAC_TRIGGER_FRAME_MAC_PADDING_DURATION						:2;	
  	uint16 HE_MAC_MULTI_TID_AGGREGATION_RX_SUPPORT							:3;
  	uint16 HE_MAC_HE_LINK_ADAPTATION_SUPPORT								:2;
  	uint16 HE_MAC_ALL_ACK_SUPPORT											:1;
	uint16 HE_MAC_UL_MU_RESPONSE_SCHEDULING_SUPPORT							:1;
	uint16 HE_MAC_A_BSR_SUPPORT												:1;
	uint16 HE_MAC_BROADCAST_TWT_SUPPORT										:1;
	uint16 HE_MAC_32BIT_BA_BITMAP_SUPPORT									:1;
	uint16 HE_MAC_MU_CASCADING_SUPPORT										:1;
	uint16 HE_MAC_ACK_ENABLED_MULTI_TID_AGGREGATION_SUPPORT					:1;
	
	uint8 HE_MAC_RESERVED0													:1;
	uint8 HE_MAC_OMI_A_CONTROL_SUPPORT										:1;
	uint8 HE_MAC_OFDMA_RA_SUPPORT											:1;
	uint8 HE_MAC_MAXIMUM_A_MPDU_LENGTH_EXPONENT 							:2;
	uint8 HE_MAC_A_MSDU_FRAGMENTATION_SUPPORT								:1;
	uint8 HE_MAC_FLEXIBLE_TWT_SCHEDULE_SUPPORT 								:1;
	uint8 HE_MAC_RX_CONTROL_FRAME_TO_MULTIBSS								:1;
	
	uint16 HE_MAC_BSRP_BQRP_A_MPDU_AGGREGATION 								:1;
	uint16 HE_MAC_QTP_SUPPORT												:1;
	uint16 HE_MAC_BQR_SUPPORT												:1;
	uint16 HE_MAC_SRP_RESPONDER												:1;
	uint16 HE_MAC_NDP_FEEDBACK_REPORT_SUPPORT								:1;
	uint16 HE_MAC_OPS_SUPPORT												:1;
	uint16 HE_MAC_A_MSDU_IN_A_MPDU_SUPPORT									:1;
	uint16 HE_MAC_MULTI_TID_AGGREGATION_TX_SUPPORT							:3;	
	uint16 HE_MAC_HE_SUBCHANNEL_SELECTIVE_TX_SUPPORT						:1;
	uint16 HE_MAC_UL_2X996_TONE_RU_SUPPORT									:1;
	uint16 HE_MAC_OM_CONTROL_UL_MU_DATA_DISABLE_RX_SUPPORT					:1;
	uint16 HE_MAC_DYNAMIC_SM_POWER_SAVE										:1;	
	uint16 HE_MAC_PUNCTURED_SOUNDING_SUPPORT								:1;	
	uint16 HE_MAC_HT_VHT_TRIGGER_FRAME_RX_SUPPORT							:1;	
} HE_MAC_CAPABILITIES_INFO;

typedef struct _HE_PHY_CAPABILITIES_INFO
{
  	uint8 HE_PHY_RESERVED0		 											:1;
  	uint8 HE_PHY_CHANNEL_WIDTH_SET_B0										:1; 	// 40 MHz, 2.4GHz
  	uint8 HE_PHY_CHANNEL_WIDTH_SET_B1										:1;		// 40 and 80 MHz, 5GHz
  	uint8 HE_PHY_CHANNEL_WIDTH_SET_B2										:1;		// 160 MHz, 5GHz
  	uint8 HE_PHY_CHANNEL_WIDTH_SET_B3										:1;		// 80+80  MHz, 5GHz
  	uint8 HE_PHY_CHANNEL_WIDTH_SET_B4										:1;		//RUs in 40 MHz, 2.4GHz
  	uint8 HE_PHY_CHANNEL_WIDTH_SET_B5										:1;		//RUs in 40 and 80 MHz, 5GHz
  	uint8 HE_PHY_CHANNEL_WIDTH_SET_B6										:1;		// reserved
  	
  	uint16 HE_PHY_PREAMBLE_PUNCTURING_RX									:4;
  	uint16 HE_PHY_DEVICE_CLASS												:1;
  	uint16 HE_PHY_LDPC_CODING_IN_PAYLOAD									:1;
  	uint16 HE_PHY_HE_SU_PPDU_WITH_1X_HE_LTF_AND_0_8_US_GI					:1;
  	uint16 HE_PHY_MIDAMBLE_TX_RX_MAX_NSTS									:2;
  	uint16 HE_PHY_NDP_WITH_4X_HE_LTF_AND_3_2_US_GI							:1;	
  	uint16 HE_PHY_STBC_TX_FOR_LESS_THAN_OR_EQUAL_80MHZ						:1;
  	uint16 HE_PHY_STBC_RX_FOR_LESS_THAN_OR_EQUAL_80MHZ						:1;
	uint16 HE_PHY_DOPPLER_TX												:1;
	uint16 HE_PHY_DOPPLER_RX												:1;
  	uint16 HE_PHY_FULL_BW_UL_MU												:1;	
  	uint16 HE_PHY_PARTIAL_BW_UL_MU											:1;	
	
	uint8 HE_PHY_DCM_MAX_CONSTELLATION_TX									:2;
	uint8 HE_PHY_DCM_MAX_NSS_TX												:1;
	uint8 HE_PHY_DCM_MAX_CONSTELLATION_RX									:2;
	uint8 HE_PHY_DCM_MAX_NSS_RX												:1;
	uint8 HE_PHY_RX_PARTIAL_BW_SU_USING_HE_MU_PPDU_FROM_NON_AP_STA			:1;
	uint8 HE_PHY_SU_BEAMFORMER												:1;
	
	uint8 HE_PHY_SU_BEAMFORMEE												:1;
	uint8 HE_PHY_MU_BEAMFORMER												:1;
	uint8 HE_PHY_BEAMFORMEE_STS_FOR_LESS_THAN_OR_EQUAL_80MHz				:3;
	uint8 HE_PHY_BEAMFORMEE_STS_FOR_GREATER_THAN_80MHz						:3;
	
	uint8 HE_PHY_NUMBER_OF_SOUNDING_DIMENSIONS_FOR_LESS_THAN_OR_EQUAL_80MHZ	:3;
	uint8 HE_PHY_NUMBER_OF_SOUNDING_DIMENSIONS_FOR_GREATER_THAN_80MHz 		:3;
	uint8 HE_PHY_NG_16_FOR_SU_FEEDBACK_SUPPORT								:1;
	uint8 HE_PHY_NG_16_FOR_MU_FEEDBACK_SUPPORT 								:1;
	
	uint8 HE_PHY_CODEBOOK_SIZE42_FOR_SU_SUPPORT								:1;
	uint8 HE_PHY_CODEBOOK_SIZE75_FOR_MU_SUPPORT								:1;
	uint8 HE_PHY_TRIGERRED_SU_BEAMFORMING_FEEDBACK							:1;
	uint8 HE_PHY_TRIGERRED_MU_BEAMFORMING_PARTIAL_BW_FEEDBACK				:1;
	uint8 HE_PHY_TRIGERRED_CQI_FEEDBACK										:1;
	uint8 HE_PHY_PARTIAL_BANDWIDTH_EXTENDED_RANGE 							:1;
	uint8 HE_PHY_DL_MU_MIMO_ON_PARTIAL_BANDWIDTH							:1;
	uint8 HE_PHY_PPE_THRESHOLD_PRESENT										:1;

	uint8 HE_PHY_SRP_BASED_SR_SUPPORT										:1;
	uint8 HE_PHY_POWER_BOOST_FACTOR_SUPPORT									:1;
	uint8 HE_PHY_HE_SU_PPDU_AND_HE_MU_WITH_4X_HE_LTF_AND_0_8US_GI			:1;
	uint8 HE_PHY_MAX_NC														:3;	
  	uint8 HE_PHY_STBC_TX_FOR_GREATER_THAN_80MHZ								:1;
  	uint8 HE_PHY_STBC_RX_FOR_GREATER_THAN_80MHZ								:1;

	uint8 HE_PHY_HE_ER_SU_PPDU_4X_HE_LTF_0_8_US_GI							:1;
	uint8 HE_PHY_20MHZ_IN_40MHZ_HE_PPDU_2_4_GHZ_BAND						:1;
	uint8 HE_PHY_20MHZ_IN_160MHZ_HE_PPDU									:1;
	uint8 HE_PHY_80MHZ_IN_160MHZ_HE_PPDU									:1;
	uint8 HE_PHY_HE_ER_SU_PPDU_1X_HE_LTF_0_8_US_GI							:1;
  	uint8 HE_PHY_MIDAMBLE_TX_RX_2X_AND_1X_HE_LTF							:1;	
  	uint8 HE_PHY_DCM_MAX_BW													:2;

	uint16 HE_PHY_LONGER_THAN_16_HE_SIGB_OFDM_SYMBOLS_SUPPORT				:1;
	uint16 HE_PHY_NON_TRIGGERED_CQI_FEEDBACK								:1;
	uint16 HE_PHY_TX_1024_QAM_LESS_THAN_242_TONE_RU_SUPPORT					:1;
	uint16 HE_PHY_RX_1024_QAM_LESS_THAN_242_TONE_RU_SUPPORT					:1;
	uint16 HE_PHY_RX_FULL_BW_SU_USING_HE_MU_PPDU_WITH_COMPRESSED_SIGB		:1;
	uint16 HE_PHY_RX_FULL_BW_SU_USING_HE_MU_PPDU_WITH_NON_COMPRESSED_SIGB	:1;
  	uint16 HE_PHY_NOMINAL_PACKET_PADDING									:2;
  	uint16 HE_PHY_RESERVED1 												:8;
} HE_PHY_CAPABILITIES_INFO;

typedef struct _HE_MCS_SUPPORT
{
	uint8 rx_max_mcs_less_or_equal_80_MHz_1_NSS	:2;
	uint8 rx_max_mcs_less_or_equal_80_MHz_2_NSS	:2;
	uint8 rx_max_mcs_less_or_equal_80_MHz_3_NSS	:2;
	uint8 rx_max_mcs_less_or_equal_80_MHz_4_NSS	:2;
	
	uint8 rx_max_mcs_less_or_equal_80_MHz_5_NSS	:2;
	uint8 rx_max_mcs_less_or_equal_80_MHz_6_NSS	:2;
	uint8 rx_max_mcs_less_or_equal_80_MHz_7_NSS	:2;
	uint8 rx_max_mcs_less_or_equal_80_MHz_8_NSS	:2;
	
	uint16 Supported_HE_MCS_and_Nss_Set_TX_HE_MCS_Map_less_or_equal_80_MHz;

	uint8 rx_max_mcs_160_MHz_1_NSS				:2;
	uint8 rx_max_mcs_160_MHz_2_NSS				:2;
	uint8 rx_max_mcs_160_MHz_3_NSS				:2;
	uint8 rx_max_mcs_160_MHz_4_NSS				:2;
	
	uint8 rx_max_mcs_160_MHz_5_NSS				:2;
	uint8 rx_max_mcs_160_MHz_6_NSS				:2;
	uint8 rx_max_mcs_160_MHz_7_NSS				:2;
	uint8 rx_max_mcs_160_MHz_8_NSS				:2;

	uint16 Supported_HE_MCS_and_Nss_Set_TX_HE_MCS_Map_160_MHz;
} HE_MCS_SUPPORT;

typedef struct _HE_PPE_THRESHOLDS
{
	uint8 HE_PPE_THRESHOLDS_NSS_M1 											:3;
  	uint8 HE_PPE_THRESHOLDS_RU_INDEX_BITMASK								:4; 
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS1_FOR_RU0							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS1_FOR_RU0							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS1_FOR_RU1							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS1_FOR_RU1							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS1_FOR_RU2							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS1_FOR_RU2							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS1_FOR_RU3							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS1_FOR_RU3							:3;
	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS2_FOR_RU0							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS2_FOR_RU0							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS2_FOR_RU1							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS2_FOR_RU1							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS2_FOR_RU2							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS2_FOR_RU2							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS2_FOR_RU3							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS2_FOR_RU3							:3;
	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS3_FOR_RU0							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS3_FOR_RU0							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS3_FOR_RU1							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS3_FOR_RU1							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS3_FOR_RU2							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS3_FOR_RU2							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS3_FOR_RU3							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS3_FOR_RU3							:3;
	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS4_FOR_RU0							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS4_FOR_RU0							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS4_FOR_RU1							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS4_FOR_RU1							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS4_FOR_RU2							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS4_FOR_RU2							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET16_FOR_NSS4_FOR_RU3							:3;
  	uint8 HE_PPE_THRESHOLDS_PPET8_FOR_NSS4_FOR_RU3							:3;
	uint8 HE_PPE_THRESHOLDS_PPE_PAD											:1;
} HE_PPE_THRESHOLDS;

typedef struct _HE_MAC_PHY_CAPABILITIES_INFO
{
	HE_MAC_CAPABILITIES_INFO	heMacCapInfo;
	HE_PHY_CAPABILITIES_INFO	hePhyCapInfo;
} HE_MAC_PHY_CAPABILITIES_INFO;

typedef struct _HE_CAPABILITIES_INFO
{
	HE_MAC_PHY_CAPABILITIES_INFO	heMacPhyCapInfo;
	HE_MCS_SUPPORT					heMcsSupport;
	HE_PPE_THRESHOLDS				hePpeTh;
} HE_CAPABILITIES_INFO;

typedef struct _sTransmitBfCapInfo
{
    uint32  implicit_transmit_Beamforming_receiving_capable					:1; 
    uint32  receive_staggered_sounding_capable 								:1; 
    uint32  transmit_staggered_sounding_capable 							:1; 
    uint32  receive_ndp_capable												:1; 
    uint32  transmit_ndp_capable											:1; 
    uint32  implicit_transmit_beamforming_capable							:1; 
    uint32  calibration														:2; 
    uint32  explicit_csi_transmit_beamformng_capable						:1; 
    uint32  expllicit_noncompresses_steering_capable						:1; 
    uint32  explicit_compressed_steering_capable							:1; 
    uint32  explicit_transmit_beamforming_csi_feedback						:2; 
    uint32  explicit_noncompressed_beamforming_feedback_capable				:2; 
    uint32  explicit_compressed_beamforming_feedback_capable				:2; 
    uint32  minimal_grouping												:2;
    uint32  csi_number_of_beamforming_antennas_supported					:2;
    uint32  noncompressed_steering_number_of_beamformer_antennas_supported	:2;
    uint32  compressed_steering_number_of_beamformer_antennas_supported		:2;
    uint32  csi_max_number_of_rows_beamformier_supported					:2;	
    uint32  channel_estimation_capability									:2;	
	uint32 	reserved 														:3;
} sTransmitBfCapInfo;

typedef struct _sHT_SECONDARY_CHANNEL_OFFSET 
{
    uint8 Secondary_Channel_Offset;
} sHT_SECONDARY_CHANNEL_OFFSET;

typedef struct _sHT_WIDE_BW_CHANNEL_SWITCH
{
	uint8	channelWidth;
	uint8	centerFreq0Idx;
	uint8	centerFreq1Idx;
} sHT_WIDE_BW_CHANNEL_SWITCH;

typedef struct 
{
    uint8 ChannelSwitchMode;  // A Channel Switch Mode set to 1 means that the STA in a BSS to which the frame containing the element is addressed shall transmit no further frames within the BSS until the scheduled channel switch. A Channel Switch Mode set to 0 does not impose any requirement on the receiving STA.
    uint8 NewChannelNumber;   // the number of the channel to which the STA is moving
    uint8 ChannelSwitchCount; // the number of TBTTs until the STA sending the Channel Switch Announcement element switches to the new channel
                              // 1 indicates that the switch shall occur immediately before the next TBTT
                              // 0 indicates that the switch shall occur at any time after the frame containing the element is transmitted
} S11H_CHANNEL_SWITCH_ANNOUNCEMENT_ELEMENT;

typedef struct 
{
    uint16 	stationCount;
    uint8 	channelUtilization;
    uint16 	availableAdmissionCapacity;
}BSS_LOAD_ELEMENT;

typedef struct
{
    uint8	u8DTIMcount;
    uint8	u8DTIMperiod;
    uint8   u8BitmapControl;
    uint8	au8PartialVirtualBitmap[TIM_MAP_SIZE];  /* Variable length */
} FM_TIM;

// this struct must have a size which is multiple of 4, since Delia uses it for transmission.
typedef struct  
{
	uint8  id;
	uint8  length;
	FM_TIM fmTimElement;
} TIM_IE_t;
typedef struct _FM_MTLK_PROPRIETARY_OUI
{
    uint8 au8OUI[3];
	uint8 u8Padding;
} FM_MTLK_PROPRIETARY_OUI;

typedef struct{
	uint16 BlockAckRes			:11;
	uint16 BlockAckInitiator	:1;
	uint16 BlockAckTid			:4;
} sHT_DELBA_ParameterSet;

typedef struct {
    uint8      u8Code;     /* element code                              */
    uint8      u8Length;   /* Length of element (not inc hcode and len) */
}   FM_IE;

typedef struct {
	FM_IE		ie;
	S11H_CHANNEL_SWITCH_ANNOUNCEMENT_ELEMENT csa;
} CSA_IE;

typedef struct {
	FM_IE		ie;
	BSS_LOAD_ELEMENT bssLoad;
} BSS_LOAD_IE;

typedef struct {
	FM_IE		ie;
	sHT_SECONDARY_CHANNEL_OFFSET sec;
} SEC_IE;

typedef struct {
	FM_IE		ie;
	sHT_WIDE_BW_CHANNEL_SWITCH wideBw;
} WIDE_BW_IE;

typedef struct {
	FM_IE		ie;
	WIDE_BW_IE  wideBwIe;	/*We only include the WIDE BW IE in the Channel Switch Wrapper IE*/
} CSA_WRAPPER_IE;

typedef struct {
    uint8	u8CategoryCode;
    uint8	u8ActionCode;
	CSA_IE 	csaIe;
	SEC_IE 	secIe;
	WIDE_BW_IE 	wideBwIe;
} FM_PAYLOAD_CSA;

typedef struct {
    uint16	reasonCode;
} FM_PAYLOAD_DEAUTHENTICATION;

typedef struct {
    uint8	u8CategoryCode;
    uint8	u8ActionCode;
    uint8	u8DialogToken;
} FM_PAYLOAD_ACTION_FRAME_GENERAL;

typedef struct FM_PAYLOAD_ACTION_COMMON {
    uint8	u8CategoryCode;
    uint8	u8ActionCode;
} FM_PAYLOAD_ACTION_COMMON;

typedef struct {
    uint8	u8CategoryCode;
    uint8	u8ActionCode;
} FM_PAYLOAD_SHORT_ACTION_FRAME;

typedef struct {
    uint8	u8CategoryCode;
    uint8	u8ActionCode;
	FM_MTLK_PROPRIETARY_OUI vendorSpecificPayload;
} FM_PAYLOAD_MANAGEMENT_ACTION_PUBLIC_FRAME;

typedef struct {
    uint8	u8CategoryCode;
    uint8	u8ActionCode;
    uint8	u8DialogToken;
    sHT_BA_ParameterSet	u16BlockAckParameterSet;
	uint16	u16BlockAckTimeOut;
	sHT_BA_StartSn	u16BlockAckStartSn;
} FM_PAYLOAD_ADDBA_REQ;

typedef struct {
    uint8	u8CategoryCode;
    uint8	u8ActionCode;
    uint8	u8DialogToken;
	uint16	u16StatusCode;
    sHT_BA_ParameterSet	u16BlockAckParameterSet;
	uint16	u16BlockAckTimeOut;
} FM_PAYLOAD_ADDBA_RES;

typedef struct {
    uint8	u8CategoryCode;
    uint8	u8ActionCode;
    sHT_DELBA_ParameterSet	u16DelBaParameterSet;
	uint16	u16ResonCode;
} FM_PAYLOAD_DELBA;

typedef struct
{
    uint8	u8ElementId;
    uint8	u8Length;
    uint8	u8AddbaCapabilities;
} FM_PAYLOAD_ADDBA_EXTENSION_ELEMENT;

typedef struct AddbaCapabilities_
{
    uint8	no_fragmentation			:1;	// for Non-HE 
    uint8	he_fragmentation_operation	:2; // for HE
    uint8	reserved					:5;
} AddbaCapabilities_t;

typedef struct BarPayload 
{
    uint16 bar_ack_policy		 	:  1;
    uint16 multi_tid			  	:  1;
    uint16 compressed_bitmap    	:  1;
    uint16 bar_control_reserved 	:  9;
	uint16 TID                  	:  4;
	sHT_BA_StartSn	u16BlockAckStartSn;
} BarPayload_t;

typedef struct _GroupIdManagementPayload_t
{
	uint8					CategoryCode;
	uint8					ActionCode;
	MembershipStatusArray_t MemberShipStatus;
	UserPositionArray_t		UserPosition;	
} GroupIdManagementPayload_t;

typedef struct _NdpaStaInfo_t
{
	uint16 aid 			:12;
	uint16 feedbackType :1;
	uint16 ncIndex : 3;
} NdpaStaInfo;

typedef struct _NdpaPayload_t
{
	uint8 soundingToken;
	NdpaStaInfo stationsInfo[16]; //max number of stations supported
} NdpaPayload_t;


typedef struct _TriggerFramePayloadCommon_t
{
	/*Word0*/
	uint32	triggerType				:4;
	uint32	length					:12;
	uint32	cascadeIndication 		:1;
	uint32	csRequired 				:1;
	uint32	bw						:2;
	uint32	cpAndLtfType	 		:2;
	uint32 	muMimoLtfMode			:1;
	uint32 	nHeLtf					:3;
	uint32 	stbc					:1;
	uint32 	ldpcExtraSymbol			:1;
	uint32 	apTxPower_0_3			:4;

	/*Word1*/
	uint32	apTxPower_4_5			:2;
	uint32	aFactor					:2;
	uint32	peDisambiguty	 		:1;
	uint32	a2HeSigaSpatialReuse	:16;
	uint32	doppler					:1;
	uint32	heSigAReserved		 	:9;
	uint32 	reserved				:1;
} TriggerFramePayloadCommon_t;

typedef struct _TriggerFramePayloadPerUser_t
{
	/*Word0*/
	uint32	aid						:12;
	uint32	ruAllocation			:8;
	uint32	codingType		 		:1;
	uint32	mcs		 				:4;
	uint32	dcm						:1;
	uint32	ssAllocationLowestSs	:3;
	uint32 	ssAllocationNss			:3;

	/*Word1* (16 bit)*/
	uint16	targetRssi				:7;
	uint16	Reserved				:1;
	uint16	mpduMuSpacingFactor		:2;
	uint16	tidAggLimit				:3;
	uint16	acPrefferedLevel		:1;
	uint16	prefferedAc		 		:2;
} TriggerFramePayloadPerUser_t;


typedef struct _BasicTriggerFramePayload_t
{
	TriggerFramePayloadCommon_t commonSection;
	TriggerFramePayloadPerUser_t perUserSection[MAX_NUM_OF_TRIGGER_FRAME_STATIONS];
} BasicTriggerFramePayload_t;


typedef struct OperatingModeField
{
	uint8	channelWidth	:2;
	uint8	reserved		:2;
	uint8	rxNss			:3;
	uint8	rxNssType		:1;
} OperatingModeField_t;

typedef struct OperatingModeNotificationPayload
{
	uint8					categoryCode;
	uint8					actionCode;
	OperatingModeField_t	operatingModeField;
} OperatingModeNotificationPayload_t;

typedef struct AddbaRequestFrame
{
	FM_PAYLOAD_ADDBA_REQ addbaRequestPayload;
#if defined(ENET_INC_ARCH_WAVE600)
	FM_PAYLOAD_ADDBA_EXTENSION_ELEMENT AddbaExtension; // Currently we support only this IE. There can be others.
#endif	
} AddbaRequestFrame_t;


typedef struct TwtSetupFramePayload
{   
    uint8                   dialogToken; 
    uint8                   elementId;
    uint8                   length;
    uint8                   ndpPagingIndicator  :1;
    uint8                   responderPmMode     :1;
    uint8                   negotiationType     :2;
    uint8                   reserved            :4;
    uint16                  twtRequest          :1;
    uint16                  twtSetupCommand     :3;
    uint16                  trigger             :1;
    uint16                  implicit            :1; 
    uint16                  flowType            :1;    
    uint16                  twtFlowIdentifier   :TWT_FLOWID_BIT_WIDTH;//To define the TWT flowid in a consistent way in both set-up and teardown
    uint16                  wakeIntervalExponent:5;
    uint16                  twtProtection       :1; 
    uint64                  targetWakeTime;
    uint8                   nominalTwtWakeDuration;
    uint16                  twtWakeIntervalMantissa;
    uint8                   twtChannel;
}TwtSetupFramePayload_t;   

typedef struct TwtTeardownFramePayload
{
    uint8                   twtFlowIdentifier   :TWT_FLOWID_BIT_WIDTH;//To define the TWT flowid in a consistent way in both set-up and teardown
    uint8                   reserved            :5; 
}TwtTeardownFramePayload_t;  

typedef struct _TwtFramePayload_t
{   
    uint8                   categoryCode;
    uint8                   actionCodeS1G;
    union
    {
        TwtSetupFramePayload_t setup;            
        TwtTeardownFramePayload_t teardown;        
    };                 
} TwtFramePayload_t;


typedef struct AddbaResponseFrame
{
	FM_PAYLOAD_ADDBA_RES addbaResponsePayload;
#if defined(ENET_INC_ARCH_WAVE600)
	FM_PAYLOAD_ADDBA_EXTENSION_ELEMENT AddbaExtension; // Currently we support only this IE. There can be others.
#endif	
} AddbaResponseFrame_t;

typedef struct BarFrame
{
	BAR_FRAME_HEADER      		FrameHeader;
	BarPayload_t                barPayload;
} BarFrame_t;


typedef struct _NdpaFrame_t
{
	NDPA_FRAME_HEADER			frameHeader;
	NdpaPayload_t				ndpaPayload;
} NdpaFrame_t;


typedef struct _TriggerFrame_t
{
	TRIGGER_FRAME_HEADER frameHeader;
	BasicTriggerFramePayload_t triggerFramePayload;
} TriggerFrame_t;


#pragma pack()

/***************************************************************************/
/***                  Global data                                        ***/
/***************************************************************************/

/***************************************************************************/
/***                  Public Routines                                    ***/
/***************************************************************************/

extern bool boFRAME_IsQosCtrlPresent(FRAME_HEADER *);
bool frame_isHtControlPresent(MANAGEMENT_BASIC_FRAME_HEADER* pManagementFrame);
void* frame_getPayloadPointerFromExistingManagementFrame(MANAGEMENT_BASIC_FRAME_HEADER* pManagmentFrame);
void* frame_getPayloadPointerForNewManagementFrame(MANAGEMENT_BASIC_FRAME_HEADER* pManagmentFrame, bool isHtcPresent);
uint32 frame_sizeOfExistingManagementFrameHeader(MANAGEMENT_BASIC_FRAME_HEADER* pManagementFrame);
uint32 frame_sizeOfNewManagementFrameHeader(bool isHtcPresent);

#endif     /* MODULE_INCLUDED */
/* End of Module */

