/************************************************************************************
*
*	File:				ieee80211.h
*	Description:		
*
*						
*
*	COPYRIGHT:
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/
#ifndef  IEEE80211_INCLUDED
#define  IEEE80211_INCLUDED

#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "ieee_address.h"


/***************************************************************************/
/***                              Defines                                ***/
/***************************************************************************/


/* Minimum value for the fragmentation threshold,  bytes */

#define MIN_FRAGMENTATION_THRESHOLD     (256)

/* Max length of MSDU (bytes) */

#define MSDU_MAX_LENGTH                 (1600) // was 2304 (omri). this affects the number of allocated FSDUs, MIB defaults, TTP tests, etc.
#define MSDU_MAX_FRAGS                  (16)


/* OFDM PHY Specific constants */

/* This is the maximum length supported by the PHY in bytes */

#define MPDU_MAX_LENGTH                 (4095)

#define EXPONENT_TO_VALUE(v)	        ((1<<(v))-1)
#define VALUE_TO_EXPONENT(v)	        (32 - Utils_CountLeadingZeros(v)) /* Convert CWmin/CWmax integer to exponent */

/*2^x -1 --> 15 slots */
#define CW_MIN_BK_11A                   4    
#define CW_MIN_BE_11A                   4    
#define CW_MIN_VI_11A                   3    
#define CW_MIN_VO_11A                   2    

/*2^x -1 --> 1023 slots */
#define CW_MAX_BK_11A                   10   
#define CW_MAX_BE_11A                   10   
#define CW_MAX_VI_11A                   4   
#define CW_MAX_VO_11A                   3   
#define CW_MAX_BE_AP_11A                6
   

#define CW_MIN_BK_11B                   5      
#define CW_MIN_BE_11B                   5      
#define CW_MIN_VI_11B                   4      
#define CW_MIN_VO_11B                   3    
  
#define CW_MAX_BK_11B                   12    
#define CW_MAX_BE_11B                   10    
#define CW_MAX_VI_11B                   5    
#define CW_MAX_VO_11B                   4    
#define CW_MAX_BE_AP_11B                7

 /* !!!! - values used by the lower mac and Gtum for debug 
	this are the 2 power -1 of default values */
#define CW_MIN_11B EXPONENT_TO_VALUE(CW_MIN_BE_11B)
#define CW_MAX_11B EXPONENT_TO_VALUE(CW_MAX_BE_11B)

#define CW_MIN_11A EXPONENT_TO_VALUE(CW_MIN_BE_11A)
#define CW_MAX_11A EXPONENT_TO_VALUE(CW_MAX_BE_11A)

#define NUM_802_1D_FRAME_PRIORITIES   8

//      802.1D Priority      802.1D Designation
//      -----------------    ------------------
#define IEEE802_1D_BK_1 1 // BK (Lowest)
#define IEEE802_1D_BK_2 2 // -
#define IEEE802_1D_BE_1 0 // BE
#define IEEE802_1D_BE_2 3 // EE
#define IEEE802_1D_VI_1 4 // CL
#define IEEE802_1D_VI_2 5 // VI
#define IEEE802_1D_VO_1 6 // VO
#define IEEE802_1D_VO_2 7 // NC (Highest)
// for sign that TID isn't available(not from the standard only for sw porpuse.)
#define IEEE802_1D_NA   8 

#define MANAGEMENT_TID	0xF // for 802.11ax only

#define NUM_OF_TID          8
#define NUMBER_OF_TIDS_PER_AC 2

//WMM Access Categories
typedef enum AccessCategory
{
	ACCESS_CATEGORY_BE = 0,
	ACCESS_CATEGORY_BK,
	ACCESS_CATEGORY_VI,
	ACCESS_CATEGORY_VO,
	ACCESS_CATEGORY_NUM,				/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
	ACCESS_CATEGORY_INAVLID = 0xFF,
} AccessCategory_e;

extern const uint8 au8Convert8021dToWmeUserPriority[NUM_802_1D_FRAME_PRIORITIES];

/***************************************************************************/
/***                              Types                                  ***/
/***************************************************************************/

#ifdef __ghs
#pragma pack(1)
#endif

/*
 * This type contains a Time Synchronisation Function value. It is a 64bit
 * unsigned number although the type is also used by the lower MAC to make
 * signed adjustments to the TSF.
 */



#define FM_CRC_SIZE 4
#define FM_DELIMITER_SIZE 4

/*
 * MAC Frame Header Optional. These structure show the different extra header information
 * that is used to specify all the different frame headerss
 */

#ifdef __ghs
#pragma pack()
#endif


typedef struct FrameControl
{
    uint16 protocolVersion :2;
    uint16 type            :2;
    uint16 subtype         :4;
    uint16 toDs            :1;
    uint16 fromDs          :1;
    uint16 moreFragments   :1;
	uint16 retry           :1;
    uint16 powerManagement :1;
    uint16 moreData        :1;
	uint16 protectedFrame  :1;
    uint16 orderOrHtc      :1;
} FrameControl_t;

typedef struct SequenceControl
{
    uint16 fragmentNumber  :4;
    uint16 sequenceNumber  :12;
} SequenceControl_t;

typedef struct QosControl
{
    uint16 tid       :4;
    uint16 eosp      :1;
	uint16 ackPolicy :2;
	uint16 isAmsdu   :1;
	uint16 reserved  :8;
} QosControl_t;

// note - this struct should have been pack(1), so keep it packed manually !!!
typedef struct FRAME_HDR_BASIC
{
    uint8          u8CRC[FM_CRC_SIZE];
} FRAME_HDR_BASIC;

// note - this struct should have been pack(1), so keep it packed manually !!!
typedef struct FRAME_HDR_ADDR4
{
    IEEE_ADDR      sIEEE_ADDRaddr4;
    uint8          u8CRC[FM_CRC_SIZE];
} FRAME_HDR_ADDR4;

// note - this struct should have been pack(1), so keep it packed manually !!!
typedef struct FRAME_HDR_QOS
{
    uint16	   u16QOScontrol;			// Can be casted to QosControl_t
    uint8          u8CRC[FM_CRC_SIZE];
} FRAME_HDR_QOS;

// note - this struct should have been pack(1), so keep it packed manually !!!
typedef struct FRAME_HDR_ADDR4_AND_QOS
{
    IEEE_ADDR      sIEEE_ADDRaddr4;
    uint16		   u16QOScontrol;		// Can be casted to QosControl_t
    uint8          u8CRC[FM_CRC_SIZE];
} FRAME_HDR_ADDR4_AND_QOS;


typedef struct FRAME_HDR_AGG
{
    void *pCnc;
    uint32 u32Delim; 
} FRAME_HDR_AGG;

// note - this struct should have been pack(1), so keep it packed manually !!!
typedef union FM_OPTIONAL_HDR
{
    FRAME_HDR_BASIC         sBasic;
    FRAME_HDR_ADDR4         sAddr4;
    FRAME_HDR_QOS           sQos;
    FRAME_HDR_ADDR4_AND_QOS sAddr4AndQos;
} FM_OPTIONAL_HDR;


/*
 * MAC Frame Header. This structure is used in the Lower MAC interface to
 * contain the MAC Frame Headers and is based on the 802.11 specification.
 */

// note - this struct should have been pack(1), so keep it packed manually !!!
typedef struct FRAME_HEADER
{
    uint16  		u16FrameControl;		// Can be casted to FrameControl_t
    uint16          u16Duration;
    IEEE_ADDR       sIEEE_ADDRaddr1;
    IEEE_ADDR       sIEEE_ADDRaddr2;
    IEEE_ADDR       sIEEE_ADDRaddr3;
    uint16          u16SequenceControl;
    FM_OPTIONAL_HDR sOptionHdr;
	FRAME_HDR_AGG   sAgg;	//used in aggregation only
} FRAME_HEADER;


/*
 * MAC Frame Header. This structure is used in the Lower MAC interface to
 * contain the MAC Frame Headers and is based on the 802.11 specification.
 */

// note - this struct should have been pack(1), so keep it packed manually !!!
typedef struct BA_FRAME_HEADER
{
    uint16          u16FrameControl;
    uint16          u16Duration;
    IEEE_ADDR       sIEEE_ADDRaddr1;
    IEEE_ADDR       sIEEE_ADDRaddr2;
} BA_FRAME_HEADER;

typedef struct BAR_FRAME_HEADER /*E.Z> -Bar control frame*/
{
	uint16          u16FrameControl;	// Can be casted to FrameControl_t
    uint16          u16Duration;
    IEEE_ADDR       sIEEE_ADDRaddr1;
    IEEE_ADDR       sIEEE_ADDRaddr2;
}BAR_FRAME_HEADER;

typedef struct CTS_FRAME_HEADER
{
	uint16          u16FrameControl;	// Can be casted to FrameControl_t
    uint16          u16Duration;
    IEEE_ADDR       sIEEE_ADDRaddr1;
}CTS_FRAME_HEADER;

typedef struct MANAGEMENT_BASIC_FRAME_HEADER 
{ 
    /* Management basic header does not include HT control */
	uint16          u16FrameControl;	// Can be casted to FrameControl_t
    uint16          u16Duration;
    IEEE_ADDR       sIEEE_ADDRaddr1;
    IEEE_ADDR       sIEEE_ADDRaddr2;
	IEEE_ADDR       sIEEE_ADDRaddr3;
    uint16          u16SequenceControl;
} MANAGEMENT_BASIC_FRAME_HEADER;


typedef struct NDPA_FRAME_HEADER
{
	uint16			u16FrameControl;	// Can be casted to FrameControl_t
	uint16			u16Duration;
	IEEE_ADDR		sIEEE_ADDRaddr1;
	IEEE_ADDR		sIEEE_ADDRaddr2;
}NDPA_FRAME_HEADER;


typedef struct TRIGGER_FRAME_HEADER
{
	uint16			u16FrameControl;	// Can be casted to FrameControl_t
	uint16			u16Duration;
	IEEE_ADDR		sIEEE_ADDRaddr1;
	IEEE_ADDR		sIEEE_ADDRaddr2;
}TRIGGER_FRAME_HEADER;


typedef struct AMSDU_FRAME_HEADER_
{
    IEEE_ADDR       sIEEE_ADDRaddr1;
    IEEE_ADDR       sIEEE_ADDRaddr2;
	uint16			length;
} AMSDU_FRAME_HEADER;

#ifdef __ghs
#pragma pack(1) // switch back to pack(1)
#endif

#define FM_STRUCT_OFFSET(struc,element)    (uint32)(&(((struc *)0)->element))

/* Bits in u16QOScontrol - see WME spec section 2.1.6 */
#define FM_PRI_MASK_8021D               0x0007
#define FM_ACK_POLICY_MASK              0x0060
#define FM_ACK_POLICY_ACK               0x0000
#define FM_ACK_POLICY_NORMAL_ACK        (0 << 5) /* <O.H> - NORMAL ACK POLICY (bit 5 equals 0)         */
#define FM_ACK_POLICY_NO_ACK            (1 << 5) /* <O.H> - NO ACK POLICY (bit 5 equals 1)             */
#define FM_ACK_POLICY_NO_EXPLICIT_ACK   (2 << 5) /* <O.H> - NO EXPLICIT ACK POLICY (bit 6 equals 1)    */
#define FM_ACK_POLICY_BLOCK_ACK         (3 << 5) /* <O.H> - NO EXPLICIT ACK POLICY (bit 5 & 6 equal 1) */

#define FM_QOS_EOSP_MASK              0x0010




/* Define the combined header and CRC size for a basic zero length packet */
#define FM_HEADER_SIZE                      FM_STRUCT_OFFSET(FRAME_HEADER,sOptionHdr.sBasic.u8CRC)
#define FM_HEADER_SIZE_QOS                  FM_STRUCT_OFFSET(FRAME_HEADER,sOptionHdr.sQos.u8CRC)
#define FM_HEADER_SIZE_ADDR4                FM_STRUCT_OFFSET(FRAME_HEADER,sOptionHdr.sAddr4.u8CRC)
#define FM_HEADER_SIZE_ADDR4_AND_QOS        FM_STRUCT_OFFSET(FRAME_HEADER,sOptionHdr.sAddr4AndQos.u8CRC)
#define FM_HEADER_SIZE_AGGR                 FM_STRUCT_OFFSET(FRAME_HEADER,sOptionHdr.sAgg.u32Delim) 

#define FM_MIN_PACKET_SIZE                  (FM_CRC_SIZE+FM_HEADER_SIZE)
#define FM_MIN_PACKET_SIZE_QOS              (FM_CRC_SIZE+FM_HEADER_SIZE_QOS)
#define FM_MIN_PACKET_SIZE_ADDR4            (FM_CRC_SIZE+FM_HEADER_SIZE_ADDR4)
#define FM_MIN_PACKET_SIZE_ADDR4_AND_QOS    (FM_CRC_SIZE+FM_HEADER_SIZE_ADDR4_AND_QOS)

#define FM_PAYLOAD_START_BASIC(y)           ((uint8 *)(&y.sOptionHdr.sBasic.u8CRC))
#define FM_PAYLOAD_START_QOS(y)             ((uint8 *)(&y.sOptionHdr.sQos.u8CRC))
#define FM_PAYLOAD_START_ADDR4(y)           ((uint8 *)(&y.sOptionHdr.sAddr4.u8CRC))
#define FM_PAYLOAD_START_ADDR4_AND_QOS(y)   ((uint8 *)(&y.sOptionHdr.sAddr4AndQos.u8CRC))

#ifdef __ghs
#pragma pack()
#endif

#endif /* !IEEE80211_INCLUDED */

