/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW - RSN 802.11i
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/sys/common/ieee_address.h $
 **
 ** DESCRIPTION:    Public interface to IEEE_ADDR class
 **
 ** AUTHOR:         Ross Hetherington
 **
 ** THIS VERSION:   $Revision: #1 $
 **   CHANGED ON:   $Date: 2003/10/27 $
 **           BY:   $Author: njk $
 **
 ****************************************************************************
 **
 ** Copyright (c) TTPCom Limited, 2003
 **
 ** Copyright (c) Metalink Ltd., 2006 - 2007
 **
 ****************************************************************************
 ****************************************************************************/

#ifndef __IEEE_ADDRESS_H
#define __IEEE_ADDRESS_H

#include "mhi_ieee_address.h"
#include "mhi_umi_propr.h"

extern const IEEE_ADDR sIEEEaddrHW_Broadcast;

bool boIEEE_ADDR_IsEqual(const IEEE_ADDR *, const IEEE_ADDR *);
bool boIEEE_ADDR_IsMatching(const IEEE_ADDR * psIEEEaddrAddress1,
	const IEEE_ADDR * psIEEEaddrAddress2,
	const IEEE_ADDR * psIEEEaddrAddrMask);
bool boIEEE_ADDR_IsBroadcast(const IEEE_ADDR *);
bool boIEEE_ADDR_IsVendorAddr(const IEEE_ADDR *, const IEEE_ADDR *);
void vIEEE_ADDR_CopyAddr( IEEE_ADDR* psIEEEaddrDst, const IEEE_ADDR* psIEEEaddrSrc );
void vIEEE_ADDR_CopyAddr_InReversedOrder( IEEE_ADDR* psIEEEaddrDst, const IEEE_ADDR* psIEEEaddrSrc );


#define boIEEE_ADDR_IsMulticast(psIEEEaddrDest) \
    (((psIEEEaddrDest) != NULL) && (((psIEEEaddrDest)->au8Addr[0] & IEEE_ADDR_GROUP) != 0))

#endif /* __IEEE_ADDRESS_H */
