/***********************************************************************************
 File:		Protocol_WmeDefinitions.c
 Module:		Protocol
 Purpose: 	Definitions of  802.11 wme parameters  
 Description:	Wme definitions according to standard
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Protocol_WmeDefinitions.h"
#include "ieee80211.h"
#include "ErrorHandler_Api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_802_11_PROTOCOL
#define LOG_LOCAL_FID 3

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/	
const AccessCategoryTo8021d_t AccessCategoryTo8021dConversionTable =
{
	IEEE802_1D_BE_1, IEEE802_1D_BE_2, /* ACCESS_CATEGORY_BE */
	IEEE802_1D_BK_1, IEEE802_1D_BK_2, /* ACCESS_CATEGORY_BK */
	IEEE802_1D_VI_1, IEEE802_1D_VI_2, /* ACCESS_CATEGORY_VI */
	IEEE802_1D_VO_1, IEEE802_1D_VO_2  /* ACCESS_CATEGORY_VO */
};	
	
/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
AccessCategoryTo8021d_t *Protocol_GetAccessCategoryTo8021dConversionTable(void)
{
	return (AccessCategoryTo8021d_t *)&AccessCategoryTo8021dConversionTable;
}


