/* CMSynergyVer %full_filespec: frame.c;3:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/common/frame.c $
 **
 ** DESCRIPTION:    Common operations on a frame
 **
 ** AUTHOR:         Ross Hetherington
 **
 ** THIS VERSION:   $Revision: #1 $
 **   CHANGED ON:   $Date: 2003/10/27 $
 **           BY:   $Author: njk $ 
 **
 ****************************************************************************
 **
 ** Copyright (c) 2003 TTPCom Limited
 **
 ****************************************************************************
 ****************************************************************************/
/***************************************************************************/
/***                     Include File Dependencies                       ***/
/***************************************************************************/
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "frame.h"
#include "loggerAPI.h"
 
#define LOG_LOCAL_GID GLOBAL_GID_802_11_PROTOCOL
#define LOG_LOCAL_FID 0


/***************************************************************************
**
** NAME         boFrameIsQosCtrlPresent
**
** PARAMETERS   pThis - this FRAME_HEADER
**
** RETURNS      True  if QoS Control is present
**              else False
**
** DESCRIPTION  Reads the MAC header Frame Control field to determine
**              if the optional QoS Control field is present
**
****************************************************************************/
bool boFRAME_IsQosCtrlPresent(FRAME_HEADER *pThis)
{
    return (bool)(((pThis->u16FrameControl & FM_CONTROL_SUBTYPE_QOS)>>7) && (FM_CONTROL_IS_DATA_FRAME(pThis->u16FrameControl) == TRUE));
}


/***************************************************************************
**
** NAME         frame_isHtControlPresent
**
** PARAMETERS   MANAGEMENT_BASIC_FRAME_HEADER* pManagementFrameHeader
**
** RETURNS      True if HT Control is present
**              else False
**
** DESCRIPTION  Checks if HT control is present
**
****************************************************************************/
bool frame_isHtControlPresent(MANAGEMENT_BASIC_FRAME_HEADER* pManagementFrame)
{
    FrameControl_t* pFrameControl = NULL;

    pFrameControl = (FrameControl_t *)&pManagementFrame->u16FrameControl;
    if (pFrameControl->orderOrHtc == TRUE) // HT control is present
    {
        return TRUE;
    }
    else // HT control is not present
    {
        return FALSE;
    }
}


/***************************************************************************
**
** NAME         frame_getPayloadPointerFromExistingManagementFrame
**
** PARAMETERS   MANAGEMENT_BASIC_FRAME_HEADER* pManagmentFrame
**
** RETURNS      Pointer To Management Frame Payload
**
** DESCRIPTION  Returns pointer to payload according to management frame header size
**
****************************************************************************/
void* frame_getPayloadPointerFromExistingManagementFrame(MANAGEMENT_BASIC_FRAME_HEADER* pManagmentFrame)
{
    void* pFramePayload = NULL;
    
    pFramePayload = pManagmentFrame;
    pFramePayload = (uint8 *)pFramePayload + frame_sizeOfExistingManagementFrameHeader(pManagmentFrame);
    return pFramePayload;
}


/***************************************************************************
**
** NAME         frame_getPayloadPointerForNewManagementFrame
**
** PARAMETERS   MANAGEMENT_BASIC_FRAME_HEADER* pManagmentFrame, bool isHtcPresent
**
** RETURNS      Pointer To Management Frame Payload
**
** DESCRIPTION  Returns pointer to payload according to needed when building management frame
**
****************************************************************************/
void* frame_getPayloadPointerForNewManagementFrame(MANAGEMENT_BASIC_FRAME_HEADER* pManagmentFrame, bool isHtcPresent)
{   /* For management frame header with HT control field present - call the function with isHtcPresent = TRUE, else isHtcPresent = FALSE */
    void* pFramePayload = NULL;
    
    pFramePayload = pManagmentFrame;
    pFramePayload = (uint8 *)pFramePayload + frame_sizeOfNewManagementFrameHeader(isHtcPresent);
    return pFramePayload;
}


/***************************************************************************
**
** NAME         frame_sizeOfExistingManagementFrameHeader
**
** PARAMETERS   MANAGEMENT_BASIC_FRAME_HEADER* pManagementFrameHeader
**
** RETURNS      size of Management Frame Header
**
** DESCRIPTION  Checks if HT control is present and returns the size of Management Frame Header accordingly
**
****************************************************************************/
uint32 frame_sizeOfExistingManagementFrameHeader(MANAGEMENT_BASIC_FRAME_HEADER* pManagementFrame)
{
    if (frame_isHtControlPresent(pManagementFrame))
    {
        return (sizeof(MANAGEMENT_BASIC_FRAME_HEADER) + HT_CONTROL_SIZE);
    }
    else
    {
        return sizeof(MANAGEMENT_BASIC_FRAME_HEADER);
    }
}

/***************************************************************************
**
** NAME         frame_sizeOfNewManagementFrameHeader
**
** PARAMETERS   bool isHtcPresent
**
** RETURNS      size of Management Frame Header
**
** DESCRIPTION  Returns the size of Management Frame Header according to needed when building management frame
**
****************************************************************************/
uint32 frame_sizeOfNewManagementFrameHeader(bool isHtcPresent)
{   /* For management frame header with HT control field present - call the function with isHtcPresent = TRUE, else isHtcPresent = FALSE */
    if (isHtcPresent)
    {
        return (sizeof(MANAGEMENT_BASIC_FRAME_HEADER) + HT_CONTROL_SIZE);
    }
    else
    {
        return sizeof(MANAGEMENT_BASIC_FRAME_HEADER);
    }
}

