/* CMSynergyVer %full_filespec: ieee_address.c;2:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW - RSN 802.11i
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/common/ieee_address.c $
 **
 ** DESCRIPTION:    IEEE_ADDR class implementation
 **
 ** AUTHOR:         Ross Hetherington
 **
 ** THIS VERSION:   $Revision: #1 $
 **   CHANGED ON:   $Date: 2003/10/27 $
 **           BY:   $Author: njk $
 **
 ****************************************************************************
 **
 ** Copyright (c) 2003 TTPCom Limited
 **
 ****************************************************************************
 ****************************************************************************/

/***************************************************************************/
/***                     Include File Dependencies                       ***/
/***************************************************************************/
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "ieee_address.h"

#include "loggerAPI.h"

#define LOG_LOCAL_GID GLOBAL_GID_802_11_PROTOCOL
#define LOG_LOCAL_FID 1

const IEEE_ADDR sIEEEaddrHW_Broadcast = { {0xff, 0xff, 0xff, 0xff, 0xff, 0xff} };

/****************************************************************************
**
** NAME:            boIEEE_ADDR_IsEqual
**
** PARAMETERS                       r/w  usage
**             psIEEEaddrAddress1   *r   Comparand 1
**             psIEEEaddrAddress2   *r   Comparand 2
**
** RETURN VALUES:   bool             Addresses are Equal
**
** DESCRIPTION:     Returns true if the two addresses are equal
****************************************************************************/
bool boIEEE_ADDR_IsEqual(const IEEE_ADDR * psIEEEaddrAddress1,
                         const IEEE_ADDR * psIEEEaddrAddress2)
{
    /* returns FALSE if null pointers */
    return (bool)
        (psIEEEaddrAddress1 != NULL) &&
        (psIEEEaddrAddress2 != NULL) &&
        (psIEEEaddrAddress1->au8Addr[0] == psIEEEaddrAddress2->au8Addr[0]) &&
        (psIEEEaddrAddress1->au8Addr[1] == psIEEEaddrAddress2->au8Addr[1]) &&
        (psIEEEaddrAddress1->au8Addr[2] == psIEEEaddrAddress2->au8Addr[2]) &&
        (psIEEEaddrAddress1->au8Addr[3] == psIEEEaddrAddress2->au8Addr[3]) &&
        (psIEEEaddrAddress1->au8Addr[4] == psIEEEaddrAddress2->au8Addr[4]) &&
        (psIEEEaddrAddress1->au8Addr[5] == psIEEEaddrAddress2->au8Addr[5]);
}

/****************************************************************************
**
** NAME:            boIEEE_ADDR_IsMatching
**
** PARAMETERS                       r/w  usage
**             psIEEEaddrAddress1   *r   Comparand 1
**             psIEEEaddrAddress2   *r   Comparand 2
**             psIEEEaddrAddrMask   *r   The bitmask
**
** RETURN VALUES:   bool             Addresses are matching according to mask
**
** DESCRIPTION:     Returns true if the two addresses are equal in the part
**                  indicated by the bitmask
****************************************************************************/
bool boIEEE_ADDR_IsMatching(const IEEE_ADDR * psIEEEaddrAddress1,
	const IEEE_ADDR * psIEEEaddrAddress2,
	const IEEE_ADDR * psIEEEaddrAddrMask)
{
	/* returns FALSE if null pointers */
	return (bool)
		(psIEEEaddrAddress1 != NULL) &&
		(psIEEEaddrAddress2 != NULL) &&
		(psIEEEaddrAddrMask != NULL) &&
		((psIEEEaddrAddress1->au8Addr[5] & psIEEEaddrAddrMask->au8Addr[5]) ==
		(psIEEEaddrAddress2->au8Addr[5] & psIEEEaddrAddrMask->au8Addr[5])) &&
		((psIEEEaddrAddress1->au8Addr[4] & psIEEEaddrAddrMask->au8Addr[4]) ==
		(psIEEEaddrAddress2->au8Addr[4] & psIEEEaddrAddrMask->au8Addr[4])) &&
		((psIEEEaddrAddress1->au8Addr[3] & psIEEEaddrAddrMask->au8Addr[3]) ==
		(psIEEEaddrAddress2->au8Addr[3] & psIEEEaddrAddrMask->au8Addr[3])) &&
		((psIEEEaddrAddress1->au8Addr[2] & psIEEEaddrAddrMask->au8Addr[2]) ==
		(psIEEEaddrAddress2->au8Addr[2] & psIEEEaddrAddrMask->au8Addr[2])) &&
		((psIEEEaddrAddress1->au8Addr[1] & psIEEEaddrAddrMask->au8Addr[1]) ==
		(psIEEEaddrAddress2->au8Addr[1] & psIEEEaddrAddrMask->au8Addr[1])) &&
		((psIEEEaddrAddress1->au8Addr[0] & psIEEEaddrAddrMask->au8Addr[0]) ==
		(psIEEEaddrAddress2->au8Addr[0] & psIEEEaddrAddrMask->au8Addr[0]));
}

/****************************************************************************
**
** NAME:            boIEEE_ADDR_IsBroadcast
**
** PARAMETERS                   r/w  usage
**             psIEEEaddrDest   *r   Destination address
**
** RETURN VALUES:   bool             Address is broadcast address
**
** DESCRIPTION:     Returns true if the specified address is a broadcast address.
****************************************************************************/
bool boIEEE_ADDR_IsBroadcast(const IEEE_ADDR * psIEEEaddrDest)
{
    uint16 * pu16Addr = (uint16 *) psIEEEaddrDest->au8Addr;

    DEBUG_ASSERT (((uint32)psIEEEaddrDest & 1) == 0);

    return (bool)
        (pu16Addr[0] == 0xffff) &&
        (pu16Addr[1] == 0xffff) &&
        (pu16Addr[2] == 0xffff);

}

/****************************************************************************
**
** NAME:            boIEEE_ADDR_CopyAddr
**
** PARAMETERS       psIEEEaddrDst - Destination IEEE_ADDR structure (copy to)
**             		psIEEEaddrSrc - Source IEEE_ADDR structure (copy from)
**
** RETURN VALUES:   None.
**
** DESCRIPTION:     Copy source IEEE_ADDR structure to given destination 
**					IEEE_ADDR structure.
**
****************************************************************************/
void vIEEE_ADDR_CopyAddr( IEEE_ADDR* psIEEEaddrDst, const IEEE_ADDR* psIEEEaddrSrc )
{
	DEBUG_ASSERT( psIEEEaddrDst );
	DEBUG_ASSERT( psIEEEaddrSrc );
	
    psIEEEaddrDst->au8Addr[ 0 ] = psIEEEaddrSrc->au8Addr[ 0 ];
	psIEEEaddrDst->au8Addr[ 1 ] = psIEEEaddrSrc->au8Addr[ 1 ];
	psIEEEaddrDst->au8Addr[ 2 ] = psIEEEaddrSrc->au8Addr[ 2 ];
	psIEEEaddrDst->au8Addr[ 3 ] = psIEEEaddrSrc->au8Addr[ 3 ];
	psIEEEaddrDst->au8Addr[ 4 ] = psIEEEaddrSrc->au8Addr[ 4 ];
	psIEEEaddrDst->au8Addr[ 5 ] = psIEEEaddrSrc->au8Addr[ 5 ];
}

/****************************************************************************
**
** NAME:            boIEEE_ADDR_CopyAddr
**
** PARAMETERS       psIEEEaddrDst - Destination IEEE_ADDR structure (copy to)
**             		psIEEEaddrSrc - Source IEEE_ADDR structure (copy from)
**
** RETURN VALUES:   None.
**
** DESCRIPTION:     Copy source IEEE_ADDR structure to given destination 
**					IEEE_ADDR structure.
**
****************************************************************************/
void vIEEE_ADDR_CopyAddr_InReversedOrder( IEEE_ADDR* psIEEEaddrDst, const IEEE_ADDR* psIEEEaddrSrc )
{
	DEBUG_ASSERT( psIEEEaddrDst ); 
	DEBUG_ASSERT( psIEEEaddrSrc );
	
    psIEEEaddrDst->au8Addr[ 5 ] = psIEEEaddrSrc->au8Addr[ 5 ];
	psIEEEaddrDst->au8Addr[ 4 ] = psIEEEaddrSrc->au8Addr[ 4 ];
	psIEEEaddrDst->au8Addr[ 3 ] = psIEEEaddrSrc->au8Addr[ 3 ];
	psIEEEaddrDst->au8Addr[ 2 ] = psIEEEaddrSrc->au8Addr[ 2 ];
	psIEEEaddrDst->au8Addr[ 1 ] = psIEEEaddrSrc->au8Addr[ 1 ];
	psIEEEaddrDst->au8Addr[ 0 ] = psIEEEaddrSrc->au8Addr[ 0 ];
}



/****************************************************************************
**
** NAME:            boIEEE_ADDR_IsVendorAddr
**
** PARAMETERS:                      
**             psIEEEaddrAddress1   *r   Comparand 1
**             psIEEEaddrAddress2   *r   Comparand 2
**
** RETURN VALUES:   bool             Address belongs to vendor address range
**
** DESCRIPTION:     Returns true address belongs to vendor address range
****************************************************************************/
bool boIEEE_ADDR_IsVendorAddr(const IEEE_ADDR * psIEEEaddrAddress1,
	const IEEE_ADDR * psIEEEaddrAddress2)
{
	/* returns FALSE if null pointers */
	return (bool)
		(psIEEEaddrAddress1 != NULL) &&
		(psIEEEaddrAddress2 != NULL) &&
		(psIEEEaddrAddress1->au8Addr[0] == psIEEEaddrAddress2->au8Addr[0]) &&
		(psIEEEaddrAddress1->au8Addr[1] == psIEEEaddrAddress2->au8Addr[1]) &&
		(psIEEEaddrAddress1->au8Addr[2] == psIEEEaddrAddress2->au8Addr[2]);
}


