/***********************************************************************************
 File:			Ager_Api.h
 Module:		Ager 
 Purpose: 		discard old PDs and discard	PDs from specific priorities 
 				(on single check mode)
 Description:   This file contains the API of the Ager module which is responsible 
 				to discard old PDs and discard PDs from specific priorities 
 				(on single check mode)
************************************************************************************/
#ifndef AGER_API_H_
#define AGER_API_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ieee80211.h"


/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data type definitions					
/----------------------------------------------------------------------------------*/
typedef struct AgerGeneralParameters
{
	uint8 acTtlCriteria[ACCESS_CATEGORY_NUM];
	uint16 minimumPdsToStartCheckForAc[ACCESS_CATEGORY_NUM];
} AgerGeneralParameters_t;

typedef struct AgerPeriodicCheckParameters
{
	AgerGeneralParameters_t generalParameters;
	
	uint8 agerPeriod;
	uint8 reserved[3];
} AgerPeriodicCheckParameters_t;


#if !defined (ENET_INC_ARCH_WAVE600)

typedef struct AgerSingleCheckParameters
{
	AgerGeneralParameters_t generalParameters;

	uint16 maximumPdsToDiscard;
	uint8 isStartingFromVap;
	uint8 isEnabledMaximumLimit;
	
	uint8 stationOrVapIndexToStart;
	uint8 forceLock;
    uint8 reserved[2];
} AgerSingleCheckParameters_t;


/* This structure needs to be alligned to words */
typedef struct AgerLastCheckParametes
{
	uint8 index;
	uint8 isVapQueue;
	uint8 tid;
    uint8 isSingleCheckDone;
} AgerLastCheckParametes_t;

/* This structure needs to be alligned to words */
typedef struct AgerLastCheckCounters
{
	uint16 numberOfPdsHandledToUmac;
	uint16 numberOfPdsHandledToLiberator;

	uint16 numberOfLockFailures;
	uint16 reserved;
} AgerLastCheckCounters_t;

#endif

#if defined (ENET_INC_ARCH_WAVE600)

typedef struct AgerSingleCheckParameters
{
	AgerGeneralParameters_t generalParameters;

	uint32 maximumPdsToDiscard;

	uint16 stationOrVapIndexToStart;
	uint8 isStartingFromVap;
	uint8 isEnabledMaximumLimit;

	uint8 forceLock;
	uint8 reserved[3];
} AgerSingleCheckParameters_t;


/* This structure needs to be alligned to words */
typedef struct AgerLastCheckParametes
{
	uint16 isVapQueue;
	uint16 index;
	uint8 tid;
    uint8 isSingleCheckDone;
	uint8 reserved[2];
} AgerLastCheckParametes_t;

/* This structure needs to be alligned to words */
typedef struct AgerLastCheckCounters
{
	uint32 numberOfPdsHandledToUmac; // holds up to 17 bits
	uint32 numberOfPdsHandledToLiberator; // holds up to 17 bits

	uint16 numberOfLockFailures; // max size up to 9 bits
	uint16 reserved;
} AgerLastCheckCounters_t;

#endif




/*---------------------------------------------------------------------------------
/						Public functions declarations			
/----------------------------------------------------------------------------------*/
void Ager_ConfigureAllAndActivatePeriodicCheck(AgerPeriodicCheckParameters_t  *agerCheckParameters);
void Ager_ReconfigurePartialPeriodicCheck(AgerPeriodicCheckParameters_t  *agerCheckParameters);
void Ager_StopPeriodicCheck(void); 
void Ager_StartSingleCheck(AgerSingleCheckParameters_t  *agerCheckParameters, bool restrictedAc); 
void Ager_StopPeriodicCheckAndStartSingleCheck(AgerSingleCheckParameters_t  *agerCheckParameters, bool restrictedAc);
void Ager_GetLastCheckParameters(AgerLastCheckParametes_t *lastCheckParameters);
#if defined (ENET_INC_ARCH_WAVE600)
void Ager_InitializeRam(void);
#endif
void Ager_GetLastCheckCounters(AgerLastCheckCounters_t *lastCheckCounters);
void Ager_Initialize(void);



#endif /* AGER_API_H_ */

