/***********************************************************************************
 File:			Ager.c
 Module:		Ager 
 Purpose: 		discard old PDs and discard	PDs from specific priorities 
 				(on single check mode)
 Description:   This file is the implementation of the Ager module which is 
 			    the interface to the HW Ager and the Ager emulator.
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"	
#include "Ager_Api.h"
#include "AgerEmulator.h"
#include "HwQManager_API.h" 
#include "ErrorHandler_Api.h"
#include "loggroups.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_AGER_EMULATOR
#define LOG_LOCAL_FID 0
	


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

Ager_ConfigureAllAndActivatePeriodicCheck 


Description:
------------
Configure all parameters and activate periodic check

Input:
-----
agerCheckParameters- a pointer to the structure that contains all the periodic check 
parameters


Output:
-------
	

Returns:
--------
	 
	
**********************************************************************************/
void Ager_ConfigureAllAndActivatePeriodicCheck(AgerPeriodicCheckParameters_t  *agerCheckParameters)
{
#ifdef USE_AGER_EMULATOR
	AgerEmulator_ConfigureAllAndActivatePeriodicCheck(agerCheckParameters);
#else		
	HwQManagerAger_ConfigureAllAndActivatePeriodicCheck(agerCheckParameters);
#endif //USE_AGER_EMULATOR
}

/**********************************************************************************

Ager_ReconfigurePartialPeriodicCheck 


Description:
------------
Reconfigure only the TTL criteria and the ager period and then activate the Ager 
periodic check

Input:
-----
agerCheckParameters- a pointer to the structure that contains all the periodic check 
parameters


Output:
-------
	

Returns:
--------
	
	
**********************************************************************************/
void Ager_ReconfigurePartialPeriodicCheck(AgerPeriodicCheckParameters_t  *agerCheckParameters)
{
#ifdef USE_AGER_EMULATOR
	AgerEmulator_ReconfigurePartialPeriodicCheck(agerCheckParameters);//the periodic check should be tested in various scenarios before being enabled 
#else		
	HwQManagerAger_ReconfigurePartialPeriodicCheck(agerCheckParameters);
#endif //USE_AGER_EMULATOR
}



/**********************************************************************************

Ager_StopPeriodicCheck 


Description:
------------
Stops Ager periodic check

Input:
-----


Output:
-------
	

Returns:
--------
	
	
**********************************************************************************/
void Ager_StopPeriodicCheck(void)
{
#ifdef USE_AGER_EMULATOR
	AgerEmulator_StopPeriodicCheck();
#else		
	HwQManagerAger_StopPeriodicCheck();
#endif //USE_AGER_EMULATOR
}


/**********************************************************************************

Ager_StartSingleCheck 


Description:
------------
Activates Ager single check

Input:
-----
agerCheckParameters- a pointer to the structure that contains all the single check 
parameters


Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void Ager_StartSingleCheck(AgerSingleCheckParameters_t  *agerCheckParameters, bool restrictedAc)
{
#ifdef USE_AGER_EMULATOR
	AgerEmulator_StartSingleCheck(agerCheckParameters, restrictedAc);
	AgerEmulator_IncreasePriority();
#else		
	HwQManagerAger_StartSingleCheck(agerCheckParameters, restrictedAc);
#endif //USE_AGER_EMULATOR
}

/**********************************************************************************

Ager_StopPeriodicCheckAndStartSingleCheck 


Description:
------------
Stops the periodic check and then activates the Ager single check 

Input:
-----
agerCheckParameters- a pointer to the structure that contains all the single check 
parameters


Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void Ager_StopPeriodicCheckAndStartSingleCheck(AgerSingleCheckParameters_t  *agerCheckParameters, bool restrictedAc)
{
#ifdef USE_AGER_EMULATOR
	/* In the Ager emulator when activating the single check it stops first the periodic check */
	AgerEmulator_StartSingleCheck(agerCheckParameters, restrictedAc);
	AgerEmulator_IncreasePriority();
#else		
	HwQManagerAger_StopPeriodicCheckAndStartSingleCheck(agerCheckParameters, restrictedAc);
#endif //USE_AGER_EMULATOR
}


/**********************************************************************************

Ager_GetLastCheckParameters 


Description:
------------
Returns the parameters of the last Ager emulator check

Input:
-----
lastCheckParameters - pointer to the strcutre to fill


Output:
-------
The structure contains the needed parameters	

Returns:
--------
	
	
**********************************************************************************/
void Ager_GetLastCheckParameters(AgerLastCheckParametes_t *lastCheckParameters)
{
#ifdef USE_AGER_EMULATOR
	AgerEmulator_GetLastCheckParameters(lastCheckParameters);
#else		
	HwQManagerAger_GetLastCheckParameters(lastCheckParameters);
#endif //USE_AGER_EMULATOR
}


/**********************************************************************************

Ager_GetLastCheckCounters 


Description:
------------
Returns the counters of the last Ager emulator check


Input:
-----
lastCheckCounters - pointer to the strcutre to fill


Output:
-------
The structure contains the counters	

Returns:
--------

	
**********************************************************************************/
void Ager_GetLastCheckCounters(AgerLastCheckCounters_t *lastCheckCounters)
{
#ifdef USE_AGER_EMULATOR
	AgerEmulator_GetLastCheckCounters(lastCheckCounters);
#else		
	HwQManagerAger_GetLastCheckCounters(lastCheckCounters);
#endif //USE_AGER_EMULATOR
}

/**********************************************************************************

Ager_InitializeRam 


Description:
------------
Initialize the Ager

Input:
-----


Output:
-------
	

Returns:
--------
	
	
**********************************************************************************/
#if defined (ENET_INC_ARCH_WAVE600)


void Ager_InitializeRam(void)
{
	uint16 i=0;
	for (i =0; i < (HW_NUM_OF_STATIONS + HW_NUM_OF_VAPS); i++)
	{

		HwQManagerAger_SetStaTtlVal(i,0x0);
	}	
}
#endif
/**********************************************************************************

Ager_Initialize 


Description:
------------
Initialize the Ager

Input:
-----


Output:
-------
	

Returns:
--------
	
	
**********************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

void Ager_Initialize()
{
#ifdef USE_AGER_EMULATOR
	AgerEmulator_Initialize();
#else		
	HwQManagerAger_Initialize();
#if defined (ENET_INC_ARCH_WAVE600)
	Ager_InitializeRam();
#endif

#endif //USE_AGER_EMULATOR
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif


