/***************************************************************
 File:		AggregationBuilder_Api.h
 Module:	  	Aggregation builder
 Purpose: 	configures the aggregation builder module in the PAC 
 Description:  This file is the API to the aggregation builder module which is responsible for creating
 			the next transmission
***************************************************************/
#ifndef AGGREGATION_BUILDER_API_H_
#define AGGREGATION_BUILDER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "Std.h"
#include "StaDb.h"
#include "mhi_umi_propr.h"
#include "PacketDescriptor.h"
#include "InterruptManager_Api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
typedef enum
{
	AGGR_BUILDER_FORCE_PROTECTION_MODE_RTS = 0,
	AGGR_BUILDER_FORCE_PROTECTION_MODE_CTS2SELF,
} AggrBuilderForceProtectionMode_e;

typedef enum
{
	AGGR_BUILDER_11B_OVERRIDE_PREAMBLE_ENABLED = 0,
	AGGR_BUILDER_11B_OVERRIDE_PREAMBLE_DISABLED,
} AggrBuilder11BOverridePreamble_e;

typedef enum
{
	 AGGR_BUILDER_11B_PREAMBLE_MODE_SHORT= 0,
	 AGGR_BUILDER_11B_PREAMBLE_MODE_LONG,
} AggrBuilder11BPreambleMode_e;



#define AGGR_BUILDER_MAX_DURATION_THRESHOLD_CONFIGURATION	31

#define AGGREGATION_BUILDER_TXOP_AIR_TIME_DURATION_LIMIT	((0x1 << 15) - 1) //32ms (max duration limit)


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct _AggBuilderRecoverFromError_t
{
	TxPd_t* 	headPd;
	uint8		stationIndex[4];
	uint8		tid[4];
	uint16		isMu		:1;	// SU/MU selection, 1 - MU, 0 - SU
	uint16		muGrpEntry	:7;	// MU Group entry index
	uint16		uspLock		:4;	// USP lock
	uint16		muGroupLock :1;	// MU group lock
	uint16		primaryUsp	:2;
	uint16		reserved	:1;	
} AggBuilderRecoverFromError_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

void AggregationBuilder_SetForceProtection(uint32 vapIndex ,AggrBuilderForceProtectionMode_e forceProtectionMode, uint32 forceProtectionOnOff);
void AggregationBuilder_Set11BPreambleOverride(uint32 enable11bPreambleOverride, uint32 mcs0Replacment);
void AggregationBuilder_Set11bPreambleMode(uint32 vapIndex, AggrBuilder11BPreambleMode_e preambleMode);
void AggregationBuilder_Get11BPreambleOverrideMode(uint32 vapIndex, bool* isOvverideEnabled, AggrBuilder11BPreambleMode_e* preambleMode);
void AggregationBuilder_SetDurationRatioThreshold (uint8 newThreshold);
void AggregationBuilder_SetMuBfTrainingBwLimit(Bandwidth_e newLimit);
#if defined(ENET_INC_LMAC)
void AggregationBuilder_FillConfigurationDb(uint32 vapIndex,uint32 protectionRate, uint32 protectionPhyMode, uint32 fillerRate ,uint32 fillerPhyMode);
void AggregationBuilder_Halt(void);
#endif
void AggregationBuilder_Initialize (void);
ISR_VOID isr_AggregationBuilder_ErrorOrDone (void);

#endif /* AGGREGATION_BUILDER_API_H_ */


