/***************************************************************
 File:		AggregationBuilderi.h
 Module:	  	Aggregation builder
 Purpose: 	holds the definions for the aggregation builder module 
 Description:  This file contains the definions of the aggregation builder module which 
 			is responsible for creating the next transmission
***************************************************************/
#ifndef AGGREGATION_BUILDER_H_
#define AGGREGATION_BUILDER_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define AGGREGATION_BUILDER_INTERRUPT_MSDU_CONUTER_ERROR           0x00000001
#define AGGREGATION_BUILDER_INTERRUPT_MSDU_SIZE_ERROR              0x00000002
#define AGGREGATION_BUILDER_INTERRUPT_MPDU_SIZE_ERROR              0x00000004
#define AGGREGATION_BUILDER_INTERRUPT_PSDU_SIZE_ERROR              0x00000008
#define AGGREGATION_BUILDER_INTERRUPT_PSDU_SIZE_ESTIMATED_ERROR    0x00000010
#define AGGREGATION_BUILDER_INTERRUPT_RETRIES_ERROR                0x00000020
#define AGGREGATION_BUILDER_INTERRUPT_START_OPERATION_INTERRUPT    0x00000040
#define AGGREGATION_BUILDER_INTERRUPT_DONE_OPERATION_INTERRUPT     0x00000080
#define AGGREGATION_BUILDER_INTERRUPT_TIMER_ERROR                  0x00000100
#define AGGREGATION_BUILDER_INTERRUPT_OWNER_BIT_ERROR              0x00000200
#define AGGREGATION_BUILDER_INTERRUPT_TXHD_START_DURING_OPERATION  0x00000400
#define AGGREGATION_BUILDER_INTERRUPT_CPU_START_DURING_OPERATION   0x00000800
#define AGGREGATION_BUILDER_INTERRUPT_GENRISC_FORBIDDEN_ACCESS     0x00001000
#define AGGREGATION_BUILDER_INTERRUPT_PD_READ_COUNT_MINIMUM_LIMIT  0x00002000
#define AGGREGATION_BUILDER_INTERRUPT_TX_SEL_BITMAP				   0x00004000
#define AGGREGATION_BUILDER_INTERRUPT_FIRST_PD_NULL			       0x00008000



#define AGGREGATION_BUILDER_FULL_RESET_MASK (REG_SW_RESET_AGG_BUILDER_REG_MASK |REG_SW_RESET_AGG_BUILDER_MASK)

#define AGGREGATION_BUILDER_ALL_INTERRUPTS (AGGREGATION_BUILDER_INTERRUPT_MSDU_CONUTER_ERROR          | \
											AGGREGATION_BUILDER_INTERRUPT_MSDU_SIZE_ERROR             | \
											AGGREGATION_BUILDER_INTERRUPT_MPDU_SIZE_ERROR             | \
											AGGREGATION_BUILDER_INTERRUPT_PSDU_SIZE_ERROR             | \
											AGGREGATION_BUILDER_INTERRUPT_PSDU_SIZE_ESTIMATED_ERROR   | \
											AGGREGATION_BUILDER_INTERRUPT_RETRIES_ERROR               | \
											AGGREGATION_BUILDER_INTERRUPT_START_OPERATION_INTERRUPT   | \
											AGGREGATION_BUILDER_INTERRUPT_DONE_OPERATION_INTERRUPT    | \
											AGGREGATION_BUILDER_INTERRUPT_TIMER_ERROR                 | \
											AGGREGATION_BUILDER_INTERRUPT_OWNER_BIT_ERROR             | \
											AGGREGATION_BUILDER_INTERRUPT_TXHD_START_DURING_OPERATION | \
											AGGREGATION_BUILDER_INTERRUPT_CPU_START_DURING_OPERATION  | \
											AGGREGATION_BUILDER_INTERRUPT_GENRISC_FORBIDDEN_ACCESS    | \
											AGGREGATION_BUILDER_INTERRUPT_PD_READ_COUNT_MINIMUM_LIMIT | \
											AGGREGATION_BUILDER_INTERRUPT_TX_SEL_BITMAP				  | \
											AGGREGATION_BUILDER_INTERRUPT_FIRST_PD_NULL)			
											
											




#define AGGREGATION_BUILDER_CLEAR_INTERRUPT 1 
#define AGGREGATION_BUILDER_START_TRIGGER   1

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------




#endif /*AGGREGATION_BUILDER_H_ */

