/***********************************************************************************
 File:		AggregationBuilderRam.h
 Module:		Aggregation Builder
 Purpose: 	Owner for all access to the Rx Classifier
 Description:	Rx Classifier Ram Description
************************************************************************************/
#ifndef _AGGREGATION_BUILDER_RAM_H_
#define _AGGREGATION_BUILDER_RAM_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "lmi.h"


/*---------------------------------------------------------------------------------
/								Defines						
/----------------------------------------------------------------------------------*/
#define AGGREGATIONBUILDER_RAM_ADDR_OFFSET 							(0x800)

#define DURATION_RATION_11B_MCS_0_SHIFT 	(0)
#define DURATION_RATION_11B_MCS_1_SHIFT		(5)
#define DURATION_RATION_11B_MCS_2_SHIFT		(10)
#define DURATION_RATION_11B_MCS_3_SHIFT		(15)

#define DURATION_RATION_11_A_G_20_MHZ_SHIFT	(0)
#define DURATION_RATION_11_A_G_40_MHZ_SHIFT	(5)
#define DURATION_RATION_11_A_G_80_MHZ_SHIFT (10)

#define DURATION_RATION_11_N_AC_NSS_1_SHIFT	(0)
#define DURATION_RATION_11_N_AC_NSS_2_SHIFT	(5)
#define DURATION_RATION_11_N_AC_NSS_3_SHIFT	(10)
#define DURATION_RATION_11_N_AC_NSS_4_SHIFT	(15)

/*---------------------------------------------------------------------------------
/							Data Type Definition												
/----------------------------------------------------------------------------------*/
typedef union
{
	uint32 val;
	struct
	{
		uint32 mcs0:5;
		uint32 mcs1:5;
		uint32 mcs2:5;
		uint32 mcs3:5;
		uint32 reserved:12;
	} bitFields;
} RamAggregationBuilder11BDurationRatio_t;


typedef union
{
	uint32 val;
	struct
	{
		uint32 bw20Mhz:5;
		uint32 bw40Mhz:5;
		uint32 bw80Mhz:5;
		uint32 reserved:17;
	} bitFields;
} RamAggregationBuilder11AGDurationRatio_t;

typedef union
{
	uint32 val;
	struct
	{
		uint32 Nss1:5;
		uint32 Nss2:5;
		uint32 Nss3:5;
		uint32 Nss4:5;
		uint32 reserved:12;
	} bitFields;
} RamAggregationBuilder11NAcDurationRatio_t;

typedef struct AggregationBuilderRam
{
	RamAggregationBuilder11BDurationRatio_t		durationRatio11B;
	RamAggregationBuilder11AGDurationRatio_t	durationRatio11AG[LM_PHY_11A_MAX_RATES];
	RamAggregationBuilder11NAcDurationRatio_t 	durationRatio11NAcN20Mhz[PROTOCOL_11_AC_NUM_OF_MCS];
	RamAggregationBuilder11NAcDurationRatio_t 	durationRatio11NAcN40Mhz[PROTOCOL_11_AC_NUM_OF_MCS];
	RamAggregationBuilder11NAcDurationRatio_t 	durationRatio11NAcN80Mhz[PROTOCOL_11_AC_NUM_OF_MCS];
	
} AggregationBuilderRam_t;

#endif /*_AGGREGATION_BUILDER_RAM_H_*/

