/***************************************************************
 File:		AggregationBuilder.c
 Module:	  	Aggregation builder
 Purpose: 	holds all the implementation of the aggregation builder API functions
 Description:  This module contains the implementation of the functions of the aggregation builder module 
 			which is responsible for creating the next transmission 
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "stringLibApi.h"
#include "AggregationBuilder_Api.h"
#include "AggregationBuilder.h"
#include "AggBuilderRegs.h"
#include "MacRabRegs.h"
#include "AggrDb.h"
#include "ShramAggrBuilderDb.h"
#include "AggregationBuilderRam.h"
#include "HwDrivers_Api.h"
#include "ErrorHandler_Api.h"
#include "ShramStd.h"
#include "ShramPacketDescriptors.h"
#include "Pac_Api.h"
#include "lm.h"
#include "enet_pas.h"
#include "RegAccess_Api.h"
#include "Protocol_AirTimeAndDuration.h"
#include "SharedDbTypes.h"
#include "ShramGroupDatabase.h"
#include "loggerAPI.h"
#include "HwQManager_API.h"
#include "PacketDescriptor.h"
#include "shram_man_queues.h"
#include "int_gen.h"
#include "linkAdaptation_api.h"
#include "CpuLoad_Api.h"



/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_TX_HW_ACCELERATORS
#define LOG_LOCAL_FID 0

#define	AGGREGATION_BUILDER_ENABLE_MINIMUM_TIMER (1)
#define	AGGREGATION_BUILDER_MINIMUM_TIMER_IN_US	 (2)

/* Msdu Density Default VAlues*/
#define AGGR_BUILDER_MSDU_DENSITY_THRESHOLD_DEFAULT_VALUE	(2400/ONE_EIGTH_US_IN_NS) /* Min Packet size for the for the system to serve in steady state /Max Rate =>
																						 512[Byte] / 1.7[Gbps] = 2.4[uS] = 2400 [ns] in 1/8 usec units */
#define AGGR_BUILDER_MSDU_DENSITY_RSRVD_INIT_DEFAULT_VALUE	(20000/ONE_EIGTH_US_IN_NS) /*20us in 1/8 usec units*/
#define AGGR_BUILDER_MSDU_DENSITY_MAX_INCREASE_DEFAULT_VALUE	(7000/ONE_EIGTH_US_IN_NS) /* 1500B frame in 1.7Gbps:1500[Byte] / 1.7[Gbps] = 7[uS] in 1/8 usec units*/
#define AGGR_BUILDER_MSDU_DENSITY_MAX_RSRVD_PERIOD_DEFAULT_VALUE (2*AGGR_BUILDER_MSDU_DENSITY_RSRVD_INIT_DEFAULT_VALUE) /* 40usec in 1/8 units*/
#define AGGR_BUILDER_MSDU_DENSITY_ZLD_MIN_LIMIT					(0)

/* PSDU Construct Enable Bits */
#define AGGR_BUILDER_ALLOWED_1_MPDU_IN_AMPDU_HT				(1)
#define AGGR_BUILDER_SU_ALLOWED_1_MPDU_IN_AMPDU_VHT			(1)
#define AGGR_BUILDER_RETRY_DB_MAX_MSDU_AT_AMSDU_LIMIT_CHECK	(0)
#define AGGR_BUILDER_RETRY_DB_MAX_MPDU_LENGTH_LIMIT_CHECK	(1)
#define AGGR_BUILDER_MU_ALLOWED_1_MPDU_IN_AMPDU_VHT			(1)

/* Prrotection Configuration*/
#define	AGGR_BUILDER_ENABLE_TX_SEQ_DUR_OFDM_DEC_6_US  	(1)
#define	AGGR_BUILDER_DISABLE_TX_SEQ_DUR_OFDM_DEC_6_US 	(0)
#define	AGGR_BUILDER_ENABLE_TX_MPDU_DUR_OFDM_DEC_6_US 	(1)
#define	AGGR_BUILDER_DISABLE_TX_MPDU_DUR_OFDM_DEC_6_US	(0)

#define	AGGREGATION_BUILDER_PROTECTION_DEFAULT_LENGTH 		(1501)

#define AGGR_BUILDER_DURTION_RATIO_TH_11B_MCS_0				(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11B_MCS_1				(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11B_MCS_2				(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11B_MCS_3				(0x1F)

#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_0_20_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_1_20_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_2_20_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_3_20_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_4_20_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_5_20_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_6_20_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_7_20_MHZ	(0x1F)

#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_0_40_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_1_40_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_2_40_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_3_40_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_4_40_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_5_40_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_6_40_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_7_40_MHZ	(0x1F)

#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_0_80_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_1_80_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_2_80_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_3_80_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_4_80_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_5_80_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_6_80_MHZ	(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_7_80_MHZ	(0x1F)

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_4_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_4_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_4_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_4_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_4_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_4_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_4_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_4_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_4_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_1_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_2_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_3_20_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_4_20_MHZ		(0x1F)

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_4_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_4_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_4_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_4_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_4_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_4_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_4_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_4_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_4_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_1_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_2_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_3_40_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_4_40_MHZ		(0x1F)

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_4_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_4_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_4_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_4_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_4_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_4_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_4_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_4_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_4_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_1_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_2_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_3_80_MHZ		(0x1F)
#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_4_80_MHZ		(0x1F)



#define AGGR_BUILDER_DURTION_RATIO_TH_11B			((AGGR_BUILDER_DURTION_RATIO_TH_11B_MCS_0 << DURATION_RATION_11B_MCS_0_SHIFT)| \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11B_MCS_1 << DURATION_RATION_11B_MCS_1_SHIFT)| \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11B_MCS_2 << DURATION_RATION_11B_MCS_2_SHIFT)| \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11B_MCS_3 << DURATION_RATION_11B_MCS_3_SHIFT))


#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_0	((AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_0_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_0_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_0_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT))
													 
#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_1	((AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_1_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_1_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_1_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_2	((AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_2_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_2_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_2_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_3	((AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_3_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_3_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_3_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_4	((AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_4_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_4_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_4_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_5	((AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_5_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_5_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_5_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT))


#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_6	((AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_6_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_6_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_6_40_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT))


#define AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_7	((AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_7_20_MHZ << DURATION_RATION_11_A_G_20_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_7_40_MHZ << DURATION_RATION_11_A_G_40_MHZ_SHIFT) | \
													 (AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_7_80_MHZ << DURATION_RATION_11_A_G_80_MHZ_SHIFT))


#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_20_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_1_20_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_2_20_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_3_20_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_4_20_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_40_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_1_40_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_2_40_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_3_40_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_4_40_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))


#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))

#define AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_80_MHZ ((AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_1_80_MHZ << DURATION_RATION_11_N_AC_NSS_1_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_2_80_MHZ << DURATION_RATION_11_N_AC_NSS_2_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_3_80_MHZ << DURATION_RATION_11_N_AC_NSS_3_SHIFT)|\
															(AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_NSS_4_80_MHZ << DURATION_RATION_11_N_AC_NSS_4_SHIFT))




/*	BF Report Analyzer Delta MCS Values as defined in SAS*/
#define AGGR_BUILDER_BF_REPORT_DELTA_MCS_INFORM_LMAC_LOW	(0xF)
#define AGGR_BUILDER_BF_REPORT_DELTA_MCS_INFORM_LMAC_HIGH	(0xF)
#define AGGR_BUILDER_BF_REPORT_DELTA_MCS_DO_NOTHING_LOW		(0x1)
#define AGGR_BUILDER_BF_REPORT_DELTA_MCS_DO_NOTHING_HIGH	(0xF)
#define AGGR_BUILDER_BF_REPORT_DELTA_NSS_INFORM_LMAC_LOW	(0x3)
#define AGGR_BUILDER_BF_REPORT_DELTA_NSS_INFORM_LMAC_HIGH	(0x3)
#define AGGR_BUILDER_BF_REPORT_DELTA_NSS_DO_NOTHING_LOW		(0x1)
#define AGGR_BUILDER_BF_REPORT_DELTA_NSS_DO_NOTHING_HIGH	(0x3)

/*	BF Report SNR TH Values as defined in SAS*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_0	(0xAC)	/*-84*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_1	(0xB8)	/*-72*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_2	(0xC2)	/*-62*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_3	(0xCF)	/*-49*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_4	(0xDC)	/*-36*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_5	(0xE8)	/*-24*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_6	(0xF3)	/*-13*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_7	(0xF7)	/*-9*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_8	(0x8)	/* 8*/
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_9	(0xE)	/*14*/



#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_0_TO_3	(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_0 			| \
													(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_1 << 8) 		| \
													(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_2 << 16) 	| \
													(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_3 << 24))
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_4_TO_7	(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_4 			| \
													(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_5 << 8) 		| \
													(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_6 << 16) 	| \
													(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_7 << 24))
#define AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_8_TO_9	(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_8 			| \
													(AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_9 << 8))

#define	DURATION_THRESHOLD_WORD_FORMAT_FACTOR 				0x8421


#define AGGR_BUILDER_11B_1M_MCS_INDEX 4
	
#define AGGR_BUILDER_SINGLE_PD_SETUP_TIME					90 // 1.4 microseconds in scale of 1/64 microseconds
#define AGGR_BUILDER_AMSDU_SETUP_TIME						90 // 1.4 microseconds in scale of 1/64 microseconds
#define AGGR_BUILDER_128BYTES_ARRIVAL_TIME					29 // 0.445 microseconds in scale of 1/64 microseconds
#define AGGR_BUILDER_ARRIVAL_TIME							0 // Dely between Sender and delia - defualt  0 
#define AGGR_BUILDER_ZLD_EXT_TIME 							256// 4 microseconds in scale of 1/64 microseconds
#define AGGR_BUILDER_MAX_SECONDARY_TIME_AFTER_PRIMARY 		((1 << 14) - 1) // max size of field
#define PHY_PREAMBLE_TIME_LEGACY							1280 //20micro-  in scale of 1/64 microseconds
#define PHY_PREAMBLE_TIME_HT								2304 //minimal value (one stream) , in scale of 1/64 microseconds
#define PHY_PREAMBLE_TIME_VHT								2560  //minimal value (one stream), in scale of 1/64 microseconds
#define SENDER_INIT_TIME_SINGLE_USER 						480//7.5 micro, in scale of 1/64 microseconds
#define SENDER_INIT_TIME_MULTY_USER 						960//15 micro, in scale of 1/64 microseconds
#define SENDER_INIT_TIME									SENDER_INIT_TIME_MULTY_USER
#define PHY_PREAMBLE_TIME									PHY_PREAMBLE_TIME_HT
#define AGGR_BUILDER_DEPARTURE_INIT_TIME					(PHY_PREAMBLE_TIME - SENDER_INIT_TIME)
#define AGGR_BUILDER_MU_TRAINING_DURATION				 	32000 // 345// 5.4 microseconds in scale of 1/64 microseconds
#define AGGR_BUILDER_MU_TRAINING_CTS2SELF_PROTECTION_METHOD 2//80Mhz 
#define AGGR_BUILDER_MU_TRAINING_NO_PROTECTION_METHOD		0
#define AGGR_BUILDER_MU_TRAINING_RTS_CTS_FORMAT 			3//Dynamic BW - only in case the training protection is RTS-CTS  (0x2)
#define AGGR_BUILDER_MU_NAX_NSTS							3 
#define AGGR_BUILDER_IGNORE_DYNAMIC_BW_20MHZ				0 
#define AGGR_BUILDER_BF_MU_TRAINING_FILLER_TYPE				0x01 	//CTS2SELF filler for BF MU training 
#define AGGR_BUILDER_MU_BAR_BACK_AIR_TIME_DURATION			438	 	//438 microseconds: SIFS + PHY Preabmle + BAR + SIFS + PHY Preamble + Block Ack (rate 6.5MHz (lowest VHT rate))
#define AGGR_BUILDER_MU_PSDU_LENGTH_RTS_CTS2SELD_THRE_SUM_MAX_N	0 	 




/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
#if defined (ENET_INC_LMAC)
AggregationBuilderRam_t *aggregationBuilderRam;


const AggregationBuilderRam_t aggreagtionBuilderRamValues =
{
	/* 11 B Duration Ratio*/
	{
		AGGR_BUILDER_DURTION_RATIO_TH_11B
	},
	/* 11 A\G Duration Ratio*/
	{
		AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_0,
		AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_1,
		AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_2,
		AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_3,
		AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_4,
		AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_5,
		AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_6,
		AGGR_BUILDER_DURTION_RATIO_TH_11_A_G_MCS_7
	},
	/* 11 N\AC  Duration Ratio*/
	{
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_20_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_20_MHZ,	
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_20_MHZ,	
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_20_MHZ,	
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_20_MHZ,	
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_20_MHZ,	
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_20_MHZ,	
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_20_MHZ,	
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_20_MHZ,	
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_20_MHZ	
	},
	{
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_40_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_40_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_40_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_40_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_40_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_40_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_40_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_40_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_40_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_40_MHZ,
	},
	{
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_0_80_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_1_80_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_2_80_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_3_80_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_4_80_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_5_80_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_6_80_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_7_80_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_8_80_MHZ,
		AGGR_BUILDER_DURTION_RATIO_TH_11_N_AC_MCS_9_80_MHZ
	}
};

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Debug Section									
/----------------------------------------------------------------------------------*/
uint32 AAA_AggrBuilderInterruptStatusVal = 0;
uint32 AAA_AggBuilderAmsduErrorCounter = 0;
uint32 AAA_AggBuilderMpduErrorCounter = 0;
uint32 AAA_AggBuilderMinimumLimitErrorCounter = 0;

/*---------------------------------------------------------------------------------
/						Static Functions Declarartions									
/----------------------------------------------------------------------------------*/
void aggregationBuilder_RecoverFromWrongPsduSize(RegAggBuilderTxSelResult_u *regAggBuilderTxSelResult,
												RegAggBuilderTxSelUsp0Result1_u *regAggBuilderTxSelUspResultsArray,
												uint16 *firstPdPointerUspArray);

void aggregationBuilder_RecoverFromWrongMpduSize(RegAggBuilderTxSelResult_u *regAggBuilderTxSelResult,
												RegAggBuilderTxSelUsp0Result1_u *regAggBuilderTxSelUspResultsArray,
												uint16 *firstPdPointerUspArray);

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

AggregationBuilder_FillConfigurationDb


Description:
------------
	Fill aggregation builder configuration Ram in Shram with:
		1) cts2self Bytes TH
		2)
		3)
		4)
	

Input:
-----
	vapIndex - VAp Index
	protectionRate - Rate of the protection frames
Output:
-------
	None
**********************************************************************************/
void AggregationBuilder_FillConfigurationDb(uint32 vapIndex,uint32 protectionRate, uint32 protectionPhyMode, uint32 fillerRate ,uint32 fillerPhyMode)
{
	AggrDb_t *configurationDb = &AggregationBuilderConfigurationDb[vapIndex];
	
	configurationDb->cts2SelfByteLengthThreshold = MAX_MPDU_LENGTH_OPTION3_VHT;
	configurationDb->rtsCtsByteLengthThreshold = MAX_MPDU_LENGTH_OPTION3_VHT;


	/* Fill the protection Air Time Duration */
	if(protectionPhyMode == PHY_MODE_11B)
	{
		configurationDb->cts2SelfAirTimeDuration	 = Protocol_GetAckCts11bAirTime(protectionRate)+ SIFS_TIME_11B; 
		configurationDb->rtsCtsfAirTimeDuration		 = Protocol_GetRtsCfEnd11bAirTime(protectionRate) + SIFS_TIME_11B + configurationDb->cts2SelfAirTimeDuration;
	}
	else
	{
		configurationDb->cts2SelfAirTimeDuration	 = Protocol_GetAckCts11agAirTime(protectionRate)+ SIFS_TIME_11A;
		configurationDb->rtsCtsfAirTimeDuration		 = Protocol_GetRtsCfEnd11agAirTime(protectionRate) + SIFS_TIME_11A + configurationDb->cts2SelfAirTimeDuration;
	}

	/* Fill the filler Air Time Duration which can be different from protection duration */
	if(fillerPhyMode == PHY_MODE_11B)
	{
		configurationDb->fillerCts2SelfAirTimeDuartion	= Protocol_GetAckCts11bAirTime(fillerRate)+ SIFS_TIME_11B;
		configurationDb->fillerRtsCtsAirTimeDuartion	= Protocol_GetRtsCfEnd11bAirTime(fillerRate) + SIFS_TIME_11B + configurationDb->cts2SelfAirTimeDuration;
		configurationDb->fillerNdpAckAirTimeDuartion	= Protocol_GetNdp11bAirTime(fillerRate) + SIFS_TIME_11B + configurationDb->fillerCts2SelfAirTimeDuartion;
	}
	else
	{
		
		configurationDb->fillerCts2SelfAirTimeDuartion	= Protocol_GetAckCts11agAirTime(fillerRate)+ SIFS_TIME_11A;
		configurationDb->fillerRtsCtsAirTimeDuartion	= Protocol_GetRtsCfEnd11agAirTime(fillerRate) + SIFS_TIME_11A + configurationDb->cts2SelfAirTimeDuration;
		configurationDb->fillerNdpAckAirTimeDuartion	= Protocol_GetNdp11agAirTime(fillerRate) + SIFS_TIME_11A  + configurationDb->fillerCts2SelfAirTimeDuartion;
	}
}
#endif /* #if defined (ENET_INC_LMAC) */

/**********************************************************************************

AggregationBuilder_SetForceProtection  

Description:
------------



Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void AggregationBuilder_SetForceProtection(uint32 vapIndex, AggrBuilderForceProtectionMode_e forceProtectionMode, uint32 forceProtectionOnOff)
{
	RegAggBuilderForceRtsCts2SelfVap_u forceRtsCts2SelfVapReg;	
	uint32 maskVal,offset;

	forceRtsCts2SelfVapReg.val = 0; // Clear both protection modes if present

	if (forceProtectionOnOff == TRUE)
	{
		offset = 16* forceProtectionMode + vapIndex;
		forceRtsCts2SelfVapReg.val = (forceProtectionOnOff << offset);
	}

	maskVal = ((1 << vapIndex) | (1 << (16+vapIndex))); // Write to both RTS and CTS2SELF (either both are '0', or one of them is '1')
		
	RegAccess_WriteMasked(REG_AGG_BUILDER_FORCE_RTS_CTS2SELF_VAP, maskVal, forceRtsCts2SelfVapReg.val);
}


#if defined (ENET_INC_LMAC)

/**********************************************************************************

AggregationBuilder_Set11BPreambleOverride  


Description:
------------
trigger the aggregation builder module to start its operation


Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void AggregationBuilder_Set11BPreambleOverride(uint32 enable11bPreambleOverride, uint32 mcs0Replacment)
{
	RegAggBuilderPreamble11BTypeControl_u preamble11bTypeControlReg;
		
	preamble11bTypeControlReg.val = 0;

	/* Configure 11B preamble to be taken from aggregation bulder instead of DB*/
	preamble11bTypeControlReg.bitFields.preamble11BTypeEn = enable11bPreambleOverride;
	preamble11bTypeControlReg.bitFields.preamble11BMcs000Replacement = mcs0Replacment;
	
	RegAccess_Write(REG_AGG_BUILDER_PREAMBLE_11B_TYPE_CONTROL, preamble11bTypeControlReg.val);
}

/**********************************************************************************

AggregationBuilder_Set11bPreambleMode  


Description:
------------
trigger the aggregation builder module to start its operation


Input:
-----
	vapIndex
	preambleMode

	
**********************************************************************************/
void AggregationBuilder_Set11bPreambleMode(uint32 vapIndex, AggrBuilder11BPreambleMode_e preambleMode)
{
	RegAggBuilderPreamble11BTypeVap_u preamble11BTypeVapReg;
	uint32 maskVal;

	preamble11BTypeVapReg.val = (preambleMode << vapIndex);
	maskVal = (1 << vapIndex);
		
	RegAccess_WriteMasked(REG_AGG_BUILDER_PREAMBLE_11B_TYPE_VAP, maskVal, preamble11BTypeVapReg.val);
}
/**********************************************************************************

AggregationBuilder_Get11BPreambleOverrideMode  


Description:
------------
Return  preamble mode per vap if preamble11BTypeEn is enabled else return 0

Input:
-----
	vapIndex

	
**********************************************************************************/

void  AggregationBuilder_Get11BPreambleOverrideMode(uint32 vapIndex, bool* isOvverideEnabled, AggrBuilder11BPreambleMode_e* preambleMode)
{
	RegAggBuilderPreamble11BTypeVap_u preamble11BTypeVapReg;
	RegAggBuilderPreamble11BTypeControl_u preamble11bTypeControlReg;
	
	RegAccess_Read(REG_AGG_BUILDER_PREAMBLE_11B_TYPE_CONTROL,&preamble11bTypeControlReg.val);
	RegAccess_Read(REG_AGG_BUILDER_PREAMBLE_11B_TYPE_VAP, &preamble11BTypeVapReg.val);
	
	*preambleMode = (AggrBuilder11BPreambleMode_e)((preamble11BTypeVapReg.val >> vapIndex) & 0x1);
	*isOvverideEnabled = preamble11bTypeControlReg.bitFields.preamble11BTypeEn;
}


/**********************************************************************************

isr_AggregationBuilder_ErrorOrDone  


Description:
------------
interrupt routine that handles errors scenarions and done operation in the aggregation builder operation

Input:
-----
	None
Output:
-------
	None
**********************************************************************************/
void isr_AggregationBuilder_ErrorOrDone(void)
{
	RegAggBuilderAggBuilderStatusIrq_u interruptStatusRegister ;
	RegAggBuilderAggBuilderStatusIrqClr_u  interruptClearRegister;
	RegAggBuilderTxSelResult_u regAggBuilderTxSelResult;
	RegAggBuilderTxSelUsp0Result1_u regAggBuilderTxSelUspResultsArray[4];
	RegAggBuilderFirstPdPointerUsp01_u regAggBuilderFirstPdPointerUsp01;
	RegAggBuilderFirstPdPointerUsp23_u regAggBuilderFirstPdPointerUsp23;
	uint16 firstPdPointerUspArray[4];
    uint32 mpduRecover = FALSE;

	ACCUMULATE_CPU_IDLE_TIME();

	interruptClearRegister.val = 0;
	interruptStatusRegister.val = 0;
	
	// Read the status register (check which error occurred) 
	RegAccess_Read(REG_AGG_BUILDER_AGG_BUILDER_STATUS_IRQ, &interruptStatusRegister.val);

	// Read the tx selector results
	RegAccess_Read(REG_AGG_BUILDER_TX_SEL_RESULT, &regAggBuilderTxSelResult.val);
	
	// Read the last QID that aggregator got from selector (tid, sta, vap, qId, ac)
	RegAccess_Read(REG_AGG_BUILDER_TX_SEL_USP0_RESULT1, &(regAggBuilderTxSelUspResultsArray[0].val));
	RegAccess_Read(REG_AGG_BUILDER_TX_SEL_USP1_RESULT1, &(regAggBuilderTxSelUspResultsArray[1].val));
	RegAccess_Read(REG_AGG_BUILDER_TX_SEL_USP2_RESULT1, &(regAggBuilderTxSelUspResultsArray[2].val));
	RegAccess_Read(REG_AGG_BUILDER_TX_SEL_USP3_RESULT1, &(regAggBuilderTxSelUspResultsArray[3].val));

	// Read the first pd pointer in the chosen queue
	RegAccess_Read(REG_AGG_BUILDER_FIRST_PD_POINTER_USP0_1, &regAggBuilderFirstPdPointerUsp01.val);
	RegAccess_Read(REG_AGG_BUILDER_FIRST_PD_POINTER_USP2_3, &regAggBuilderFirstPdPointerUsp23.val);

	AAA_AggrBuilderInterruptStatusVal = interruptStatusRegister.val;

//	ILOG0_D("isr_AggregationBuilder_ErrorOrDone, status 0x%x", AAA_AggrBuilderInterruptStatusVal); 

	memcpy(&(firstPdPointerUspArray[0]), &regAggBuilderFirstPdPointerUsp01.val, sizeof(RegAggBuilderFirstPdPointerUsp01_u));
	memcpy(&(firstPdPointerUspArray[2]), &regAggBuilderFirstPdPointerUsp23.val, sizeof(RegAggBuilderFirstPdPointerUsp23_u));

	// Check if the error is for size (i.e time not enough) of first PSDU in queue.
	// This can occur of it's an AMSDU which is retransmitted, but chosen rate is now low and PSDU is too big.
	// In this case we should be able to recover by throwing away this AMSDU.
	if (interruptStatusRegister.bitFields.firstDataPdPsduSizeEstimatedErrorIrq == TRUE)
	{
		AAA_AggBuilderAmsduErrorCounter++;
		
		// Clear the interrupt
		interruptClearRegister.bitFields.firstDataPdPsduSizeEstimatedErrorIrqClr = AGGREGATION_BUILDER_CLEAR_INTERRUPT;

		// Recover from the error
		aggregationBuilder_RecoverFromWrongPsduSize(&regAggBuilderTxSelResult,
													&(regAggBuilderTxSelUspResultsArray[0]),
													&(firstPdPointerUspArray[0]));
			
		// Clear the value of the error from the bitmap so that we can ASSERT later in case there is another error which is not recoverable.
		interruptStatusRegister.bitFields.firstDataPdPsduSizeEstimatedErrorIrq = 0;
	}
    
	// Check if the error for size (in bytes) of first MPDU in queue.
	// This can occur of it's an MPDU which is retransmitted, but chosen rate is now low and MPDU is too big.
	// In this case we should be able to recover by throwing away this MPDU.
    // passable scenario: After rate drop from AC to Legacy (B/G) retransmitted MPDU(a-msdu / msdu) cant fit maximum byte length.
    // -- Agg builder spec --
    //  Max MPDU byte length is set according to the following in 11a/g/b PHY mode:
    //  Takes the lower between the following:
    //      - Max MPDU size (configurable register). ==> Default is 4095 
    //      - Max MPDU size (STA DB). ==> VHT support is 11454
    //      - Max MPDU byte length estimated (equals to Max PSDU byte length estimated). == FLOOR{"Max PSDU byte length estimated" divided by Max MPDUs in A-MPDU} in VHT is 1M/48 >> Very big  
    // -- Agg builder spec --
    if (interruptStatusRegister.bitFields.firstDataPdMpduSizeConfigErrorIrq == TRUE)
	{
		// Clear the interrupt
		interruptClearRegister.bitFields.firstDataPdMpduSizeConfigErrorIrqClr = AGGREGATION_BUILDER_CLEAR_INTERRUPT;

		// Recover from the error FLAG
		mpduRecover = TRUE;
			
		// Clear the value of the error from the bitmap so that we can ASSERT later in case there is another error which is not recoverable.
		interruptStatusRegister.bitFields.firstDataPdMpduSizeConfigErrorIrq = 0;
	}
    
    if (interruptStatusRegister.bitFields.firstDataPdMpduSizeDbErrorIrq == TRUE) 
    {    
        // Clear the interrupt
        interruptClearRegister.bitFields.firstDataPdMpduSizeDbErrorIrqClr = AGGREGATION_BUILDER_CLEAR_INTERRUPT; 

        // Recover from the error FLAG
		mpduRecover = TRUE;
            
        // Clear the value of the error from the bitmap so that we can ASSERT later in case there is another error which is not recoverable.
        interruptStatusRegister.bitFields.firstDataPdMpduSizeDbErrorIrq = 0;
    }
    
    if (mpduRecover == TRUE)
    {
        // Recover from the error
		aggregationBuilder_RecoverFromWrongMpduSize(&regAggBuilderTxSelResult,
													&(regAggBuilderTxSelUspResultsArray[0]),
													&(firstPdPointerUspArray[0]));
    	AAA_AggBuilderMpduErrorCounter++;
    }
    
    if (interruptStatusRegister.bitFields.dataPdsRdCountLessMinLimitIrq == TRUE) 
    {    
        // Clear the interrupt
        interruptClearRegister.bitFields.dataPdsRdCountLessMinLimitIrqClr = AGGREGATION_BUILDER_CLEAR_INTERRUPT; 

		AAA_AggBuilderMinimumLimitErrorCounter++;
            
        // Clear the value of the error from the bitmap so that we can ASSERT later in case there is another error which is not recoverable or ignorable
        interruptStatusRegister.bitFields.dataPdsRdCountLessMinLimitIrq = 0;
    }

	ASSERT((interruptStatusRegister.val == 0) || (interruptStatusRegister.val == AGGREGATION_BUILDER_INTERRUPT_DONE_OPERATION_INTERRUPT));
	
	/* Clear only the done bit - in case another error occurs the interrupt will occur after finishing with this interrupt */
	interruptClearRegister.bitFields.doneOperationIrqClr = AGGREGATION_BUILDER_CLEAR_INTERRUPT;
	RegAccess_Write(REG_AGG_BUILDER_AGG_BUILDER_STATUS_IRQ_CLR, interruptClearRegister.val);
    
}


void aggregationBuilder_RecoverFromWrongPsduSize(RegAggBuilderTxSelResult_u *regAggBuilderTxSelResult,
												RegAggBuilderTxSelUsp0Result1_u *regAggBuilderTxSelUspResultsArray,
												uint16 *firstPdPointerUspArray)
{
	HwQueueManagerRequestParams_t 	hwQueueManagerRequestParams;
	K_MSG*							pIndMsg =  NULL;
	AggBuilderRecoverFromError_t* 	pErrorRecoverIndMsg = NULL;	
	AggBuilderRecoverFromError_t	ErrorRecoverInd;
	AggBuilderRecoverFromError_t* 	pErrorRecoverInd = &ErrorRecoverInd;	
	uint32							usp = 0;
	bool							clientIsoRecovery = FALSE;
	K_MSG							*pMsg = NULL;
	LaClientIsoRecoveryMsg_t        *laClientIsoRecovery;

	// make sure the chosen primary queue is for STA
	DEBUG_ASSERT(regAggBuilderTxSelUspResultsArray[regAggBuilderTxSelResult->bitFields.txSelMuPrimaryUsp].bitFields.txSelUsp0TxqQueueId == HW_TX_Q_TYPE_STA_TID);

	memset(pErrorRecoverInd, 0x0, sizeof(AggBuilderRecoverFromError_t));
	
	pErrorRecoverInd->isMu = regAggBuilderTxSelResult->bitFields.txSelMuSuN;
	pErrorRecoverInd->muGroupLock = regAggBuilderTxSelResult->bitFields.txSelMuGroupLock;
	pErrorRecoverInd->uspLock = regAggBuilderTxSelResult->bitFields.txSelUspLock;
	pErrorRecoverInd->muGrpEntry = regAggBuilderTxSelResult->bitFields.txSelMuGrpEntry;
	pErrorRecoverInd->primaryUsp = regAggBuilderTxSelResult->bitFields.txSelMuPrimaryUsp;


	//iterate over all usp
	for (usp = 0; usp < 4; usp++)
	{
		if (pErrorRecoverInd->uspLock & (TRUE << usp))
		{
			pErrorRecoverInd->stationIndex[usp] = regAggBuilderTxSelUspResultsArray[usp].bitFields.txSelUsp0TxqStaId;
			pErrorRecoverInd->tid[usp] = regAggBuilderTxSelUspResultsArray[usp].bitFields.txSelUsp0TxqTidId;

			if (usp == pErrorRecoverInd->primaryUsp)
			{
				// Peek at the head PD. 
				memset(&hwQueueManagerRequestParams,0, sizeof(HwQueueManagerRequestParams_t));
				hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_DATA_DLM;
				hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_STA_TID;
				hwQueueManagerRequestParams.primaryAddr = pErrorRecoverInd->stationIndex[usp];
				hwQueueManagerRequestParams.secondaryAddr = pErrorRecoverInd->tid[usp];
				hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_TWO;
				HwQManager_PeekHeadPacket(&hwQueueManagerRequestParams);
				pErrorRecoverInd->headPd = (TxPd_t *)hwQueueManagerRequestParams.pHeadDesc;

				// Make sure the head PD is the same as aggregation builder think it is
				DEBUG_ASSERT(pErrorRecoverInd->headPd == (TxPd_t *)CONVERT_OFFSET_TO_PD(firstPdPointerUspArray[usp]));

				// if it is an A-MSDU we will drop it because the A-MSDU may be too big for current rate
				// if it is not an A-MSDU it may have been caused by client isolation
				if ((pErrorRecoverInd->isMu == TRUE) && (regAggBuilderTxSelResult->bitFields.aggSwitchMuToSu == FALSE))
				{
					/*No Client Isolation in Multi User so it shold only happen for A-MSDU*/
					DEBUG_ASSERT(pErrorRecoverInd->headPd->aggregationIndication == TRUE);					
				}
				else
				{
					if (pErrorRecoverInd->headPd->aggregationIndication == FALSE)
					{
						clientIsoRecovery = TRUE;
					}
				}
			}
		}
	}


	if (clientIsoRecovery == TRUE)
	{
		pMsg = OSAL_GET_MESSAGE(sizeof(LaClientIsoRecoveryMsg_t));
		laClientIsoRecovery = (LaClientIsoRecoveryMsg_t *)pK_MSG_DATA(pMsg);
		laClientIsoRecovery->headPd = pErrorRecoverInd->headPd;
		memcpy(laClientIsoRecovery->staIndex, pErrorRecoverInd->stationIndex, 4);
		memcpy(laClientIsoRecovery->tid, pErrorRecoverInd->tid, 4);
		laClientIsoRecovery->isMu = pErrorRecoverInd->isMu;
		laClientIsoRecovery->muGrpEntry = pErrorRecoverInd->muGrpEntry;
		laClientIsoRecovery->uspLock = pErrorRecoverInd->uspLock;
		laClientIsoRecovery->muGroupLock = pErrorRecoverInd->muGroupLock;
		laClientIsoRecovery->primaryUsp = pErrorRecoverInd->primaryUsp;
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_RECOVERY_TIME_LIMIT, TASK_LINK_ADAPTATION, pMsg, VAP_ID_DO_NOT_CARE);
		return;
	}
	
	// Prepare a MSG to Tx Manager (in UM)
	pIndMsg = OSAL_GET_MESSAGE(sizeof(AggBuilderRecoverFromError_t));
	pErrorRecoverIndMsg = (AggBuilderRecoverFromError_t *)pK_MSG_DATA(pIndMsg);
	memcpy(pErrorRecoverIndMsg, pErrorRecoverInd, sizeof(AggBuilderRecoverFromError_t));	
	
	// send MSG to Tx Manager (in UM) to continue the recovery
	OSAL_SEND_MESSAGE(TX_MANAGER_AGGREGATOR_ERROR_RECOVER, TASK_TX_MANAGER, pIndMsg, VAP_ID_DO_NOT_CARE);

}

void aggregationBuilder_RecoverFromWrongMpduSize(RegAggBuilderTxSelResult_u *regAggBuilderTxSelResult,
												RegAggBuilderTxSelUsp0Result1_u *regAggBuilderTxSelUspResultsArray,
												uint16 *firstPdPointerUspArray)
{
	HwQueueManagerRequestParams_t 	hwQueueManagerRequestParams;
	K_MSG*							pIndMsg =  NULL;
	AggBuilderRecoverFromError_t* 	pErrorRecoverIndMsg = NULL;	
	AggBuilderRecoverFromError_t	ErrorRecoverInd;
	AggBuilderRecoverFromError_t* 	pErrorRecoverInd = &ErrorRecoverInd;	
	uint32							usp = 0;

	// make sure the chosen primary queue is for STA
	DEBUG_ASSERT(regAggBuilderTxSelUspResultsArray[regAggBuilderTxSelResult->bitFields.txSelMuPrimaryUsp].bitFields.txSelUsp0TxqQueueId == HW_TX_Q_TYPE_STA_TID);

	memset(pErrorRecoverInd, 0x0, sizeof(AggBuilderRecoverFromError_t));
	
	pErrorRecoverInd->isMu = regAggBuilderTxSelResult->bitFields.txSelMuSuN;
	pErrorRecoverInd->muGroupLock = regAggBuilderTxSelResult->bitFields.txSelMuGroupLock;
	pErrorRecoverInd->uspLock = regAggBuilderTxSelResult->bitFields.txSelUspLock;
	pErrorRecoverInd->muGrpEntry = regAggBuilderTxSelResult->bitFields.txSelMuGrpEntry;
	pErrorRecoverInd->primaryUsp = regAggBuilderTxSelResult->bitFields.txSelMuPrimaryUsp;

	//iterate over all usp
	for (usp = 0; usp < 4; usp++)
	{
		if (pErrorRecoverInd->uspLock & (TRUE << usp))
		{
			pErrorRecoverInd->stationIndex[usp] = regAggBuilderTxSelUspResultsArray[usp].bitFields.txSelUsp0TxqStaId;
			pErrorRecoverInd->tid[usp] = regAggBuilderTxSelUspResultsArray[usp].bitFields.txSelUsp0TxqTidId;

			if (usp == pErrorRecoverInd->primaryUsp)
			{
				// Peek at the head PD. 
				memset(&hwQueueManagerRequestParams,0, sizeof(HwQueueManagerRequestParams_t));
				hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_DATA_DLM;
				hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_STA_TID;
				hwQueueManagerRequestParams.primaryAddr = pErrorRecoverInd->stationIndex[usp];
				hwQueueManagerRequestParams.secondaryAddr = pErrorRecoverInd->tid[usp];
				hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_TWO;
				HwQManager_PeekHeadPacket(&hwQueueManagerRequestParams);
				pErrorRecoverInd->headPd = (TxPd_t *)hwQueueManagerRequestParams.pHeadDesc;

				// Make sure the head PD is the same as aggregation builder think it is
				DEBUG_ASSERT(pErrorRecoverInd->headPd == (TxPd_t *)CONVERT_OFFSET_TO_PD(firstPdPointerUspArray[usp]));
			}
		}
	}

	// Prepare a MSG to Tx Manager (in UM)
	pIndMsg = OSAL_GET_MESSAGE(sizeof(AggBuilderRecoverFromError_t));
	pErrorRecoverIndMsg = (AggBuilderRecoverFromError_t *)pK_MSG_DATA(pIndMsg);
	memcpy(pErrorRecoverIndMsg, pErrorRecoverInd, sizeof(AggBuilderRecoverFromError_t));	

	// send MSG to Tx Manager (in UM) to continue the recovery
	OSAL_SEND_MESSAGE(TX_MANAGER_AGGREGATOR_ERROR_RECOVER, TASK_TX_MANAGER, pIndMsg, VAP_ID_DO_NOT_CARE);
	
}


/**********************************************************************************

AggregationBuilder_Initialize  


Description:
------------
initialize the global tables and internal registers of the aggregation builder module

Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
#if defined (ENET_INC_LMAC)
#pragma ghs section text=".initialization" 
#endif
void AggregationBuilder_Initialize()
{		
	RegAggBuilderAggBuilderStatusIrqMask_u interruptMaskRegister;
	RegAggBuilderAggBuilderTimerMinMax_u timerMinMaxReg;
	RegAggBuilderTxDurCalcControl_u txDurationCalcControl;
	RegAggBuilderAggConfigDb_u aggrConfigDbReg;	
	RegAggBuilderAggConfigDb4BOffset_u aggrConfigDbOffsetReg;	
	RegAggBuilderPsduConstructEnableBits_u  psduConstructEnableBitsReg;
	RegAggBuilderBfRptAnalyzerDeltaMcsNss_u bfRptAnalyzerDeltaMcsNss;
	RegAggBuilderArrivalSetupTime_u	arrivalSetupTimeReg; 
	RegAggBuilderArrivalProcessTime_u	arrivalProcessTImeReg; 
	RegAggBuilderArrival128ByteTime_u	arrivel128BytesTimeReg; 
	RegAggBuilderDepartureInitTime_u	departureInitTimeReg; 
	RegAggBuilderZldExtensionTime_u	zldExtensionTimeReg;
	RegAggBuilderMuMaxNsts_u	muMxNstsReg; 
	RegAggBuilderRtsCts2SelfControl_u	rtsCts2SelfControlReg; 
	RegAggBuilderMuMultUsrsTrainingControl_u muBfTrainingCtrlReg; 
	RegAggBuilderMuBarBackAirTimeDuration_u muBaAirTimeDurReg;
	RegAggBuilderMaxSecondaryDurationPrimaryEnd_u maxSecondaryDurAfterPrimaryEndReg; 
	RegAggBuilderMuGrpDbAddr_u muGrpDbAddrReg; 
	RegAggBuilderAggBuilderEnable_u aggrBuilderEnableReg;
	RegAggBuilderZeroTimerThreshold_u regAggBuilderZeroTimerThreshold;
	RegAggBuilderTxopAirTimeDuration_u regAggBuilderTxopAirTimeDuration;

	interruptMaskRegister.val = 0;
	timerMinMaxReg.val = 0; 
	txDurationCalcControl.val = 0;
	aggrConfigDbReg.val = 0;
	aggrConfigDbOffsetReg.val = 0;
	psduConstructEnableBitsReg.val = 0;
	bfRptAnalyzerDeltaMcsNss.val = 0;
	
	arrivalSetupTimeReg.val = 0;
	arrivalProcessTImeReg.val = 0;
	arrivel128BytesTimeReg.val = 0;
	departureInitTimeReg.val = 0;
	zldExtensionTimeReg.val = 0;
	muMxNstsReg.val = 0;
	rtsCts2SelfControlReg.val = 0;
	muBfTrainingCtrlReg.val = 0; 
	muBaAirTimeDurReg.val =0; 
	maxSecondaryDurAfterPrimaryEndReg.val = 0; 
	muGrpDbAddrReg.val = 0; 
	aggrBuilderEnableReg.val = 0;
	regAggBuilderZeroTimerThreshold.val = 0;
	regAggBuilderTxopAirTimeDuration.val = 0;
	
	
	interruptMaskRegister.bitFields.firstDataPdAMsduCtrErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstDataPdMsduSizeErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstDataPdMpduSizeDbErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstDataPdPsduSizeErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstDataPdPsduSizeEstimatedErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstDataPdNotRetriesMpdusCountErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.startOperationIrqMask = 0x1;
	interruptMaskRegister.bitFields.operationTimerErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.txhdStartDuringOperationIrqMask = 0x1;
	interruptMaskRegister.bitFields.cpuStartDuringOperationIrqMask = 0x1;
	interruptMaskRegister.bitFields.txStdForbiddenGenriscAccessIrqMask = 0x1;
	interruptMaskRegister.bitFields.dataPdsRdCountLessMinLimitIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstPdPointerNullIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstDataPdMpduSizeConfigErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.firstDataPdPsduSizeSecondaryPrimaryEndErrorIrqMask = 0x1;
	interruptMaskRegister.bitFields.txSelPrimaryNotValidErrIrqMask = 0x1;
	interruptMaskRegister.bitFields.txSelNoUspValidErrIrqMask = 0x1;

	RegAccess_Write(REG_AGG_BUILDER_AGG_BUILDER_STATUS_IRQ_MASK, interruptMaskRegister.val);

	timerMinMaxReg.bitFields.aggBuilderTimerMinEn = AGGREGATION_BUILDER_ENABLE_MINIMUM_TIMER;
	timerMinMaxReg.bitFields.aggBuilderTimerMin	  = System_ConvertUsToSystemClk(AGGREGATION_BUILDER_MINIMUM_TIMER_IN_US); 
	RegAccess_Write(REG_AGG_BUILDER_AGG_BUILDER_TIMER_MIN_MAX, timerMinMaxReg.val);

	/* Set  dur calculation to be aware of signal extension in case of ofdm transmission*/
	txDurationCalcControl.bitFields.txSeqDurMainOfdmAdd6MicroEn = AGGR_BUILDER_DISABLE_TX_SEQ_DUR_OFDM_DEC_6_US;
	txDurationCalcControl.bitFields.txMpduDurFieldOfdmDec6MicroEn = AGGR_BUILDER_DISABLE_TX_MPDU_DUR_OFDM_DEC_6_US;
	RegAccess_Write(REG_AGG_BUILDER_TX_DUR_CALC_CONTROL, txDurationCalcControl.val);
	
	/* Init  internal Aggreagtion Builder Ram -Ratio between protection frame and protected data */
	aggregationBuilderRam = (AggregationBuilderRam_t *)(AGG_BUILDER_BASE_ADDR + AGGREGATIONBUILDER_RAM_ADDR_OFFSET); 
	memcpy32((void *)aggregationBuilderRam,(void *)&aggreagtionBuilderRamValues,sizeof(AggregationBuilderRam_t) >> 2);
	
	/* Init   Aggreagtion Builder configuration in shram - Rts\Cts duration, Threshholds, filler duration*/
	memset32(AggregationBuilderConfigurationDb,0,sizeof(AggrDb_t) >> 2);
	aggrConfigDbReg.bitFields.aggConfigDbBaseAddr = (uint32)&AggregationBuilderConfigurationDb;
	aggrConfigDbReg.bitFields.aggConfigDbEntry4BSize = (sizeof(AggrDb_t) >> 2);
	RegAccess_Write(REG_AGG_BUILDER_AGG_CONFIG_DB, aggrConfigDbReg.val);
	aggrConfigDbOffsetReg.bitFields.aggConfigDb4BOffset = 0;
	RegAccess_Write(REG_AGG_BUILDER_AGG_CONFIG_DB_4B_OFFSET, aggrConfigDbOffsetReg.val);

	/*Aggregation Builder Msdu Density Configuration*/
	psduConstructEnableBitsReg.bitFields.allowed1MpduInAMpduHt = AGGR_BUILDER_ALLOWED_1_MPDU_IN_AMPDU_HT; 
	psduConstructEnableBitsReg.bitFields.suAllowed1MpduInAMpduVht = AGGR_BUILDER_SU_ALLOWED_1_MPDU_IN_AMPDU_VHT; 
	psduConstructEnableBitsReg.bitFields.retryDbMaxMsdusAtAmsduLimitCheckEn = AGGR_BUILDER_RETRY_DB_MAX_MSDU_AT_AMSDU_LIMIT_CHECK; 
	psduConstructEnableBitsReg.bitFields.retryDbMaxMpduLengthLimitCheckEn = AGGR_BUILDER_RETRY_DB_MAX_MPDU_LENGTH_LIMIT_CHECK; 
	psduConstructEnableBitsReg.bitFields.muAllowed1MpduInAMpduVht = AGGR_BUILDER_MU_ALLOWED_1_MPDU_IN_AMPDU_VHT; 
	RegAccess_Write(REG_AGG_BUILDER_PSDU_CONSTRUCT_ENABLE_BITS, psduConstructEnableBitsReg.val);

	/*Aggregation Builder TXOP air time duration limit cofiguration*/
	regAggBuilderTxopAirTimeDuration.bitFields.txopAirTimeDuration = AGGREGATION_BUILDER_TXOP_AIR_TIME_DURATION_LIMIT;
	RegAccess_Write(REG_AGG_BUILDER_TXOP_AIR_TIME_DURATION, regAggBuilderTxopAirTimeDuration.val);

	arrivalSetupTimeReg.bitFields.arrivalPdSetupTime = AGGR_BUILDER_SINGLE_PD_SETUP_TIME;
	arrivalSetupTimeReg.bitFields.arrivalAMsduSetupTime = AGGR_BUILDER_AMSDU_SETUP_TIME; 
	
	RegAccess_Write(REG_AGG_BUILDER_ARRIVAL_SETUP_TIME, arrivalSetupTimeReg.val);

	arrivalProcessTImeReg.bitFields.arrivalProcessTime = AGGR_BUILDER_ARRIVAL_TIME; 
	RegAccess_Write(REG_AGG_BUILDER_ARRIVAL_PROCESS_TIME, arrivalProcessTImeReg.val);

	arrivel128BytesTimeReg.bitFields.arrival128ByteTime = AGGR_BUILDER_128BYTES_ARRIVAL_TIME;
	RegAccess_Write(REG_AGG_BUILDER_ARRIVAL_128BYTE_TIME, arrivel128BytesTimeReg.val);

	departureInitTimeReg.bitFields.departureInitTime = AGGR_BUILDER_DEPARTURE_INIT_TIME; 
	RegAccess_Write(REG_AGG_BUILDER_DEPARTURE_INIT_TIME, departureInitTimeReg.val);

	zldExtensionTimeReg.bitFields.zldExtensionTime = AGGR_BUILDER_ZLD_EXT_TIME; 
	RegAccess_Write(REG_AGG_BUILDER_ZLD_EXTENSION_TIME, zldExtensionTimeReg.val);
	
	maxSecondaryDurAfterPrimaryEndReg.bitFields.maxSecondaryDurationPrimaryEnd = AGGR_BUILDER_MAX_SECONDARY_TIME_AFTER_PRIMARY; 
	RegAccess_Write(REG_AGG_BUILDER_MAX_SECONDARY_DURATION_PRIMARY_END,maxSecondaryDurAfterPrimaryEndReg.val);

	muMxNstsReg.bitFields.muMaxNsts = AGGR_BUILDER_MU_NAX_NSTS; //this is the theoretical maximum per transmission, used to validate number of NSSs used in a single transmission
	RegAccess_Write(REG_AGG_BUILDER_MU_MAX_NSTS, muMxNstsReg.val);

	rtsCts2SelfControlReg.bitFields.ignoreDynamicBw20Mhz =	AGGR_BUILDER_IGNORE_DYNAMIC_BW_20MHZ; 
	rtsCts2SelfControlReg.bitFields.muPsduLengthRtsCts2SelfThrSumMaxN =	AGGR_BUILDER_MU_PSDU_LENGTH_RTS_CTS2SELD_THRE_SUM_MAX_N;
	RegAccess_Write(REG_AGG_BUILDER_RTS_CTS2SELF_CONTROL, rtsCts2SelfControlReg.val);

	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingAirTimeDuration = AGGR_BUILDER_MU_TRAINING_DURATION; 
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingBwLimit= BANDWIDTH_EIGHTY; //only initial value - this field has an API to be configured in runtime 
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingFillerType= AGGR_BUILDER_BF_MU_TRAINING_FILLER_TYPE; 
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingProtection= AGGR_BUILDER_MU_TRAINING_NO_PROTECTION_METHOD; 
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingRtsCtsFormat= AGGR_BUILDER_MU_TRAINING_RTS_CTS_FORMAT; 
	RegAccess_Write(REG_AGG_BUILDER_MU_MULT_USRS_TRAINING_CONTROL,muBfTrainingCtrlReg.val);

	muBaAirTimeDurReg.bitFields.muBarBackAirTimeDuration = AGGR_BUILDER_MU_BAR_BACK_AIR_TIME_DURATION;
	RegAccess_Write(REG_AGG_BUILDER_MU_BAR_BACK_AIR_TIME_DURATION,muBaAirTimeDurReg.val);
		

	muGrpDbAddrReg.bitFields.muGrpDbBaseAddr = (uint32)(&GroupDbHwEntries[0]);
	muGrpDbAddrReg.bitFields.muGrpDbEntry4BSize = (sizeof(MuGrpDb_t) >> 2);
	RegAccess_Write(REG_AGG_BUILDER_MU_GRP_DB_ADDR,muGrpDbAddrReg.val);

	/* Due to the MU changes, change the default configuration to 85 cycles */
	regAggBuilderZeroTimerThreshold.bitFields.zeroTimerThreshold = 0x55;
	regAggBuilderZeroTimerThreshold.bitFields.zeroTimerThresholdEn = 0x1;
	RegAccess_Write(REG_AGG_BUILDER_ZERO_TIMER_THRESHOLD,regAggBuilderZeroTimerThreshold.val);
	
	/*Aggregation BF Report Analyzer  Delta MCS & NSS*/
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaMcsCpuRaFillerLow	= AGGR_BUILDER_BF_REPORT_DELTA_MCS_INFORM_LMAC_LOW;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaMcsCpuRaFillerHigh	= AGGR_BUILDER_BF_REPORT_DELTA_MCS_INFORM_LMAC_HIGH;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaMcsDoNothingLow	= AGGR_BUILDER_BF_REPORT_DELTA_MCS_DO_NOTHING_LOW;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaMcsDoNothingHigh	= AGGR_BUILDER_BF_REPORT_DELTA_MCS_DO_NOTHING_HIGH;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaNssCpuRaFillerLow	= AGGR_BUILDER_BF_REPORT_DELTA_NSS_INFORM_LMAC_LOW;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaNssCpuRaFillerHigh	= AGGR_BUILDER_BF_REPORT_DELTA_NSS_INFORM_LMAC_HIGH;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaNssDoNothingLow	= AGGR_BUILDER_BF_REPORT_DELTA_NSS_DO_NOTHING_LOW;
	bfRptAnalyzerDeltaMcsNss.bitFields.bfRptDeltaNssDoNothingHigh	= AGGR_BUILDER_BF_REPORT_DELTA_NSS_DO_NOTHING_HIGH;
	RegAccess_Write(REG_AGG_BUILDER_BF_RPT_ANALYZER_DELTA_MCS_NSS,bfRptAnalyzerDeltaMcsNss.val);
	
	/*Aggregation BF Report Analyzer  SNR TH*/
	RegAccess_Write(REG_AGG_BUILDER_BF_RPT_ANALYZER_SNR_THRESHOLD_MCS0TO3,AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_0_TO_3);
	RegAccess_Write(REG_AGG_BUILDER_BF_RPT_ANALYZER_SNR_THRESHOLD_MCS4TO7,AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_4_TO_7);
	RegAccess_Write(REG_AGG_BUILDER_BF_RPT_ANALYZER_SNR_THRESHOLD_MCS8TO9,AGGR_BUILDER_BF_REPORT_SNR_TH_MCS_8_TO_9);	

	/*Set aggregation builder preamble ovveride enable, configure to replace non valid rate rate 000 (short preamble 1M  with long premable 1M)*/
	AggregationBuilder_Set11BPreambleOverride(ENABLED, AGGR_BUILDER_11B_1M_MCS_INDEX);

	/*Enable Aggregation Builder*/
	aggrBuilderEnableReg.bitFields.aggBuilderEnable = 0x1;
	aggrBuilderEnableReg.bitFields.aggBuilderMuEnable = 0x1;

	RegAccess_Write(REG_AGG_BUILDER_AGG_BUILDER_ENABLE, aggrBuilderEnableReg.val);
}
#if defined (ENET_INC_LMAC)
#pragma ghs section text=default 
#endif

void AggregationBuilder_SetDurationRatioThreshold (uint8 newThreshold)
{
	uint32 wordFormatThreshold = 0; 

	ASSERT(newThreshold < (AGGR_BUILDER_MAX_DURATION_THRESHOLD_CONFIGURATION+1)); 
	/* the threshold should be concatenated in 5 bits at resolution of 32 bits
		We can achive this format by multiply the value with DURATION_THRESHOLD_WORD_FORMAT_FACTOR (0x8421)*/
	wordFormatThreshold = newThreshold*DURATION_THRESHOLD_WORD_FORMAT_FACTOR;  
	memset32(aggregationBuilderRam,wordFormatThreshold,((sizeof(AggregationBuilderRam_t))>>2));
}

void AggregationBuilder_Halt(void)
{
	RegAggBuilderAggBuilderEnable_u aggrBuilderEnableReg;

	aggrBuilderEnableReg.val = 0;

	aggrBuilderEnableReg.bitFields.aggBuilderEnable = 0;
	aggrBuilderEnableReg.bitFields.aggBuilderMuEnable = 0;

	RegAccess_Write(REG_AGG_BUILDER_AGG_BUILDER_ENABLE	,aggrBuilderEnableReg.val);
}
#endif /*#if defined (ENET_INC_LMAC)*/

void AggregationBuilder_SetMuBfTrainingBwLimit(Bandwidth_e newLimit)
{
	RegAggBuilderMuMultUsrsTrainingControl_u muBfTrainingCtrlReg; 
	
	ASSERT(newLimit < BANDWIDTH_EIGHTY_EIGHTY); // only two bits in the register 

	RegAccess_Read(REG_AGG_BUILDER_MU_MULT_USRS_TRAINING_CONTROL, &(muBfTrainingCtrlReg.val));
	muBfTrainingCtrlReg.bitFields.muMultUsrsTrainingBwLimit= newLimit;
	RegAccess_Write(REG_AGG_BUILDER_MU_MULT_USRS_TRAINING_CONTROL, muBfTrainingCtrlReg.val);
}


