/***********************************************************************************
 File:			Atf_Api.h
 Module:		Air Time Fairness 
 Purpose: 		
 Description:   
				
************************************************************************************/
#ifndef ATF_API_H_
#define ATF_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "PacketDescriptor.h"
#include "HwQManager_API.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define ATF_INIT_DIST_TYPE_DISABLED
#undef ATF_INIT_DIST_TYPE_DYNAMIC
#undef ATF_INIT_DIST_TYPE_STATIC

//ATM_DISTRIBUTION_TYPE_DISABLED

// DEBUG
//#define ATF_DEBUG_GLOBAL
//#define ATF_DEBUG_LOCAL
//#define ATF_DEBUG_HIGH




//---------------------------------------------------------------------------------
//						Enums						
//---------------------------------------------------------------------------------
typedef enum
{
    ATF_STATION_EVENT_TIMER_EXPIRED = 0,
    ATF_STATION_EVENT_SENDER_INDICATION = 1,       
    ATF_STATION_EVENT_STOP_TRAFFIC,
    ATF_STATION_NUM_OF_EVENTS,
} AtfStationEvent_e;

typedef enum
{
    ATF_STATION_STATE_IDLE = 0, // Station is not connected and ATF is Enable OR Station is connected/not_connected but ATF is Disable
    ATF_STATION_STATIC_STATE_CONNECTED_BUFFERED = 1,       
    ATF_STATION_STATIC_STATE_CONNECTED_UNBUFFERED = 2,
    ATF_STATION_STATIC_STATE_START_OF_WAIT = 3,
    ATF_STATION_STATIC_STATE_CONNECTED_WAIT_FOR_HOSTINTERFACE = ATF_STATION_STATIC_STATE_START_OF_WAIT,
    ATF_STATION_STATIC_STATE_CONNECTED_WAIT_FOR_HOSTINTERFACE_STOP_UNBUFFER =4 ,
    ATF_STATION_STATIC_STATE_CONNECTED_WAIT_FOR_HOSTINTERFACE_STOP_DROP = 5,
    ATF_STATION_STATIC_STATE_CONNECTED_WAIT_FOR_LOCK = 6,
    ATF_STATION_STATIC_STATE_CONNECTED_WAIT_FOR_LOCK_STOP_UNBUFFER = 7,
    ATF_STATION_STATIC_STATE_CONNECTED_WAIT_FOR_LOCK_STOP_DROP = 8,
    ATF_STATION_STATIC_STATE_END_OF_WAIT = ATF_STATION_STATIC_STATE_CONNECTED_WAIT_FOR_LOCK_STOP_DROP,
    ATF_STATION_STATIC_STATE_NUM_OF_STATES,
    ATF_STATION_DYNAMIC_STATE_CONNECTED_AIR_TIME_LIMITED = 1,
    ATF_STATION_DYNAMIC_STATE_NUM_OF_STATES,
} AtfStationState_e;

//---------------------------------------------------------------------------------
//						Externals						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
// ATF manager data base
typedef struct AtfMsg_
{ 
  	uint32 stationId;
} AtfMsg_t;

// ATF manager data base
typedef struct AtfAgeingMsg_
{ 
  	uint8 AgeingTtlCriteria;
  	uint8 AgeingEnable;
  	uint8 end_of_interval_ttl;
} AtfAgeingMsg_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

void Atf_TaskEntry(K_MSG *psMsg);
bool filterManagmentsPd(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams, HwQueueManagerRequestParams_t *hwQueueManagerRequestParamsMng);
bool filterAgedPd(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams, HwQueueManagerRequestParams_t *hwQueueManagerRequestParamsAged, uint8 bandId);
void Atf_Manager_pushToStack(StaId stationId, uint8 bandId);
StaId popFromStack(uint8 bandId);
void Atf_Manager_setAgeing(uint32 interval, uint8 bandId);
void Atf_Manager_sendQosMsg(AtmDistributionType_e newAtmDistributionType, uint8 bandId);
void Atf_Manager_sendHimMsg(uint8 bandId);
AtfErrorCode_e Atf_Manager_ValidateStationConnected(GRANT_SIZE grants[HW_NUM_OF_STATIONS], uint8 bandId);
void Atf_Buffering_lockReqHandler(StaId stationId, uint8 bandId);
void Atf_Buffering_lockReq(StaId stationId, uint8 bandId);
void Atf_Buffering_himBufferReq(void* eventInfo);
void Atf_Buffering_unbufferPushBuffered(StaId stationId, HwQMangerDlmNum_e dlmNum, uint8 dplIndex);
void Atf_Buffering_unbufferDropToLiberator(StaId stationId);
void Atf_Buffering_setStateWaitHimStopUnbuffer(void* eventInfo);
void Atf_Buffering_setStateWaitHimStopDrop(void* eventInfo);
void Atf_Buffering_setStateWaitHim(void* eventInfo);
void Atf_Buffering_setStateWaitLockStopUnbuffer(void* eventInfo);
void Atf_Buffering_setStateWaitLockStopDrop(void* eventInfo);
void Atf_Buffering_setStateWaitLock(void* eventInfo);
void Atf_Buffering_IllegalEvent(void* eventInfo);
void Atf_Buffering_DoNothing(void* eventInfo);
void Atf_Manager_TransitionReqMsg(K_MSG *psMsg);
void Atf_Buffering_timerExpiredMsg(K_MSG *psMsg);
void Atf_Buffering_setTtlCriteria(K_MSG *psMsg);
void Atf_Manager_decreseTotalStations(StaId stationId);
void Atf_Manager_increaseTotalStations(StaId stationId);
void Atf_Buffering_lockCfmMsg(K_MSG *psMsg);
void Atf_Buffering_himBufferCfmMsg(K_MSG *psMsg);
void Atf_Buffering_senderStopTxMsg(K_MSG *psMsg);
void Atf_Buffering_dropAllBuffered(K_MSG *psMsg);

void Atf_Buffering_PushPacketToTail(TxPd_t* pDesc);
void Atf_Buffering_PushListToHead(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams, StaId stationId, uint8 tidCurr);    

AtfStationState_e Atf_GetStationState(StaId stationId);

void Atf_Manager_init(void);



#endif /* ATF_API_H_ */

