/***************************************************************
 File:		Atf.h
 Module:	Atf
 Purpose: 	
 Description:  
***************************************************************/
#ifndef ATF_H_
#define ATF_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "mhi_umi.h"
#include "HwGlobalDefinitions.h"
#include "Atf_Api.h"
#include "linkAdaptation_api.h"



//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define TXOP_LIMIT_SIZE uint16 // limitd stuck size 
#define TXOP_LIMIT_SIZE_STATIC uint32
#define TXOP_LIMIT_SIZE_DYNAMIC uint16

#define BUFFERD_PD_NULL NEXT_PD_NULL
#define ATF_USED_AC 0 // arbitrary used ac in statistc dyst type, per station don't mind ac
#define ATF_USED_VAP_DIST_TYPE 0 // cuurently we have dist type only for radio, so we will use vap0 as radio
#define GRANT_DEFAULT 0 // the grant eash station should start with
#define ATF_INVALID_LOCK_IDX				(MAX_UINT8)
#define ATF_MAX_LOCK_ELEMENTS				(0x0F)

#define ATF_DYNAMIC_PSDU_RESOLUTION			(7)
#define ATF_DYNAMIC_PSDU_ABS_MINIMUM_TIME_US    ((0x1 << ATF_DYNAMIC_PSDU_RESOLUTION) - 1)
#define ATF_DYNAMIC_PSDU_DEFAULT_MINIMUM_TIME_US    MED_TRANSMISSION_TIME
#define ATF_MAX_GRANT    10000

#define	ATF_MAX_OF_SUPPORTED_STATIONS	(HW_NUM_OF_STATIONS)
#define	ATF_SIZE_OF_STATIONS_BITMAP_IN_WORDS	(ATF_MAX_OF_SUPPORTED_STATIONS >> 5)
#define	ATF_MAX_OF_SUPPORTED_STATIONS_BITMAP_SIZE	((ATF_MAX_OF_SUPPORTED_STATIONS + 7)>>3)


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

#define SET_TO_BUFFER_LIST(pDesc) CONVERT_PD_TO_OFFSET(pDesc)
#define GET_FROM_BUFFER_LIST(offset) CONVERT_OFFSET_TO_PD(offset)

#define MICRO_TO_MILI_SEC(time) (time >> 10)

#define ATF_CLR_BIT_IN_BITMAP(bitmap,offset)  (bitmap)[(offset >> 5)] &= ~(1 << ((offset) & 0x1F))
#define ATF_SET_BIT_IN_BITMAP(bitmap,offset)  (bitmap)[(offset >> 5)] |= (1 << ((offset) & 0x1F))
#define ATF_GET_BIT_IN_BITMAP(bitmap,offset)  ((((bitmap)[(offset >> 5)] & (1 << ((offset) & 0x1F)))) >> ((offset) & 0x1F))



//---------------------------------------------------------------------------------
//						Enums						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//--------------------------------------------------------------------------------- 

typedef struct AtfStationBitmap
{
	uint32 staBitMap[ATF_SIZE_OF_STATIONS_BITMAP_IN_WORDS];
}AtfStationBitmap_t;

// ATF manager data base
typedef struct AtfDb_s
{
  	uint32 interval; // microsec
    AtmDistributionType_e AtmDistributionType; // ATF current dist type
  	K_MSG *psMsg;
	uint32 timerMsgId;
    int16 TotalStationsAtfActive; // count any station that connected and not in Idle state. * can be negative value for assert check
  	uint8 AgeingTtlCriteria;
  	uint8 AgeingEnable;
  	uint8 end_of_interval_ttl;
  	uint8 duringDisabling;    
    StaId lockStack[ATF_MAX_LOCK_ELEMENTS]; // hold next stationId to lock
    uint8 lockStackTop;
    uint8 lockBusy;
	AtfStationBitmap_t AtfStationsPendingStopTraffic; // ATF station wait for stop traffic, 1 = pending to stop traffic, 0 = not waiting for stop traffic
	AtfStationBitmap_t AtfStationsActive; // ATF station active in the ATF "game", 1 = station is active, 0 station is not in grant list and not active in ATF
	AtfStationBitmap_t AtfStationsConnected; // ATF stations 1 = station is connected, 0 station is not in grant list and not active in ATF
} AtfDb_t;

typedef struct AtfBufferedList_s
{
    uint32 head;
    uint32 tail;
} AtfBufferedList_t;

typedef struct AtfStationsDb_s
{
    AtfStationState_e state[HW_NUM_OF_STATIONS]; // AtfStationStateStatic_e OR AtfStationStateDynamic_e
} AtfStationsDb_t;

typedef void (*AtfBufferingSmHandler)(void*);

typedef struct AtfSm_s
{
	AtfBufferingSmHandler handler[ATF_STATION_NUM_OF_EVENTS];	
} AtfSm_t;


/*---------------------------------------------------------------------------------
/						Function Declaration									
/----------------------------------------------------------------------------------*/
void Atf_Manager_stopTrafficMsg(K_MSG *psMsg);
void Atf_Manager_AddStaMsg(K_MSG *psMsg);

AtfErrorCode_e Atf_Manager_transition(AtmDistributionType_e newAtmDistributionType, AtmAlgorithmType_e newAtmAlgorithmType, AtmWeightedType_e newAtmWeightedType, GRANT_SIZE stationGrant[HW_NUM_OF_STATIONS], uint32 interval, uint32 freeTime, uint8 bandId);
AtfErrorCode_e Atf_Manager_checkParametersValidityDynamic(AtmAlgorithmType_e newAtmAlgorithmType, GRANT_SIZE grants[HW_NUM_OF_STATIONS], uint32 interval, uint8 bandId);
AtfErrorCode_e Atf_Manager_checkParametersValidityStatic(AtmAlgorithmType_e newAtmAlgorithmType, GRANT_SIZE grants[HW_NUM_OF_STATIONS], uint32 interval, uint8 bandId);
void Atf_Manager_disable(uint8 bandId);
bool Atf_Manager_GetNextStationBitmap(StaId *stationId_p, AtfStationBitmap_t *AtfStations);

void Atf_GrantCalc_dynamicWeighted(GRANT_SIZE grants[HW_NUM_OF_STATIONS], uint8 bandId);
void Atf_GrantCalc_staticWeighted(GRANT_SIZE grants[HW_NUM_OF_STATIONS], uint32 interval,uint32 freeTime, uint8 bandId);
void Atf_GrantCalc_dynamicWeightedCommon(uint8 bandId);

void Atf_GrantCalc_dynamicGlobal(uint32 interval, uint8 bandId);
    
void Atf_Buffering_unbufferHim(StaId stationId);
void Atf_Buffering_himBufferCfmHandler(StaId stationId, uint8 bandId);
void Atf_Buffering_stopTrafficHandler(void* eventInfo);

void Atf_Buffering_unbuffer(void* eventInfo);
void Atf_Buffering_unbufferPushToQueues(StaId stationId);
void Atf_Buffering_drop_buffered(void* eventInfo);
bool Atf_Buffering_isInWaitState(StaId stationId);

void Atf_Buffering_flushStationQueues(void* eventInfo);
void Atf_buffering_StaSmRun(AtfStationEvent_e event, StaId stationId, void* eventInfo);

void Atf_SetStationState(StaId stationId, AtfStationState_e state);
void Atf_SetStateIdle(void* eventInfo);
void Atf_GrantCalc_updateTxopTimeThreshold(uint16 txopTimeThreshold, uint8 bandId);

bool Atf_Manager_checkAgeingCondition(uint8 ttlCount, uint8 bandId);

AtfStationState_e Atf_GetStationState(StaId stationId);

#endif /*ATF_H_ */
