/********************************************************************************
 File:			AutoResponse_Api.h
 Module:	  		Auto Response (incliding Block ACK Generator)
 Purpose: 		holds all the definitions of the Auto Response API functions
 Description:  		This file is the API to the Auto Response module
				which is responsible of sending auto-reply frames (ACK/BACK/CTS/BF) 
*********************************************************************************/
#ifndef AUTO_RESPONSE_API_H_
#define AUTO_RESPONSE_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "AutoRespErrFifo_Descriptors.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define AUTO_RESPONSE_ERROR_FIFO_SIZE 	(64) // Max allowed size if 256
#define AUTO_RESPONSE_ERROR_FIFO_SIZE_MASK  (AUTO_RESPONSE_ERROR_FIFO_SIZE - 1)



//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct _AutoResponseDb_
{
	uint32 fifoReadIndex; // Next entry to read from FW		
	uint32 fifoFullCounter; // Number of times error fifo was full
	uint32 errorFifoSnOutOfBoundCounter; // Number of times we encountered SN out of bound (TID error).
	uint32 multiTidErrCounter; // Number of times we got Multi-TID error.
} AutoResponseDb_t;



typedef struct _AutoResponseFifoParams_
{
	uint16 currentIndexInFifo;
	uint16 numOfValidEntries;
} AutoResponseFifoParams_t;


typedef enum
{
	AUTO_RESPONSE_ERROR_TYPE_PER_USER	= 0x1, // An error per user
	AUTO_RESPONSE_ERROR_TYPE_PER_TID	= 0x2, // An error per user per TID
} AutoResponseErrorType_e;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

void AutoResponse_ErrorFifoNotEmpty(void);
void AutoResponse_EnableDisableLogger(bool isEnable);
void AutoResponse_ConfigureLoggerParams(bool sendAllLogs, uint8 counterLimit);
void AutoResponse_Enable(bool enable);
void AutoResponse_Init(void);
#if defined (ENET_INC_ARCH_WAVE600B)
void AutoResponse_SetVapAsStaMode(uint8 vapId);
#endif




#endif /* AUTO_RESPONSE_API_H_ */


