/**********************************************************************************
 File:			AutoResponse.h
 Module:	  		Auto Response (incliding Block ACK Generator)
 Purpose: 		holds all the definitions of the Auto Response
 Description:  		This is the header file for the the Auto Response module
				which is responsible of sending auto-reply frames (ACK/BACK/CTS/BF) 
***********************************************************************************/
#ifndef AUTO_RESPONSE_H_
#define AUTO_RESPONSE_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "AutoResponse_Api.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
	AUTO_RESPONSE_ACK_ON_BAR_DISABLE	= 0,
	AUTO_RESPONSE_ACK_ON_BAR_ENABLE		= 1,
} AutoResponseAckOnBarPolicy_e;

typedef enum
{
	AUTO_RESPONSE_DYNAMIC_BITMAP_SIZE_ENABLE	= 0,
	AUTO_RESPONSE_DYNAMIC_BITMAP_SIZE_DISABLE	= 1,
} AutoResponseDynamicBitmap_e;

typedef enum
{
	AUTO_RESPONSE_ADD_MANAGEMENT_TID_TO_MULTI_TID_COUNT_DISABLE	= 0,
	AUTO_RESPONSE_ADD_MANAGEMENT_TID_TO_MULTI_TID_COUNT_ENABLE	= 1,
} AutoResponseManagementTidCounting_e;

typedef enum
{
	AUTO_RESPONSE_TAKE_WINDOW_SIZE_FROM_BAR_CONTROL		= 0,
	AUTO_RESPONSE_TAKE_WINDOW_SIZE_FROM_BA_AGREEMENT	= 1,
} AutoResponseBarWindowSize_e;

typedef enum
{
	AUTO_RESPONSE_RECIPIENT_TRAFFIC_INDICATION_BITMAP_UPDATE_DISABLE	= 0,
	AUTO_RESPONSE_RECIPIENT_TRAFFIC_INDICATION_BITMAP_UPDATE_ENABLE		= 1,
} AutoResponseRecipientTrafficIndicationBitmap_e;

typedef enum
{
	AUTO_RESPONSE_FORCE_USER_DB_CLEAR_AT_NEW_RX_DISABLE	= 0,
	AUTO_RESPONSE_FORCE_USER_DB_CLEAR_AT_NEW_RX_ENABLE	= 1,
} AutoResponseForceUserDbClearAtNewRx_e;

typedef enum
{
	AUTO_RESPONSE_USE_EXTENDED_BITMAP_FOR_SINGLE_USER_DISABLE	= 0,
	AUTO_RESPONSE_USE_EXTENDED_BITMAP_FOR_SINGLE_USER_ENABLE	= 1,
} AutoResponseUseExtendedBitmapForSingleUser_e;



//---------------------------------------------------------------------------------
//						Prototypes				
//---------------------------------------------------------------------------------

void autoResponse_GetFifoParameters(AutoResponseFifoParams_t *fifoParams);
void autoResponse_SetFifoParameters(AutoResponseFifoParams_t *fifoParams);
void autoResponse_CheckFifoError(void);


#endif /* AUTO_RESPONSE_H_ */

