/***********************************************************************************
 File:		BSSmanager_API.h
 Module:		BSSmanager
 Purpose: 		
 Description:   
 
************************************************************************************/
#ifndef BSS_MANAGER_API_H
#define BSS_MANAGER_API_H

/****************************************************************************/
/* Includes                                                                 */
/****************************************************************************/
#include "System_GlobalDefinitions.h"
#include "frame.h"
#include "protocol.h"
#include "database.h"
#include "frame.h"
#if defined (ENET_INC_UMAC)
#include "Utils_Api.h"
#endif 

/****************************************************************************/
/* Defines                                                                  */
/****************************************************************************/
#define SEQUENCE_NUMBER_OFFSET	(22) // Offset of Sequence number from beginning of header (beacon part 1)

/***********************************************************************/
/* Macros						*/
/***********************************************************************/
#define FILL_VAP_MANAGER_CONFIRM_MSG(m, v, e, c)	\
	do {((BSS_MANAGER_CONFIRM_EVENT*)&(m->abData))->vapId= v; \
		  OSAL_SET_MESSAGE_ORIGINATOR(m); \
		((BSS_MANAGER_CONFIRM_EVENT*)&(m->abData))->eventIndex = e;	\
		((BSS_MANAGER_CONFIRM_EVENT*)&(m->abData))->clientId = c;	\
		} while(0);

#define EXTRACT_VAP_MANAGER_MSG(M)		pK_MSG_DATA((K_MSG *) (*((uint32 *)pK_MSG_DATA(M))))

/****************************************************************************/
/* Data Types                                                               */
/****************************************************************************/

/* Local parameters for BSS state machine module */
typedef struct _bssManagerDb_t
{
	K_MSG*  			 savedManMsg;         /* saved management message from host */
} bssManagerDb_t; 

/*BSS Manager STA manager registration types*/
typedef enum
{
	BSS_MANAGER_STA_OPEN_REG,
	BSS_MANAGER_STA_POST_OPEN_REG,
	BSS_MANAGER_STA_SET_FILTER_REG,
	BSS_MANAGER_STA_POST_SET_FILTER_REG,
	BSS_MANAGER_STA_STOP_TRAFFIC_REG,
	BSS_MANAGER_STA_POST_STOP_TRAFFIC_REG,
	BSS_MANAGER_STA_CLOSING_REG,
	BSS_MANAGER_STA_POST_CLOSING_REG,
	BSS_MANAGER_STA_NUM_REG
} bssManagerRegTypes;

typedef struct BssManagerStaManagerReq_t
{
	K_MSG  *psMsg;
} BssManagerStaManagerReq_t;

typedef struct BssManagerSetTemplateReq_s
{
	K_MSG  *psMsg;
} BssManagerSetTemplateReq_t;

/*BSS Manager STA manager confirmation message*/
typedef struct BssManagerStaManagerCfm_s
{
	StaId sid;
	uint8 clientId;
} BssManagerStaManagerCfm_t;


typedef struct _BssManagerVapManagerReq_t
{
	K_MSG  *psMsg;
} BssManagerVapManagerReq_t;


typedef enum 
{
	VAP_MANAGER_ADD_VAP,
	VAP_MANAGER_POST_VAP_ADDITION,
	VAP_MANAGER_SET_BSS,
	VAP_MANAGER_POST_SET_BSS,
	VAP_MANAGER_SET_WMM_PARAMS,
	VAP_MANAGER_POST_VAP_ACTIVATION, 
	VAP_MANAGER_REMOVE_VAP,
	VAP_MANAGER_POST_VAP_REMOVAL,
	VAP_MANAGER_STOP_TRAFFIC, 
	VAP_MANAGER_POST_STOP_TRAFFIC,
	VAP_MANAGER_INVALID_EVENT, 
	TOTAL_VAP_MANAGER_EVENTS = VAP_MANAGER_INVALID_EVENT,
} vapManagerEvents_e;

typedef struct BSS_MANAGER_CONFIRM_EVENT
{
	uint8 				clientId;
	uint8 				vapId; 
    vapManagerEvents_e 	eventIndex;
} BSS_MANAGER_CONFIRM_EVENT;



#define NUM_OF_CLIENT_TO_BSS_MANAGER_STA_OPEN_REG				(10)//BSS_MANAGER_STA_OPEN_REG,

#define NUM_OF_CLIENT_TO_BSS_MANAGER_STA_SET_FILTER_REG			(4)//BSS_MANAGER_STA_SET_FILTER_REG,
#define NUM_OF_CLIENT_TO_BSS_MANAGER_STA_POST_SET_FILTER_REG	(1)//BSS_MANAGER_STA_POST_SET_FILTER_REG,

#define NUM_OF_CLIENT_TO_BSS_MANAGER_STA_STOP_TRAFFIC_REG		(10)//BSS_MANAGER_STA_STOP_TRAFFIC_REG,
#define NUM_OF_CLIENT_TO_BSS_MANAGER_STA_POST_OPEN_REG			(4)//BSS_MANAGER_STA_POST_OPEN_REG,

#define NUM_OF_CLIENT_TO_BSS_MANAGER_STA_POST_STOP_TRAFFIC_REG	(1)//BSS_MANAGER_STA_POST_STOP_TRAFFIC_REG,
#define NUM_OF_CLIENT_TO_BSS_MANAGER_STA_CLOSING_REG			(5)//BSS_MANAGER_STA_CLOSING_REG,
#define NUM_OF_CLIENT_TO_BSS_MANAGER_STA_POST_CLOSING_REG		(1)//BSS_MANAGER_STA_POST_CLOSING_REG,



typedef enum 
{
	BSS_MANAGER_STA_MANAGER_LA_CLIENT = 0,//must be 0, used by lower MAC
	BSS_MANAGER_STA_MANAGER_SMPS_CLIENT,
	BSS_MANAGER_STA_MANAGER_TS_CLIENT, 
	BSS_MANAGER_STA_MANAGER_STAT_CLIENT,
	BSS_MANAGER_STA_MANAGER_QOS_CLIENT,
	BSS_MANAGER_STA_MANAGER_HIM_CLIENT,
	BSS_MANAGER_STA_MANAGER_CSA_CLIENT,
#ifdef USE_AGER_EMULATOR
	BSS_MANAGER_STA_MANAGER_AGER_CLIENT,
#endif //#ifdef USE_AGER_EMULATOR
	BSS_MANAGER_STA_MANAGER_SEC_CLIENT,
	BSS_MANAGER_STA_MANAGER_TX_CLIENT,
	BSS_MANAGER_STA_MANAGER_TXM_CLIENT,
	BSS_MANAGER_STA_MANAGER_RXM_CLIENT,
	BSS_MANAGER_STA_MANAGER_GM_CLIENT,
	BSS_MANAGER_STA_MANAGER_ATF_CLIENT,
#ifdef ENET_INC_ARCH_WAVE600
	BSS_MANAGER_STA_MANAGER_PAC_CLIENT,
	BSS_MANAGER_STA_MANAGER_HE_GM_CLIENT,
	BSS_MANAGER_STA_MANAGER_TWT_CLIENT,
#endif	
	BSS_MANAGER_STA_MANAGER_HDK_CLIENT,	
	BSS_MANAGER_STA_MANAGER_MAX_CLIENTS,
} staManagerClients_e;



typedef enum 
{
	BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT = 0,
	BSS_MANAGER_VAP_MANAGER_COC_CLIENT,
	BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT,
	BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT,
	BSS_MANAGER_VAP_MANAGER_DUT_CLIENT,
	BSS_MANAGER_VAP_MANAGER_HDK_CLIENT,
	BSS_MANAGER_VAP_MANAGER_HIM_CLIENT,
	BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT,
	BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT,	
	BSS_MANAGER_VAP_MANAGER_QOS_CLIENT,
	BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT,
	BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT,
	BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT,
	BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT,
	BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT,
	BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT,
#ifdef USE_AGER_EMULATOR
	BSS_MANAGER_VAP_MANAGER_AGER_CLIENT,
#endif
	BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT,
#ifdef ENET_INC_ARCH_WAVE600
	BSS_MANAGER_VAP_MANAGER_TWT_CLIENT,
#endif
	BSS_MANAGER_VAP_MANAGER_MAX_CLIENTS,
} vapManagerClients_e;





/****************************************************************************/
/* Functions Prototypes                                                     */
/****************************************************************************/
void BssManager_Init(void);
void BssManager_Task(K_MSG* psMsg);


/***************************************/
/*  To be part of the channel configuration     */ 
/**************************************/
void BssManager_StartActivateProcess(K_MSG *psMsg);
void BssManager_FinalizeActivateProcess(K_MSG *psMsg);
void BssManager_VapManager_StartAddVapProcess(K_MSG* psMsg);
void BssManager_VapManager_FinalizeAddVapProcess(K_MSG* psMsg);
void BssManager_VapManager_StartSetBssProcess(K_MSG* psMsg);
void BssManager_VapManager_FinalizeSetBssProcess(K_MSG* psMsg);
void BssManager_VapManager_StartSetWmmParamsProcess(K_MSG* psMsg);
void BssManager_VapManager_FinalizeSetWmmParamsProcess(K_MSG* psMsg);
void BssManager_VapManager_StartRemoveVapProcess(K_MSG* psMsg) ;
void BssManager_VapManager_FinalizeRemoveVapProcess(K_MSG* psMsg) ;
K_MSG *BssManagerVapManager_GetDummyMessage(void);

/****************************************************************************/
/* Static Data                                                              */
/****************************************************************************/

#endif /* BSS_MANAGER_API_H */
